/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer;

import com.poscoict.glueframework.plugin.activity.designer.model.GlueModelManager;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class GlueActivityDiagramWizardPage
extends WizardNewFileCreationPage {
    private final IWorkbench workbench;
    private static int count = 1;

    public GlueActivityDiagramWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        super("Glue Activity Diagram Wizard", selection);
        this.setTitle("Activity Diagram");
        this.setDescription("Activity Diagram File");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName("newDiagram" + count + ".glue_uml_ad");
        super.setPageComplete(super.validatePage());
    }

    public boolean finish() {
        IFile newFile = super.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            GlueModelManager manager = new GlueModelManager();
            manager.createGlueDiagram(newFile.getFullPath());
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ++count;
        return true;
    }
}

