/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.designer;

import com.poscoict.glueframework.plugin.activity.designer.GlueFactory;
import com.poscoict.glueframework.plugin.activity.model.impl.GlueActivityImpl;
import com.poscoict.glueframework.plugin.activity.model.impl.GlueFinalStateImpl;
import com.poscoict.glueframework.plugin.activity.model.impl.GlueInitialStateImpl;
import com.poscoict.glueframework.plugin.project.startup.GlueProjectPlugin;
import com.poscoict.glueframework.schema.plugin.config.parser.GlueConfigInfo;
import com.poscoict.glueframework.schema.plugin.config.parser.GlueConfigParser;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class GlueActivityDesignerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.poscoict.glueframework.plugin.activity.designer";
    public static final String GLUE_SDK_LOCATION = "GLUE_SDK_LOCATION";
    public static final String GLUE_USER_LIB_SET_BOOLEAN = "GLUE_USER_LIB_SET_BOOLEAN";
    private static GlueActivityDesignerPlugin plugin;
    private static GlueConfigInfo configInfo;

    static {
        configInfo = GlueActivityDesignerPlugin.parseEclipseConfig();
    }

    public GlueActivityDesignerPlugin() {
        if (plugin == null) {
            plugin = this;
        }
    }

    public static GlueActivityDesignerPlugin getDefault() {
        return plugin;
    }

    private static PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup("Control Group");
        PanningSelectionToolEntry tool = new PanningSelectionToolEntry();
        root.setDefaultEntry((ToolEntry)tool);
        controlGroup.add((PaletteEntry)tool);
        controlGroup.add((PaletteEntry)new MarqueeToolEntry());
        controlGroup.add((PaletteEntry)new PaletteSeparator());
        tool = new ConnectionCreationToolEntry("Control Flow", "Control Flow", null, ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/connection16.gif"), ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/connection24.gif"));
        controlGroup.add((PaletteEntry)tool);
        return controlGroup;
    }

    private static PaletteContainer createComponentsDrawer() {
        PaletteDrawer drawer = new PaletteDrawer("components", ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/comp.gif"));
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("InitialState", "create InitialState", (Object)"InitialState template", (CreationFactory)new SimpleFactory(GlueInitialStateImpl.class), ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/initialState.gif"), ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/initialState.gif"));
        drawer.add((PaletteEntry)combined);
        combined = new CombinedTemplateCreationEntry("FinalState", "create FinalState", (Object)"FinalState template", (CreationFactory)new SimpleFactory(GlueFinalStateImpl.class), ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/finalState.gif"), ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/finalState.gif"));
        drawer.add((PaletteEntry)combined);
        combined = new CombinedTemplateCreationEntry("Activity", "create Activity", (Object)"activity template", (CreationFactory)new SimpleFactory(GlueActivityImpl.class), ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/activity.gif"), ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)"icons/activity.gif"));
        drawer.add((PaletteEntry)combined);
        for (GlueConfigInfo.GlueActivityInfo activityInfo : configInfo.getActivityInfoList()) {
            if (activityInfo.isAddSeperator()) {
                drawer.add((PaletteEntry)new PaletteSeparator());
            }
            String name = activityInfo.getName();
            String bubleTip = activityInfo.getBubbleTip();
            String template = activityInfo.getTemplate();
            String icon = activityInfo.getIcon();
            combined = new CombinedTemplateCreationEntry(name, bubleTip, (Object)template, (CreationFactory)new GlueFactory(GlueActivityImpl.class, name), ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)icon), ImageDescriptor.createFromFile(GlueActivityDesignerPlugin.class, (String)icon));
            drawer.add((PaletteEntry)combined);
        }
        return drawer;
    }

    public static PaletteRoot createPalette() {
        PaletteRoot gluePalette = new PaletteRoot();
        gluePalette.add((PaletteEntry)GlueActivityDesignerPlugin.createControlGroup(gluePalette));
        gluePalette.add((PaletteEntry)GlueActivityDesignerPlugin.createComponentsDrawer());
        return gluePalette;
    }

    public static GlueConfigInfo getGlueConfigInfo() {
        if (configInfo == null) {
            configInfo = GlueActivityDesignerPlugin.parseEclipseConfig();
        }
        return configInfo;
    }

    private static GlueConfigInfo parseEclipseConfig() {
        IPreferenceStore store = GlueProjectPlugin.getDefault().getPreferenceStore();
        String configFilePath = String.valueOf(store.getString(GLUE_SDK_LOCATION)) + File.separator + "config" + File.separator + "glue-config.xml";
        try {
            return GlueConfigParser.getInstance().parseXml(new File(configFilePath));
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Glue Error", (String)"Can not parse the GLUE eclipse config file", (IStatus)new Status(4, PLUGIN_ID, 0, e.getLocalizedMessage(), (Throwable)e));
            return new GlueConfigInfo();
        }
    }
}

