/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.project.startup.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GlueEclipseProjectUtil {
    public static IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static List<String> getProjectSourcePathList(String projectName) throws CoreException {
        ArrayList<String> sourcePathList = new ArrayList<String>();
        IProject project = GlueEclipseProjectUtil.getProject(projectName);
        String projectPath = project.getLocation().toOSString();
        if (project != null && project.isOpen()) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getContentKind() == 1) {
                    String sourcePath = classpathEntry.getPath().toOSString().replaceFirst(projectName, "");
                    sourcePathList.add(String.valueOf(projectPath) + sourcePath);
                }
                ++n2;
            }
        }
        return sourcePathList;
    }

    public static String[] getProjectSourcePaths(String projectName) throws CoreException {
        ArrayList<String> sourcePathList = new ArrayList<String>();
        IProject project = GlueEclipseProjectUtil.getProject(projectName);
        String projectPath = project.getLocation().toOSString();
        if (project != null && project.isOpen()) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getContentKind() == 1) {
                    String sourcePath = classpathEntry.getPath().toOSString().replaceFirst(projectName, "");
                    sourcePathList.add(String.valueOf(projectPath) + sourcePath);
                }
                ++n2;
            }
        }
        return sourcePathList.toArray(new String[sourcePathList.size()]);
    }

    public static List<String> getFileList(String extension, String ... directoryPaths) {
        ArrayList<String> fileList = new ArrayList<String>();
        String[] stringArray = directoryPaths;
        int n = directoryPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String directoryPath = stringArray[n2];
            File directory = new File(directoryPath);
            if (directory.exists()) {
                if (directory.isFile() && !directory.isHidden() && directory.getName().endsWith("." + extension)) {
                    fileList.add(directory.getAbsolutePath());
                } else if (directory.isDirectory() && !directory.isHidden()) {
                    File[] files;
                    File[] fileArray = files = directory.listFiles();
                    int n3 = files.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file = fileArray[n4];
                        if (file.isDirectory()) {
                            String subDirectory = String.valueOf(directoryPath) + File.separator + file.getName();
                            fileList.addAll(GlueEclipseProjectUtil.getFileList(extension, subDirectory));
                        } else if (file.isFile() && file.getName().endsWith("." + extension)) {
                            fileList.add(file.getAbsolutePath());
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return fileList;
    }
}

