/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.project.startup.preferences;

import com.poscoict.glueframework.plugin.project.startup.GlueProjectPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class GlueFrameworkPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String GLUE_LIB = "/lib/gluelib";
    private static final String GLUE_STD = "/lib/gluestd";
    private static final String GLUE_STD_HIBERNATE = "/lib/gluestd_hibernate";
    private static final String GLUE_STD_MYBATIS = "/lib/gluestd_mybatis";
    private static final String GLUE_STD_PORTLET = "/lib/gluestd_portlet";
    private static final String GLUE_STD_WS = "/lib/gluestd_ws";
    private GlueSDKDirectoryFieldEditor sdkLocationField;
    private BooleanFieldEditor userLibBooleanField;

    public GlueFrameworkPreferencePage() {
        super(1);
        super.setPreferenceStore(GlueProjectPlugin.getDefault().getPreferenceStore());
        super.setDescription("Glue Framework Preference");
    }

    public void createFieldEditors() {
        this.sdkLocationField = new GlueSDKDirectoryFieldEditor("GLUE_SDK_LOCATION", "Glue SDK Location :", super.getFieldEditorParent());
        this.userLibBooleanField = new BooleanFieldEditor("GLUE_USER_LIB_SET_BOOLEAN", "Apply User Library", super.getFieldEditorParent());
        String[][] labelAndValues = new String[][]{{"Dialog", "dialog"}, {"View", "view"}};
        RadioGroupFieldEditor activityEditorField = new RadioGroupFieldEditor("GLUE_ACTIVITY_PROPERTY_EDITOR", "Activity Property Editor", 2, labelAndValues, super.getFieldEditorParent(), true);
        BooleanFieldEditor confirmClassGenerateField = new BooleanFieldEditor("GLUE_CONFIRM_CLASS_GENERATE", "Confirm Class Generate", super.getFieldEditorParent());
        super.addField((FieldEditor)this.sdkLocationField);
        super.addField((FieldEditor)this.userLibBooleanField);
        super.addField((FieldEditor)activityEditorField);
        super.addField((FieldEditor)confirmClassGenerateField);
    }

    public void init(IWorkbench workbench) {
        GlueFrameworkPreferencePage.initializeDefaults(GlueProjectPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.setGlueLibs();
        return super.performOk();
    }

    public static void initializeDefaults(IPreferenceStore store) {
        store.setDefault("GLUE_USER_LIB_SET_BOOLEAN", true);
        store.setDefault("GLUE_CONFIRM_CLASS_GENERATE", true);
    }

    private void setGlueLibs() {
        if (!this.userLibBooleanField.getBooleanValue()) {
            return;
        }
        String location = this.sdkLocationField.getGlueSDKLocation();
        this.checkUserLibSet();
        this.setGlueLibs("GLUE_CORE", String.valueOf(location) + GLUE_LIB);
        this.setGlueLibs("GLUE_STD", String.valueOf(location) + GLUE_STD);
        this.refreshUserLib();
    }

    private void checkUserLibSet() {
        List preferenceNodeList = WorkbenchPlugin.getDefault().getPreferenceManager().getElements(0);
        try {
            for (IPreferenceNode node : preferenceNodeList) {
                IPreferencePage page = node.getPage();
                if (page == null || !"org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage".equals(node.getId())) continue;
                page.performOk();
                break;
            }
        }
        catch (Exception exception) {
            super.setErrorMessage(JFaceResources.getString((String)"Error performing user library"));
        }
    }

    private void setGlueLibs(String userLibraryName, String location) {
        try {
            IJavaProject javaProject = this.createPlaceholderProject();
            ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.jdt.USER_LIBRARY");
            CPUserLibraryElement userLibElement = new CPUserLibraryElement(userLibraryName, false, null);
            CPListElement newArchive = null;
            List<String> jarNameList = this.getJarListInDirectory(location);
            for (String jarName : jarNameList) {
                newArchive = new CPListElement((Object)userLibElement, null, 1, (IPath)new Path(String.valueOf(location) + "/" + jarName), null);
                userLibElement.add(newArchive);
            }
            IClasspathContainer updatedContainer = userLibElement.getUpdatedContainer();
            initializer.requestClasspathContainerUpdate(userLibElement.getPath(), javaProject, updatedContainer);
            JavaCore.setClasspathContainer((IPath)userLibElement.getPath(), (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{updatedContainer}, null);
        }
        catch (Exception exception) {
            super.setErrorMessage(JFaceResources.getString((String)"error setting glue core libraries"));
        }
    }

    private void refreshUserLib() {
        List preferenceNodeList = WorkbenchPlugin.getDefault().getPreferenceManager().getElements(0);
        try {
            for (IPreferenceNode node : preferenceNodeList) {
                IPreferencePage page = node.getPage();
                if (page == null || !"org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage".equals(node.getId())) continue;
                node.createPage();
                break;
            }
        }
        catch (Exception exception) {
            super.setErrorMessage(JFaceResources.getString((String)"Error user library"));
        }
    }

    private IJavaProject createPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + "#";
        }
        return JavaCore.create((IProject)project);
    }

    private List<String> getJarListInDirectory(String path) {
        ArrayList<String> jarList = new ArrayList<String>();
        try {
            File file = new File(path);
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    if (fileName.endsWith(".jar")) {
                        jarList.add(fileName);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            super.setErrorMessage(e.getMessage());
        }
        return jarList;
    }

    private class GlueSDKDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public GlueSDKDirectoryFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            super.setEmptyStringAllowed(false);
        }

        protected boolean doCheckState() {
            String sdkDirectory = this.getGlueSDKLocation().trim();
            File directory = new File(sdkDirectory);
            if (!directory.exists() || !directory.isDirectory()) {
                super.setErrorMessage(JFaceResources.getString((String)("Glue SDK directory does not found : " + directory.getAbsolutePath())));
                return false;
            }
            directory = new File(String.valueOf(sdkDirectory) + GlueFrameworkPreferencePage.GLUE_LIB);
            if (!directory.exists() || !directory.isDirectory()) {
                super.setErrorMessage(JFaceResources.getString((String)("Glue Core Library directory does not found : " + directory.getAbsolutePath())));
                return false;
            }
            directory = new File(String.valueOf(sdkDirectory) + GlueFrameworkPreferencePage.GLUE_STD);
            if (!directory.exists() || !directory.isDirectory()) {
                super.setErrorMessage(JFaceResources.getString((String)("Glue Standard Library directory does not found : " + directory.getAbsolutePath())));
                return false;
            }
            directory = new File(String.valueOf(sdkDirectory) + GlueFrameworkPreferencePage.GLUE_STD_HIBERNATE);
            if (!directory.exists() || !directory.isDirectory()) {
                super.setErrorMessage(JFaceResources.getString((String)("Glue Hibernate Library directory does not found : " + directory.getAbsolutePath())));
            }
            if (!(directory = new File(String.valueOf(sdkDirectory) + GlueFrameworkPreferencePage.GLUE_STD_MYBATIS)).exists() || !directory.isDirectory()) {
                super.setErrorMessage(JFaceResources.getString((String)("Glue MyBatis Library directory does not found : " + directory.getAbsolutePath())));
            }
            if (!(directory = new File(String.valueOf(sdkDirectory) + GlueFrameworkPreferencePage.GLUE_STD_PORTLET)).exists() || !directory.isDirectory()) {
                super.setErrorMessage(JFaceResources.getString((String)("Glue Portlet Library directory does not found : " + directory.getAbsolutePath())));
            }
            if (!(directory = new File(String.valueOf(sdkDirectory) + GlueFrameworkPreferencePage.GLUE_STD_WS)).exists() || !directory.isDirectory()) {
                super.setErrorMessage(JFaceResources.getString((String)("Glue WebService Library directory does not found : " + directory.getAbsolutePath())));
            }
            return true;
        }

        public Text getTextControl(Composite parent) {
            super.setValidateStrategy(0);
            return super.getTextControl(parent);
        }

        public String getGlueSDKLocation() {
            return this.getTextControl().getText();
        }
    }
}

