/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.project.startup;

import com.poscoict.glueframework.plugin.project.startup.GlueProjectHelper;
import com.poscoict.glueframework.plugin.project.startup.GlueProjectPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class GlueNewProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private WizardNewProjectCreationPage wizardPage;
    private IConfigurationElement config;
    private IWorkbench workbench;
    private IProject project;
    private String projectType;

    public void addPages() {
        this.wizardPage = new WizardNewProjectCreationPage("New Glue Project");
        this.wizardPage.setDescription("Create a new Glue Project.");
        this.wizardPage.setTitle("New Glue Project");
        super.addPage((IWizardPage)this.wizardPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
        this.projectType = (String)data;
    }

    public boolean performFinish() {
        IPath newPath;
        if (this.project != null) {
            return true;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject projectHandle = workspace.getRoot().getProject(this.wizardPage.getProjectName());
        final IProjectDescription desc = workspace.newProjectDescription(projectHandle.getName());
        IPath defaultPath = Platform.getLocation();
        if (defaultPath.equals((Object)(newPath = this.wizardPage.getLocationPath()))) {
            newPath = null;
        }
        desc.setLocation(newPath);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                GlueNewProjectWizard.this.createProject(desc, projectHandle, monitor);
            }
        };
        try {
            super.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getTargetException().getMessage());
            return false;
        }
        this.project = projectHandle;
        if (this.project == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        BasicNewResourceWizard.selectAndReveal((IResource)this.project, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        return true;
    }

    private void createProject(IProjectDescription description, IProject proj, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            try {
                monitor.beginTask("", 2000);
                IPreferenceStore store = GlueProjectPlugin.getDefault().getPreferenceStore();
                String sdkLocation = store.getString("GLUE_SDK_LOCATION");
                if (sdkLocation == null || "".equals(sdkLocation)) {
                    throw new Exception("Glue SDK Location is required : please set Glue Project preference");
                }
                proj.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                proj.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                this.setupProjectNatures(proj, monitor);
                IJavaProject javaProject = JavaCore.create((IProject)proj);
                if (!"maven".equals(this.projectType)) {
                    this.setupSourceFolder(javaProject, "src/", monitor);
                    javaProject.setOutputLocation(proj.getFolder("classes/").getFullPath(), monitor);
                }
                IProject container = proj;
                String templateFolderPath = "/templateFolder";
                templateFolderPath = "maven".equals(this.projectType) ? String.valueOf(templateFolderPath) + "/maven" : String.valueOf(templateFolderPath) + "/java";
                File folder = new File(String.valueOf(sdkLocation) + templateFolderPath);
                if (!folder.exists()) {
                    throw new Exception("The Template Folder dose not exist![" + sdkLocation + templateFolderPath + "]");
                }
                File[] fileList = folder.listFiles();
                this.copyFiles(fileList, (IContainer)container, monitor, null);
                IFolder srcFolder = container.getFolder((IPath)new Path("src"));
                if (!srcFolder.exists()) {
                    srcFolder.create(true, true, monitor);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "GlueNewProjectWizard", 0, e.getLocalizedMessage(), null));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void setupProjectNatures(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project == null || !project.isOpen()) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.addNatureToProjectDescription(project, "org.eclipse.jdt.core.javanature", monitor);
        if ("maven".equals(this.projectType)) {
            this.addNatureToProjectDescription(project, "org.eclipse.m2e.core.maven2Nature", monitor);
            this.addCommandToProjectDescription(project, "org.eclipse.m2e.core.maven2Builder", monitor);
        }
    }

    private void addNatureToProjectDescription(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void addCommandToProjectDescription(IProject project, String buildCommand, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        ICommand command = commands[0];
        command.setBuilderName(buildCommand);
        commands[1] = command;
        command.setBuilderName(buildCommand);
        project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
    }

    private void setupSourceFolder(IJavaProject javaProject, String sourceFolder, IProgressMonitor monitor) throws JavaModelException {
        IPath glueLibPath;
        IProject project = javaProject.getProject();
        IFolder srcFolder = project.getFolder(sourceFolder);
        try {
            if (!srcFolder.exists()) {
                srcFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            if (!project.getFile(".classpath").exists()) {
                new ClassPathDetector(project, null);
            }
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
        }
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        entries = GlueProjectHelper.removeEntryFromClasspath(entries, srcFolder.getParent());
        entries = GlueProjectHelper.addEntryToClasspath(entries, JavaCore.newSourceEntry((IPath)srcFolder.getFullPath()));
        IClasspathEntry[] defaultJRELibEntries = PreferenceConstants.getDefaultJRELibrary();
        entries = GlueProjectHelper.addEntryToClasspath(entries, defaultJRELibEntries);
        javaProject.setRawClasspath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        List<String> userLibList = null;
        if (JavaCore.getUserLibraryNames() != null) {
            userLibList = Arrays.asList(JavaCore.getUserLibraryNames());
        }
        boolean hasGlueStdLib = false;
        boolean hasGlueCoreLib = false;
        if (userLibList != null) {
            hasGlueStdLib = userLibList.contains("GLUE_STD");
            hasGlueCoreLib = userLibList.contains("GLUE_CORE");
        }
        if (hasGlueCoreLib) {
            glueLibPath = new Path("org.eclipse.jdt.USER_LIBRARY").append("GLUE_CORE");
            entries = GlueProjectHelper.addEntryToClasspath(entries, JavaCore.newContainerEntry((IPath)glueLibPath, (boolean)true));
            javaProject.setRawClasspath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        if (hasGlueStdLib) {
            glueLibPath = new Path("org.eclipse.jdt.USER_LIBRARY").append("GLUE_STD");
            entries = GlueProjectHelper.addEntryToClasspath(entries, JavaCore.newContainerEntry((IPath)glueLibPath, (boolean)true));
            javaProject.setRawClasspath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void copyFiles(File[] dirs, IContainer container, IProgressMonitor monitor, IFolder parent) throws Exception {
        if (dirs != null) {
            File[] fileArray = dirs;
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                if (dir.isDirectory()) {
                    IFolder folder = null;
                    if (parent == null) {
                        folder = container.getFolder((IPath)new Path(dir.getName()));
                        if (!folder.exists()) {
                            folder.create(true, true, monitor);
                        }
                    } else {
                        folder = parent.getFolder((IPath)new Path(dir.getName()));
                        if (!folder.exists()) {
                            folder.create(true, true, monitor);
                        }
                    }
                    File[] files = dir.listFiles();
                    this.copyFiles(files, container, monitor, folder);
                } else {
                    FileInputStream resourceStream = new FileInputStream(dir);
                    if (parent != null) {
                        IPath path = parent.getProjectRelativePath();
                        this.addFileToProject(container, new Path(path + "/" + dir.getName()), resourceStream, monitor);
                    } else {
                        this.addFileToProject(container, new Path(dir.getName()), resourceStream, monitor);
                    }
                    ((InputStream)resourceStream).close();
                }
                ++n2;
            }
        }
    }

    private void addFileToProject(IContainer container, Path path, InputStream contentStream, IProgressMonitor monitor) throws CoreException {
        IFile file = container.getFile((IPath)path);
        if (file.exists()) {
            file.setContents(contentStream, true, true, monitor);
        } else {
            file.create(contentStream, true, monitor);
        }
    }
}

