/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.model.impl;

import com.poscoict.glueframework.plugin.activity.model.GlueDiagram;
import com.poscoict.glueframework.plugin.activity.model.GluePackage;
import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import com.poscoict.glueframework.plugin.activity.model.GlueWire;
import com.poscoict.glueframework.plugin.activity.model.GlueWireBendpoint;
import com.poscoict.glueframework.plugin.activity.model.impl.GlueObjectImpl;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class GlueWireImpl
extends GlueObjectImpl
implements GlueWire {
    private static final long serialVersionUID = -648938481474425744L;
    private static int count;
    private String id;
    private GlueSubpart source;
    private GlueSubpart target;
    private String guardCondition = "success";
    private EList<Bendpoint> bendpoints;
    private Point firstRelativePoint;
    private Point lastRelativePoint;

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getNewID() {
        return Integer.toString(count++);
    }

    @Override
    public void setNewID() {
        this.setID(this.getNewID());
    }

    @Override
    public GlueSubpart getSource() {
        return this.source;
    }

    @Override
    public void setSource(GlueSubpart glueSubpart) {
        GlueSubpart old = this.source;
        this.source = glueSubpart;
        super.firePropertyChange("source", old, this.source);
    }

    @Override
    public GlueSubpart getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(GlueSubpart glueSubpart) {
        GlueSubpart old = this.target;
        this.target = glueSubpart;
        super.firePropertyChange("target", old, this.target);
    }

    @Override
    public void attachSource() {
        if (this.getSource() == null || this.getSource().getSourceConnections().contains((Object)this)) {
            return;
        }
        this.getSource().connectOutput(this);
    }

    @Override
    public void detachSource() {
        if (this.getSource() == null) {
            return;
        }
        this.getSource().disconnectOutput(this);
    }

    @Override
    public void attachTarget() {
        if (this.getTarget() == null || this.getTarget().getTargetConnections().contains((Object)this)) {
            return;
        }
        this.getTarget().connectInput(this);
    }

    @Override
    public void detachTarget() {
        if (this.getTarget() == null) {
            return;
        }
        this.getTarget().disconnectInput(this);
    }

    @Override
    public GlueDiagram getGlueDiagram() {
        return (GlueDiagram)this.eContainer;
    }

    @Override
    public void setGlueDiagram(GlueDiagram root) {
        if (root != this.eContainer || this.eContainerFeatureID != 5 && root != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)root)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (root != null) {
                msgs = ((InternalEObject)root).eInverseAdd((InternalEObject)this, 8, GlueDiagram.class, msgs);
            }
            if ((msgs = super.eBasicSetContainer((InternalEObject)root, 5, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }

    @Override
    public void insertBendpoint(int index, Bendpoint point) {
        this.getBendpoints().add(index, point);
        super.firePropertyChange("bendpoint", null, null);
    }

    @Override
    public void removeBendpoint(int index) {
        this.getBendpoints().remove(index);
        super.firePropertyChange("bendpoint", null, null);
    }

    @Override
    public List<Bendpoint> getBendpoints() {
        if (this.bendpoints == null) {
            this.bendpoints = new EObjectResolvingEList(GlueWireBendpoint.class, (InternalEObject)this, 4);
        }
        return this.bendpoints;
    }

    @Override
    public void setBendpoint(int index, Bendpoint point) {
        this.getBendpoints().set(index, point);
        super.firePropertyChange("bendpoint", null, null);
    }

    @Override
    public void setBendpoints(List<Bendpoint> pointList) {
        this.getBendpoints().clear();
        this.getBendpoints().addAll(pointList);
        super.firePropertyChange("bendpoint", null, null);
    }

    @Override
    public String getWireGuardConditionContents() {
        return this.guardCondition;
    }

    @Override
    public void setWireGuardConditionContents(String newGuardCnodition) {
        String old = this.guardCondition;
        this.guardCondition = newGuardCnodition;
        super.firePropertyChange("wireGuardCondition", old, this.guardCondition);
    }

    @Override
    public Point getFirstRelativePoint() {
        return this.firstRelativePoint;
    }

    @Override
    public void setFirstRelativePoint(Point firstRelativePoint) {
        this.firstRelativePoint = firstRelativePoint;
    }

    @Override
    public Point getLastRelativePoint() {
        return this.lastRelativePoint;
    }

    @Override
    public void setLastRelativePoint(Point lastRelativePoint) {
        this.lastRelativePoint = lastRelativePoint;
    }

    @Override
    protected EClass eStaticClass() {
        return GluePackage.eINSTANCE.getWire();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (super.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 5: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return super.eBasicSetContainer(otherEnd, 5, msgs);
                }
            }
            return super.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return super.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (super.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 5: {
                    return super.eBasicSetContainer(null, 5, msgs);
                }
            }
            return super.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return super.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 5: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 8, GlueDiagram.class, msgs);
                }
            }
            return super.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (super.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getID();
            }
            case 1: {
                return this.getWireGuardConditionContents();
            }
            case 4: {
                return this.getBendpoints();
            }
            case 2: {
                return String.valueOf(this.getFirstRelativePoint().x) + "," + this.getFirstRelativePoint().y;
            }
            case 3: {
                return String.valueOf(this.getLastRelativePoint().x) + "," + this.getLastRelativePoint().y;
            }
            case 5: {
                return this.getGlueDiagram();
            }
        }
        return super.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (super.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                int newValueInt = Integer.parseInt((String)newValue);
                if (count <= newValueInt) {
                    count = newValueInt + 1;
                }
                this.setID((String)newValue);
                return;
            }
            case 1: {
                this.setWireGuardConditionContents((String)newValue);
                return;
            }
            case 4: {
                this.getBendpoints().clear();
                this.getBendpoints().addAll((Collection)newValue);
                return;
            }
            case 2: {
                String[] pointFirstArray = ((String)newValue).split(",");
                this.setFirstRelativePoint(new Point(Integer.parseInt(pointFirstArray[0]), Integer.parseInt(pointFirstArray[1])));
                return;
            }
            case 3: {
                String[] pointLastArray = ((String)newValue).split(",");
                this.setLastRelativePoint(new Point(Integer.parseInt(pointLastArray[0]), Integer.parseInt(pointLastArray[1])));
                return;
            }
            case 5: {
                this.setGlueDiagram((GlueDiagram)newValue);
                return;
            }
        }
        super.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (super.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setID(null);
                return;
            }
            case 1: {
                this.setWireGuardConditionContents(null);
                return;
            }
            case 4: {
                this.getBendpoints().clear();
                return;
            }
            case 2: {
                this.setFirstRelativePoint(null);
                return;
            }
            case 3: {
                this.setLastRelativePoint(null);
                return;
            }
            case 5: {
                this.setGlueDiagram(null);
                return;
            }
        }
        super.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (super.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.id != null;
            }
            case 1: {
                return this.guardCondition != null;
            }
            case 4: {
                return this.bendpoints != null && !this.bendpoints.isEmpty();
            }
            case 2: {
                return this.firstRelativePoint != null;
            }
            case 3: {
                return this.lastRelativePoint != null;
            }
            case 5: {
                return this.getGlueDiagram() != null;
            }
        }
        return super.eDynamicIsSet(eFeature);
    }

    public String toString() {
        return "Wire(" + this.getSource() + "->" + this.getTarget() + ")";
    }
}

