/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.model.impl;

import com.poscoict.glueframework.plugin.activity.model.GlueDiagram;
import com.poscoict.glueframework.plugin.activity.model.GluePackage;
import com.poscoict.glueframework.plugin.activity.model.GlueSubpart;
import com.poscoict.glueframework.plugin.activity.model.GlueWire;
import com.poscoict.glueframework.plugin.activity.model.impl.DimensionPropertySource;
import com.poscoict.glueframework.plugin.activity.model.impl.GlueObjectImpl;
import com.poscoict.glueframework.plugin.activity.model.impl.LocationPropertySource;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class GlueSubpartImpl
extends GlueObjectImpl
implements GlueSubpart {
    private static final long serialVersionUID = -1364273470550270805L;
    private String id;
    private EList<GlueWire> inputs;
    private EList<GlueWire> outputs;
    private Point location = new Point(0, 0);
    private Dimension size = new Dimension(-1, -1);
    protected static int count;
    private static IPropertyDescriptor[] descriptors;

    static {
        descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"size", "Size"), new PropertyDescriptor((Object)"location", "Location")};
    }

    public GlueSubpartImpl() {
        this.setID(this.getNewID());
    }

    protected abstract String getNewID();

    @Override
    public GlueDiagram getGlueDiagram() {
        return (GlueDiagram)this.eContainer;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Point point) {
        if (this.location.equals((Object)point)) {
            return;
        }
        this.location = point;
        super.firePropertyChange("location", null, point);
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void setSize(Dimension dimension) {
        if (this.size.equals((Object)dimension)) {
            return;
        }
        this.size = dimension;
        super.firePropertyChange("size", null, dimension);
    }

    @Override
    public void initWires() {
        this.initSourceOfWire();
        this.initTargetOfWire();
    }

    private void initSourceOfWire() {
        if (this.outputs == null || this.outputs.isEmpty()) {
            return;
        }
        for (GlueWire wire : this.outputs) {
            if (wire.getSource() != null) continue;
            wire.setSource(this);
        }
    }

    private void initTargetOfWire() {
        if (this.inputs == null || this.inputs.isEmpty()) {
            return;
        }
        for (GlueWire wire : this.inputs) {
            if (wire.getTarget() != null) continue;
            wire.setTarget(this);
        }
    }

    @Override
    public void connectInput(GlueWire wire) {
        this.getInputs().add((Object)wire);
        super.update();
        super.fireStructureChange("inputs", wire);
    }

    @Override
    public void connectOutput(GlueWire wire) {
        this.getOutputs().add((Object)wire);
        super.update();
        super.fireStructureChange("outputs", wire);
    }

    @Override
    public void disconnectInput(GlueWire wire) {
        this.getInputs().remove((Object)wire);
        super.update();
        super.fireStructureChange("inputs", wire);
    }

    @Override
    public void disconnectOutput(GlueWire wire) {
        this.getOutputs().remove((Object)wire);
        super.update();
        super.fireStructureChange("outputs", wire);
    }

    @Override
    public EList<GlueWire> getInputs() {
        if (this.inputs == null) {
            this.inputs = new EObjectResolvingEList(GlueWire.class, (InternalEObject)this, 3);
        }
        return this.inputs;
    }

    @Override
    public EList<GlueWire> getOutputs() {
        if (this.outputs == null) {
            this.outputs = new EObjectResolvingEList(GlueWire.class, (InternalEObject)this, 4);
        }
        return this.outputs;
    }

    @Override
    public EList<GlueWire> getConnections() {
        EList<GlueWire> connectionList = this.outputs;
        connectionList.addAll(this.inputs);
        return connectionList;
    }

    @Override
    public EList<GlueWire> getSourceConnections() {
        return this.getOutputs();
    }

    @Override
    public EList<GlueWire> getTargetConnections() {
        return this.getInputs();
    }

    @Override
    public boolean isPropertySet() {
        return true;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object propName) {
        if ("size".equals(propName)) {
            return new DimensionPropertySource(this.getSize());
        }
        if ("location".equals(propName)) {
            return new LocationPropertySource(this.getLocation());
        }
        return null;
    }

    @Override
    public void setPropertyValue(Object propName, Object value) {
        if ("size".equals(propName)) {
            this.setSize((Dimension)value);
        } else if ("location".equals(propName)) {
            this.setLocation((Point)value);
        }
    }

    @Override
    protected EClass eStaticClass() {
        return GluePackage.eINSTANCE.getGlueSubpart();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 5: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 5, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 5: {
                    return this.eBasicSetContainer(null, 5, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 5: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 5, GlueDiagram.class, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getID();
            }
            case 3: {
                return this.getInputs();
            }
            case 4: {
                return this.getOutputs();
            }
            case 1: {
                return String.valueOf(this.location.x) + "," + this.location.y;
            }
            case 2: {
                return String.valueOf(this.size.width) + "," + this.size.height;
            }
            case 5: {
                return this.getGlueDiagram();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                int newValueInt = Integer.parseInt((String)newValue);
                if (count <= newValueInt) {
                    count = newValueInt + 1;
                }
                this.setID((String)newValue);
                return;
            }
            case 3: {
                this.getInputs().clear();
                this.getInputs().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getOutputs().clear();
                this.getOutputs().addAll((Collection)newValue);
                return;
            }
            case 1: {
                String[] locationArray = ((String)newValue).split(",");
                this.setLocation(new Point(Integer.parseInt(locationArray[0]), Integer.parseInt(locationArray[1])));
                return;
            }
            case 2: {
                String[] sizeArray = ((String)newValue).split(",");
                this.setSize(new Dimension(Integer.parseInt(sizeArray[0]), Integer.parseInt(sizeArray[1])));
                return;
            }
            case 5: {
                this.setGlueDiagram((GlueDiagram)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setID(null);
                return;
            }
            case 3: {
                this.getInputs().clear();
                return;
            }
            case 4: {
                this.getOutputs().clear();
                return;
            }
            case 1: {
                this.setLocation(null);
                return;
            }
            case 2: {
                this.setSize(null);
                return;
            }
            case 5: {
                this.setGlueDiagram(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getID() != null;
            }
            case 3: {
                return this.inputs != null && !this.inputs.isEmpty();
            }
            case 4: {
                return this.outputs != null && !this.outputs.isEmpty();
            }
            case 1: {
                return this.location != null;
            }
            case 2: {
                return this.size != null;
            }
            case 5: {
                return this.getGlueDiagram() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    private void setGlueDiagram(GlueDiagram diagram) {
        if (diagram != this.eContainer || this.eContainerFeatureID != 5 && diagram != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)diagram)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (diagram != null) {
                msgs = ((InternalEObject)diagram).eInverseAdd((InternalEObject)this, 6, GlueDiagram.class, msgs);
            }
            if ((msgs = this.eBasicSetContainer((InternalEObject)diagram, 5, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }
}

