/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.model.impl;

import com.poscoict.glueframework.plugin.activity.model.impl.GlueGuide;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GlueRuler
implements Serializable {
    private static final long serialVersionUID = -6482025071072261907L;
    public static final String PROPERTY_CHILDREN = "children changed";
    public static final String PROPERTY_UNIT = "units changed";
    private final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private int unit;
    private final boolean isHorizontal;
    private final List<GlueGuide> guideList = new ArrayList<GlueGuide>();

    public GlueRuler(boolean isHorizontal) {
        this.isHorizontal = isHorizontal;
        this.setUnit(2);
    }

    public void addGuide(GlueGuide guide) {
        if (!this.guideList.contains(guide)) {
            guide.setHorizontal(!this.isHorizontal());
            this.guideList.add(guide);
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, guide);
        }
    }

    public void removeGuide(GlueGuide guide) {
        if (this.guideList.remove(guide)) {
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, guide);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public List<GlueGuide> getGuides() {
        return this.guideList;
    }

    public int getUnit() {
        return this.unit;
    }

    public void setUnit(int newUnit) {
        if (this.unit != newUnit) {
            int oldUnit = this.unit;
            this.unit = newUnit;
            this.listeners.firePropertyChange(PROPERTY_UNIT, oldUnit, newUnit);
        }
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }
}

