/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.activity.model.impl;

import com.poscoict.glueframework.plugin.activity.model.impl.NumberCellEditorValidator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class DimensionPropertySource
implements IPropertySource {
    public static String ID_WIDTH = "WIDTH";
    public static String ID_HEIGHT = "HEIGHT";
    private static IPropertyDescriptor[] descriptors;
    private Dimension dimension = null;

    static {
        TextPropertyDescriptor widthProp = new TextPropertyDescriptor((Object)ID_WIDTH, "Width");
        widthProp.setValidator((ICellEditorValidator)NumberCellEditorValidator.instance());
        TextPropertyDescriptor heightProp = new TextPropertyDescriptor((Object)ID_HEIGHT, "Height");
        heightProp.setValidator((ICellEditorValidator)NumberCellEditorValidator.instance());
        descriptors = new IPropertyDescriptor[]{widthProp, heightProp};
    }

    public DimensionPropertySource(Dimension dimension) {
        this.dimension = dimension.getCopy();
    }

    public Object getEditableValue() {
        return this.dimension.getCopy();
    }

    public Object getPropertyValue(Object propName) {
        if (ID_HEIGHT.equals(propName)) {
            return new String(new Integer(this.dimension.height).toString());
        }
        if (ID_WIDTH.equals(propName)) {
            return new String(new Integer(this.dimension.width).toString());
        }
        return null;
    }

    public void setPropertyValue(Object propName, Object value) {
        Integer newInt;
        if (ID_HEIGHT.equals(propName)) {
            newInt = new Integer((String)value);
            this.dimension.height = newInt;
        }
        if (ID_WIDTH.equals(propName)) {
            newInt = new Integer((String)value);
            this.dimension.width = newInt;
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public void resetPropertyValue(Object propName) {
    }

    public boolean isPropertySet(Object propName) {
        return ID_HEIGHT.equals(propName) || ID_WIDTH.equals(propName);
    }

    public String toString() {
        return new String("(" + this.dimension.width + "," + this.dimension.height + ")");
    }
}

