/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.sdk.wizards;

import com.poscoict.mobileframework.sdk.GlueMobilePluginActivator;
import com.poscoict.mobileframework.sdk.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.osgi.service.prefs.BackingStoreException;

public class NewMobileProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String PLUGIN_ID = "com.poscoict.mobileframework.sdk";
    private static final String TEMPLATE_BASIC = "templates/basic";
    private IConfigurationElement config;
    private IWorkbench workbench;
    private WizardNewProjectCreationPage wizardPage;
    private String projectType;
    private String templateLocation = null;
    private String refLocation = null;
    private boolean islogEnable = false;

    public NewMobileProjectWizard() {
        super.setWindowTitle("New Glue Mobile Project");
        super.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"/icons/mobileframework_wizard_banner.jpg"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void addPages() {
        super.addPages();
        this.wizardPage = new WizardNewProjectCreationPage("Mobile Project Details");
        this.wizardPage.setTitle("Mobile Project Details");
        this.wizardPage.setDescription("Define the properties of your Mobile project here.");
        super.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        this.refLocation = this.getGlueSDKLocation();
        IPreferenceStore store = GlueMobilePluginActivator.getInstance().getPreferenceStore();
        this.templateLocation = store.getString("template.location");
        this.islogEnable = store.getBoolean("log.enabled");
        String projectName = this.wizardPage.getProjectName();
        Assert.isNotNull((Object)projectName);
        Assert.isTrue((projectName.trim().length() > 0 ? 1 : 0) != 0);
        if (this.islogEnable) {
            Util.log(this.islogEnable, (IStatus)new Status(1, PLUGIN_ID, "project name:[" + projectName + "] useDefault:[" + this.wizardPage.useDefaults() + "] locationURI:[" + this.wizardPage.getLocationURI() + "] locationPath:[" + this.wizardPage.getLocationPath() + "] workspace:[" + Platform.getLocation() + "]"));
        }
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        final IProjectDescription description = project.getWorkspace().newProjectDescription(projectName);
        if (Platform.getLocation().equals((Object)this.wizardPage.getLocationPath())) {
            description.setLocation(null);
        } else {
            description.setLocation(this.wizardPage.getLocationPath());
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    NewMobileProjectWizard.this.createProject(project, description, monitor);
                }
                catch (OperationCanceledException e) {
                    Util.log(e);
                }
                catch (IOException e) {
                    Util.log(e);
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            super.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Util.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getTargetException().getMessage());
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        BasicNewResourceWizard.selectAndReveal((IResource)project, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
        this.projectType = (String)data;
    }

    private void createProject(IProject project, IProjectDescription description, IProgressMonitor monitor) throws CoreException, OperationCanceledException, IOException, BackingStoreException {
        IFolder srcFolder;
        if (this.islogEnable) {
            this.createProject_Log1();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        project.create(description, (IProgressMonitor)progress);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        project.open(monitor);
        progress.worked(1000);
        File gluemobileTemplate = new File(this.templateLocation);
        File glueframeworkTemplate = null;
        boolean isInternal = this.templateLocation == null || "".equals(this.templateLocation.trim());
        boolean isRefNone = this.refLocation == null || "".equals(this.refLocation.trim());
        File projDir = new File(project.getLocationURI().getPath());
        StringBuilder sb = new StringBuilder();
        sb.append("projectType:[").append(this.projectType).append("]\n");
        sb.append("isInternal:[").append(isInternal).append("] templateLocation:[").append(this.templateLocation).append("]\n");
        sb.append("isRefNone:[").append(isRefNone).append("] GlueSDK Location:[").append(this.refLocation).append("]\n");
        sb.append("projDir:[").append(projDir).append("]\n");
        Util.log(true, (IStatus)new Status(1, PLUGIN_ID, sb.toString()));
        this.addProjectNature(project, description, (IProgressMonitor)progress);
        if ("glue_java".equals(this.projectType) || "glue_maven".equals(this.projectType)) {
            glueframeworkTemplate = new File(String.valueOf(this.refLocation) + File.separator + "templateFolder" + File.separator + this.projectType.substring(5));
            Util.log(true, (IStatus)new Status(1, PLUGIN_ID, "[" + glueframeworkTemplate + "][" + glueframeworkTemplate.exists() + "]"));
            if (!glueframeworkTemplate.exists()) {
                throw new CoreException((IStatus)new Status(4, "The Template Folder dose not exist!", 0, "GlueSDK Location is required : please set Glue Framework preference", null));
            }
            gluemobileTemplate = new File(FileLocator.toFileURL((URL)Platform.getBundle((String)PLUGIN_ID).getEntry("templates/" + this.projectType)).getFile());
        }
        if (!gluemobileTemplate.exists()) {
            gluemobileTemplate = new File(FileLocator.toFileURL((URL)Platform.getBundle((String)PLUGIN_ID).getEntry(TEMPLATE_BASIC)).getFile());
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (!"glue_maven".equals(this.projectType)) {
            List<String> userLibList;
            IClasspathEntry[] defaultJRELibentries;
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> entryList = new ArrayList<IClasspathEntry>();
            sb = new StringBuilder();
            int idx = 1;
            IClasspathEntry[] iClasspathEntryArray = defaultJRELibentries = PreferenceConstants.getDefaultJRELibrary();
            int n = defaultJRELibentries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                entryList.add(iClasspathEntry);
                sb.append("\tJreLibrary[").append(idx++).append("][").append(iClasspathEntry).append("]\n");
                ++n2;
            }
            if ("glue_java".equals(this.projectType) && JavaCore.getUserLibraryNames() != null && (userLibList = Arrays.asList(JavaCore.getUserLibraryNames())) != null && userLibList.size() > 0) {
                if (userLibList.contains("GLUE_STD")) {
                    entryList.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.USER_LIBRARY").append("GLUE_CORE"), (boolean)true));
                    sb.append("\tUserLibrary[").append(idx++).append("][").append("GLUE_CORE").append("]\n");
                }
                if (userLibList.contains("GLUE_STD")) {
                    entryList.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.USER_LIBRARY").append("GLUE_STD"), (boolean)true));
                    sb.append("\tUserLibrary[").append(idx++).append("][").append("GLUE_STD").append("]\n");
                }
            }
            idx = 1;
            IFolder srcFolder2 = javaProject.getProject().getFolder("src/");
            if (!srcFolder2.exists()) {
                srcFolder2.create(true, true, monitor);
            }
            if (srcFolder2.getParent() != null) {
                IClasspathEntry source = JavaCore.newSourceEntry((IPath)srcFolder2.getParent().getFullPath());
                IClasspathEntry[] iClasspathEntryArray2 = entries;
                int n3 = entries.length;
                int n4 = 0;
                while (n4 < n3) {
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n4];
                    if (!source.equals(iClasspathEntry)) {
                        entryList.add(iClasspathEntry);
                    }
                    sb.append("\tSourceEntry[").append(entryList.size()).append("][").append(idx++).append("][").append(source).append("][").append(iClasspathEntry).append("]\n");
                    ++n4;
                }
            }
            entryList.add(JavaCore.newSourceEntry((IPath)srcFolder2.getFullPath()));
            sb.append("\tSourceEntry[").append(entryList.size()).append("][").append(srcFolder2.getFullPath()).append("]\n");
            entries = entryList.toArray(new IClasspathEntry[entryList.size()]);
            Util.log(true, (IStatus)new Status(1, PLUGIN_ID, sb.toString()));
            javaProject.setRawClasspath(entries, monitor);
            javaProject.setOutputLocation(project.getFolder("classes/").getFullPath(), monitor);
        }
        IProject container = project;
        File[] fileList = gluemobileTemplate.listFiles();
        Util.log(true, (IStatus)new Status(1, PLUGIN_ID, "template:[" + gluemobileTemplate + "] fileList:[" + fileList.length + "]"));
        this.copyFiles(fileList, (IContainer)container, monitor, null);
        if ("glue_java".equals(this.projectType) || "glue_maven".equals(this.projectType)) {
            fileList = glueframeworkTemplate.listFiles();
            this.copyFiles(fileList, (IContainer)container, monitor, null);
        }
        if (!(srcFolder = container.getFolder((IPath)new Path("src"))).exists()) {
            srcFolder.create(true, true, monitor);
        }
    }

    private void addProjectNature(IProject project, IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        HashSet<String> natureIds = new HashSet<String>();
        String[] stringArray = description.getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String natureId = stringArray[n2];
            natureIds.add(natureId);
            ++n2;
        }
        natureIds.add("org.eclipse.jdt.core.javanature");
        natureIds.add("org.eclipse.jem.workbench.JavaEMFNature");
        natureIds.add("org.eclipse.wst.common.modulecore.ModuleCoreNature");
        natureIds.add("org.eclipse.wst.common.project.facet.core.nature");
        natureIds.add("org.eclipse.wst.jsdt.core.jsNature");
        natureIds.add("org.eclipse.jem.workbench.JavaEMFNature");
        if ("glue_maven".equals(this.projectType)) {
            natureIds.add("org.eclipse.m2e.core.maven2Nature");
        }
        description.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
        project.setDescription(description, monitor);
        "glue_maven".equals(this.projectType);
    }

    private void copyFiles(File[] dirs, IContainer container, IProgressMonitor monitor, IFolder parent) throws CoreException, IOException {
        if (dirs != null) {
            File[] fileArray = dirs;
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                if (dir.isDirectory()) {
                    IFolder folder = null;
                    if (parent == null) {
                        folder = container.getFolder((IPath)new Path(dir.getName()));
                        if (!folder.exists()) {
                            folder.create(true, true, monitor);
                        }
                    } else {
                        folder = parent.getFolder((IPath)new Path(dir.getName()));
                        if (!folder.exists()) {
                            folder.create(true, true, monitor);
                        }
                    }
                    File[] files = dir.listFiles();
                    this.copyFiles(files, container, monitor, folder);
                } else {
                    FileInputStream resourceStream = new FileInputStream(dir);
                    if (parent != null) {
                        IPath path = parent.getProjectRelativePath();
                        this.addFileToProject(container, new Path(path + "/" + dir.getName()), resourceStream, monitor);
                    } else {
                        this.addFileToProject(container, new Path(dir.getName()), resourceStream, monitor);
                    }
                    ((InputStream)resourceStream).close();
                }
                ++n2;
            }
        }
    }

    private void addFileToProject(IContainer container, Path path, InputStream contentStream, IProgressMonitor monitor) throws CoreException {
        IFile file = container.getFile((IPath)path);
        if (file.exists()) {
            file.setContents(contentStream, true, true, monitor);
        } else {
            file.create(contentStream, true, monitor);
        }
    }

    private String getGlueSDKLocation() {
        FileInputStream in = null;
        IPath path = Platform.getLocation().append(".metadata").append(".plugins").append("org.eclipse.core.runtime").append(".settings").append("com.poscoict.glueframework.project.startup.prefs");
        Util.log(this.islogEnable, (IStatus)new Status(1, PLUGIN_ID, "path [" + path + "][" + path.toFile() + "]"));
        Properties properties = new Properties();
        try {
            in = new FileInputStream(path.toString());
            properties.load(in);
            String string = properties.getProperty("GLUE_SDK_LOCATION");
            return string;
        }
        catch (FileNotFoundException e) {
            Util.log(e);
        }
        catch (IOException e) {
            Util.log(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Util.log(e);
                }
            }
        }
        return null;
    }

    private void createProject_Log1() throws BackingStoreException {
        StringBuilder sb = new StringBuilder();
        IPreferencesService ps = Platform.getPreferencesService();
        IEclipsePreferences prefs = ps.getRootNode();
        Util.log(this.islogEnable, (IStatus)new Status(1, PLUGIN_ID, "Platform [" + Platform.getConfigurationLocation() + "][" + Platform.getOS() + "][" + Platform.getOSArch() + "][" + Platform.getProduct().getId() + "][" + Platform.getProduct().getName() + "][" + Platform.getProduct().getApplication() + "][" + Platform.getProduct().getDescription() + "][" + Platform.getProduct().getDefiningBundle() + "]"));
        Util.log(this.islogEnable, (IStatus)new Status(1, PLUGIN_ID, "prefs [" + prefs + "][" + prefs.absolutePath() + "][" + prefs.name() + "]"));
        String[] names = prefs.childrenNames();
        String[] keys = prefs.keys();
        sb = new StringBuilder();
        int idx = 1;
        sb.append("prefs length [").append(names.length).append("][").append(keys.length).append("]\n");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            sb.append("\t").append("prefs.childrenNames() [").append(idx++).append("][").append(name).append("][").append(prefs.node(name)).append("]\n");
            ++n2;
        }
        idx = 1;
        stringArray = keys;
        n = keys.length;
        n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            sb.append("\t").append("prefs.keys() [").append(idx++).append("][").append(key).append("][").append(prefs.node(key)).append("]\n");
            ++n2;
        }
        Util.log(this.islogEnable, (IStatus)new Status(1, PLUGIN_ID, sb.toString()));
        IPreferenceNode[] nodes = PlatformUI.getWorkbench().getPreferenceManager().getRootSubNodes();
        sb = new StringBuilder();
        idx = 1;
        sb.append("nodes [").append(nodes.length).append("]\n");
        IPreferenceNode[] iPreferenceNodeArray = nodes;
        int n3 = nodes.length;
        n = 0;
        while (n < n3) {
            IPreferenceNode node = iPreferenceNodeArray[n];
            sb.append("\t").append("nodes [").append(idx++).append("][").append(node).append("][").append(node.getId()).append("][").append(node.getLabelText()).append("]\n");
            ++n;
        }
        Util.log(this.islogEnable, (IStatus)new Status(1, PLUGIN_ID, sb.toString()));
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint[] points = registry.getExtensionPoints();
        sb = new StringBuilder();
        idx = 1;
        sb.append("points [").append(points.length).append("]\n");
        IExtensionPoint[] iExtensionPointArray = points;
        int n4 = points.length;
        int n5 = 0;
        while (n5 < n4) {
            IExtensionPoint point = iExtensionPointArray[n5];
            IContributor contributor = point.getContributor();
            IExtension[] extensions = point.getExtensions();
            sb.append("point [").append(idx++).append("][").append(point.getNamespaceIdentifier()).append("][").append(point.getSchemaReference()).append("][").append(point.getSimpleIdentifier()).append("][").append(point.getUniqueIdentifier()).append("][").append(point.getLabel()).append("]\n");
            sb.append("contributor [").append(contributor.getName()).append("][").append(contributor).append("][").append(extensions.length).append("]\n");
            IExtension[] iExtensionArray = extensions;
            int n6 = extensions.length;
            int n7 = 0;
            while (n7 < n6) {
                IExtension iExtension = iExtensionArray[n7];
                sb.append("\t[").append(iExtension.getExtensionPointUniqueIdentifier()).append("][").append(iExtension.getNamespaceIdentifier()).append("][").append(iExtension.getSimpleIdentifier()).append("][").append(iExtension.getUniqueIdentifier()).append("][").append(iExtension.getLabel()).append("]\n");
                ++n7;
            }
            ++n5;
        }
        Util.log(this.islogEnable, (IStatus)new Status(1, PLUGIN_ID, sb.toString()));
    }
}

