/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.sdk.wizards;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class GlueMobileModelCreationPage
extends WizardNewFileCreationPage {
    private final IWorkbench workbench;
    private static int count = 1;

    public GlueMobileModelCreationPage(IWorkbench workbench, IStructuredSelection selection) {
        super("Glue Mobile Model Wizard", selection);
        this.setTitle("Mobile Model");
        this.setDescription("Mobile Model File");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        Composite topLevel = this.createTopLevelComposite(parent, 1);
        Composite myLevel = this.createComposite(topLevel);
        this.addLabelCheckButton(myLevel, "test", true, 1);
        this.addCheckButtonText(myLevel, "idAttributes", "id", true, 1);
        this.addCheckButtonText(myLevel, "url", "http://www.google.co.kr/", true, 1);
        this.addCheckButtonText(myLevel, "urlRoot", "http://www.google.co.kr/", true, 1);
        super.createControl(topLevel);
        this.setFileName("GlueModel" + count + ".js");
        super.setPageComplete(super.validatePage());
    }

    protected void addCheckButtonText(Composite container, String headerText, String textvalue, boolean checked, int eleId) {
        final Button checkButton = new Button(container, 32);
        final Text headLabel = new Text(container, 2048);
        checkButton.setText(headerText);
        checkButton.setSelection(checked);
        headLabel.setText(textvalue);
        headLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkButton.getSelection()) {
                    headLabel.setEditable(true);
                } else {
                    headLabel.setEditable(false);
                }
            }
        });
        headLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
            }
        });
    }

    protected void addLabelCheckButton(Composite container, String labelText, boolean checked, int eleId) {
        Label label = new Label(container, 0);
        label.setText(labelText);
        final Button checkButton = new Button(container, 32);
        checkButton.setSelection(checked);
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                checkButton.getSelection();
            }
        });
        checkButton.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected Composite createComposite(Composite container) {
        return this.createComposite(container, 2);
    }

    protected Composite createTopLevelComposite(Composite container, int layout) {
        Composite composite = new Composite(container, 0);
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(layout, false));
        return composite;
    }

    protected Composite createComposite(Composite container, int layout) {
        Composite composite = new Composite(container, 2048);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(layout, false));
        return composite;
    }

    protected void addLabelText(Composite container, String titleText, String textValue, int eleId) {
        Label labelCom = new Label(container, 0);
        labelCom.setText(titleText);
        Text textCom = new Text(container, 2048);
        textCom.setText(textValue);
        textCom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
            }
        });
        textCom.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public boolean finish() {
        IFile newFile = super.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream("D:/eclipse-jee-kepler-glue/eclipse/Web_SRC/com.poscoict.mobileframework.sdk/templates/model.js");
            FileOutputStream out = new FileOutputStream(newFile.getLocation().toOSString());
            byte[] buf = new byte[1024];
            int count = 0;
            while ((count = fis.read(buf)) != -1) {
                out.write(buf, 0, count);
            }
            out.close();
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ++count;
        return true;
    }
}

