/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.sdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Util {
    public static void log(Boolean isEnabled, IStatus status) {
        if (isEnabled.booleanValue()) {
            JavaPlugin.log((IStatus)status);
        }
    }

    public static void log(Throwable t) {
        JavaPlugin.log((Throwable)t);
    }

    public static void copyDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            int i = 0;
            while (i < files.length) {
                Util.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                ++i;
            }
        } else if (srcPath.exists()) {
            int len;
            FileInputStream in = new FileInputStream(srcPath);
            FileOutputStream out = new FileOutputStream(dstPath);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static Image getImage(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.poscoict.mobileframework.sdk", (String)path).createImage();
    }

    public static boolean zipDirectory(File srcDir, File destFile, String[] ignoreList) {
        ArrayList<File> fileList = new ArrayList<File>();
        Util.addFiles(srcDir, fileList, ignoreList);
        try {
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(destFile));
            for (File file : fileList) {
                if (file.isDirectory()) continue;
                Util.addFileToZip(file, zip, srcDir);
            }
            zip.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void addFiles(File srcDir, List<File> fileList, String[] ignoreList) {
        File[] files;
        File[] fileArray = files = srcDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            boolean skip = false;
            String[] stringArray = ignoreList;
            int n3 = ignoreList.length;
            int n4 = 0;
            while (n4 < n3) {
                String ignore = stringArray[n4];
                if (file.getName().equals(ignore)) {
                    skip = true;
                    break;
                }
                ++n4;
            }
            if (!skip && !file.getName().startsWith(".")) {
                fileList.add(file);
                if (file.isDirectory()) {
                    Util.addFiles(file, fileList, ignoreList);
                }
            }
            ++n2;
        }
    }

    public static void addFileToZip(File file, ZipOutputStream zip, File baseDir) {
        try {
            int length;
            String filePath = file.getCanonicalPath().substring(baseDir.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
            zip.putNextEntry(new ZipEntry(filePath));
            FileInputStream inStream = new FileInputStream(file);
            byte[] bytes = new byte[1024];
            while ((length = inStream.read(bytes)) >= 0) {
                zip.write(bytes, 0, length);
            }
            inStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

