/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.query.editor.wizards;

import com.poscoict.glueframework.schema.query.parser.GlueQueryMapInfo;
import com.poscoict.glueframework.schema.query.parser.GlueQueryParser;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class GlueQueryEditorWizardPage
extends WizardNewFileCreationPage {
    private final IWorkbench workbench;
    private static int count = 1;

    public GlueQueryEditorWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        super("Glue Query Editor Wizard", selection);
        this.setTitle("Glue Query Editor");
        this.setDescription("Glue Query Editor File");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName("newQuery" + count + "-query.glue_sql");
        super.setPageComplete(super.validatePage());
    }

    public boolean finish() {
        IFile newFile = super.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            GlueQueryParser.getInstance().makeXml(new File(newFile.getLocation().toOSString()), new GlueQueryMapInfo(""));
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ++count;
        return true;
    }
}

