/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.query.editor.preferences;

import com.poscoict.glueframework.plugin.project.startup.GlueProjectPlugin;
import com.poscoict.glueframework.plugin.query.editor.designer.GlueQueryEditorPlugin;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GlueQueyrPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static Driver driver = null;
    private GlueJDBCDriverFileFieldEditor jdbcFileField;
    private StringFieldEditor classNameField;
    private StringFieldEditor connUrlField;
    private StringFieldEditor userNameField;
    private GlueJDBCPasswordFieldEditor passwordField;

    public GlueQueyrPreferencePage() {
        super(1);
        super.setPreferenceStore(GlueQueryEditorPlugin.getDefault().getPreferenceStore());
        super.setDescription("JDBC Connection Setting for Test");
    }

    public void createFieldEditors() {
        this.jdbcFileField = new GlueJDBCDriverFileFieldEditor("GLUE_DRIVER_PATH", "Driver Library :", super.getFieldEditorParent());
        this.classNameField = new StringFieldEditor("GLUE_CLASS_NAME", "Driver Class Name :", super.getFieldEditorParent());
        this.connUrlField = new StringFieldEditor("GLUE_CONNECTION_URL", "Url :", super.getFieldEditorParent());
        this.userNameField = new StringFieldEditor("GLUE_USER_NAME", "User Name :", super.getFieldEditorParent());
        this.passwordField = new GlueJDBCPasswordFieldEditor("GLUE_PASSWORD", "Password :", super.getFieldEditorParent());
        super.addField((FieldEditor)this.jdbcFileField);
        super.addField((FieldEditor)this.classNameField);
        super.addField((FieldEditor)this.connUrlField);
        super.addField((FieldEditor)this.userNameField);
        super.addField((FieldEditor)this.passwordField);
        Button testButton = new Button(super.getFieldEditorParent(), 8);
        testButton.setText("Test Connection");
        testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MessageBox dialog = new MessageBox(Display.getCurrent().getActiveShell());
                dialog.setMessage(GlueQueyrPreferencePage.this.testDBConnection());
                dialog.open();
            }
        });
    }

    private String testDBConnection() {
        String result;
        block15: {
            result = "Connection Success!";
            String driverFilePath = this.jdbcFileField.getJDBCDriverPath();
            String driverClassName = this.classNameField.getStringValue();
            String connectionUrl = this.connUrlField.getStringValue();
            String username = this.userNameField.getStringValue();
            String password = this.passwordField.getStringValue();
            Connection connection = null;
            try {
                try {
                    if (driver == null) {
                        URL[] classes = new URL[]{new File(driverFilePath).toURI().toURL()};
                        URLClassLoader loader = new URLClassLoader(classes, ((Object)((Object)this)).getClass().getClassLoader());
                        Class<?> clazz = Class.forName(driverClassName, true, loader);
                        driver = (Driver)clazz.newInstance();
                    }
                    Properties props = new Properties();
                    props.put("user", username);
                    props.put("password", password);
                    connection = driver.connect(connectionUrl, props);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    result = ex.getMessage();
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    private class GlueJDBCDriverFileFieldEditor
    extends FileFieldEditor {
        private String sdkDirectoryPath;

        public GlueJDBCDriverFileFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, false, 0, parent);
            super.setFileExtensions(new String[]{"*.jar"});
            super.setFilterPath(new File(this.getOldSDKDirectoryPath()));
        }

        public String getJDBCDriverPath() {
            return super.getTextControl().getText();
        }

        private String getOldSDKDirectoryPath() {
            if (this.sdkDirectoryPath == null || "".equals(this.sdkDirectoryPath)) {
                this.sdkDirectoryPath = GlueProjectPlugin.getDefault().getPreferenceStore().getString("GLUE_SDK_LOCATION");
            }
            return this.sdkDirectoryPath;
        }
    }

    private class GlueJDBCPasswordFieldEditor
    extends StringFieldEditor {
        private Text textField;

        public GlueJDBCPasswordFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, UNLIMITED, 0, parent);
        }

        public Text getTextControl(Composite parent) {
            if (this.textField == null) {
                this.textField = new Text(parent, 0x400804);
                this.textField.setFont(parent.getFont());
                this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        GlueJDBCPasswordFieldEditor.this.valueChanged();
                    }
                });
                this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        GlueJDBCPasswordFieldEditor.this.valueChanged();
                    }
                });
                this.textField.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        GlueJDBCPasswordFieldEditor.this.textField = null;
                    }
                });
            } else {
                super.checkParent((Control)this.textField, parent);
            }
            return this.textField;
        }
    }
}

