/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.query.editor.dialog;

import com.poscoict.glueframework.plugin.query.editor.dialog.GlueBindCellModifier;
import com.poscoict.glueframework.plugin.query.editor.dialog.GluePropertyTask;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class GlueBindingDialog
extends Dialog {
    private int bindCount = 0;
    private List<String> bindValueList = new ArrayList<String>();
    private TableViewer tableViewer;

    public GlueBindingDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setBindCount(int count) {
        this.bindCount = count;
    }

    public List<String> getBindValueList() {
        return this.bindValueList;
    }

    public void setBindValueList(List<String> newBindValueList) {
        if (newBindValueList != null) {
            this.bindValueList = newBindValueList;
        }
    }

    protected Control createDialogArea(Composite parent) {
        super.getShell().setText("Bind Variable List");
        Composite composite = (Composite)super.createDialogArea(parent);
        this.tableViewer = new TableViewer(composite, 68352);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        String[] columnNames = new String[]{"Variable", "Value"};
        this.tableViewer.setColumnProperties(columnNames);
        int[] columnWidths = new int[]{100, 100};
        int[] columnAignments = new int[]{0x1000000, 16384};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, columnAignments[i]);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(columnWidths[i]);
            ++i;
        }
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.tableViewer.setCellModifier((ICellModifier)new GlueBindCellModifier());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new GlueBindLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        i = 0;
        while (i < this.bindCount) {
            if (this.bindValueList != null && !this.bindValueList.isEmpty() && i < this.bindValueList.size()) {
                this.tableViewer.add((Object)new GluePropertyTask(":" + i, this.bindValueList.get(i)));
            } else {
                this.tableViewer.add((Object)new GluePropertyTask(":" + i, ""));
            }
            ++i;
        }
        return composite;
    }

    protected void okPressed() {
        this.bindValueList.clear();
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            GluePropertyTask propertyTask = (GluePropertyTask)this.tableViewer.getElementAt(i);
            this.bindValueList.add(propertyTask.getValue());
            ++i;
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(250, 250);
    }

    class GlueBindLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        GlueBindLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            GluePropertyTask task = (GluePropertyTask)element;
            switch (columnIndex) {
                case 0: {
                    return task.getName();
                }
                case 1: {
                    return task.getValue();
                }
            }
            return "";
        }
    }
}

