/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.plugin.query.editor.designer;

import com.poscoict.glueframework.plugin.project.startup.util.GlueEclipseProjectUtil;
import com.poscoict.glueframework.plugin.query.editor.designer.GlueQueryEditor;
import com.poscoict.glueframework.plugin.query.editor.designer.GlueQueryEditorPlugin;
import com.poscoict.glueframework.plugin.query.editor.dialog.GlueBindingDialog;
import com.poscoict.glueframework.plugin.query.editor.dialog.GlueQueryDialog;
import com.poscoict.glueframework.plugin.query.editor.model.GlueQuery;
import com.poscoict.glueframework.plugin.query.editor.model.GlueQueryMap;
import com.poscoict.glueframework.plugin.query.editor.model.GlueQueryRoot;
import com.poscoict.glueframework.plugin.query.editor.view.GlueQueryContentProvider;
import com.poscoict.glueframework.plugin.query.editor.view.GlueQueryLabelProvider;
import com.poscoict.glueframework.plugin.query.editor.view.GlueQueryView;
import com.poscoict.glueframework.schema.query.parser.GlueQueryMapInfo;
import com.poscoict.glueframework.schema.query.parser.GlueQueryParser;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class GlueQueryMultiPageEditor
extends MultiPageEditorPart {
    private static final int DESIGN_PAGE = 0;
    private static final int SOURCE_PAGE = 1;
    private static Driver driver = null;
    private final IResourceChangeListener resourceListener = new GlueQueryResourceTracker();
    private final GlueQueryParser parser = GlueQueryParser.getInstance();
    private GlueQueryEditor editor;
    private TreeViewer treeViewer;
    private Text idText;
    private Text descText;
    private Text resultTypeText;
    private Button namedChk;
    private Text queryText;
    private final Map<String, Button> buttonMap = new HashMap<String, Button>(4);
    private final Map<String, List<String>> bindListMap = new HashMap<String, List<String>>();

    public GlueQueryMultiPageEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
    }

    protected void createPages() {
        this.addQueryDesignPage();
        this.addQueryXmlPage();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        super.getEditor(1).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = super.getEditor(1);
        editor.doSaveAs();
        super.setInput(editor.getEditorInput());
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        IFileEditorInput input = (IFileEditorInput)editorInput;
        super.setPartName(input.getName());
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        switch (newPageIndex) {
            case 0: {
                this.loadQueryTree();
            }
        }
    }

    private void addQueryXmlPage() {
        try {
            this.editor = new GlueQueryEditor();
            super.addPage(1, (IEditorPart)this.editor, super.getEditorInput());
            super.setPageText(1, "Source");
        }
        catch (PartInitException e) {
            this.showErrorDialogNLogView("Error creating nested text editor", "Error creating text editor ", (CoreException)((Object)e));
        }
    }

    private void addQueryDesignPage() {
        Composite composite = new Composite(super.getContainer(), 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.makeQueryList(composite);
        this.makeQueryDetail(composite);
        this.makeQuerySql(composite);
        super.addPage(0, (Control)composite);
        super.setPageText(0, "Design");
        this.controlButton(false, "");
    }

    private void makeQueryList(Composite composite) {
        Group listGroup = new Group(composite, 4);
        listGroup.setText("Query List");
        listGroup.setLayout((Layout)new GridLayout());
        listGroup.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer((Composite)listGroup, 2048);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new GlueQueryLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new GlueQueryContentProvider());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof GlueQueryMap) {
                    GlueQueryMap queryMap = (GlueQueryMap)selection;
                    GlueQueryMultiPageEditor.this.idText.setText(queryMap.getName());
                    GlueQueryMultiPageEditor.this.descText.setText(queryMap.getDesc());
                    GlueQueryMultiPageEditor.this.resultTypeText.setText("");
                    GlueQueryMultiPageEditor.this.namedChk.setSelection(false);
                    GlueQueryMultiPageEditor.this.queryText.setText("");
                    GlueQueryMultiPageEditor.this.idText.setEnabled(false);
                    GlueQueryMultiPageEditor.this.resultTypeText.setEnabled(false);
                    GlueQueryMultiPageEditor.this.namedChk.setEnabled(false);
                    GlueQueryMultiPageEditor.this.queryText.setEnabled(false);
                    GlueQueryMultiPageEditor.this.controlButton(true, new String[]{"add"});
                    GlueQueryMultiPageEditor.this.controlButton(false, new String[]{"delete", "test", "bind"});
                } else if (selection instanceof GlueQuery) {
                    GlueQuery query = (GlueQuery)selection;
                    GlueQueryMultiPageEditor.this.idText.setText(query.getId());
                    GlueQueryMultiPageEditor.this.descText.setText(query.getDesc());
                    GlueQueryMultiPageEditor.this.resultTypeText.setText(query.getResultType());
                    GlueQueryMultiPageEditor.this.namedChk.setSelection(query.isNamed());
                    GlueQueryMultiPageEditor.this.queryText.setText(query.getSql());
                    GlueQueryMultiPageEditor.this.idText.setEnabled(true);
                    GlueQueryMultiPageEditor.this.resultTypeText.setEnabled(true);
                    GlueQueryMultiPageEditor.this.namedChk.setEnabled(true);
                    GlueQueryMultiPageEditor.this.queryText.setEnabled(true);
                    GlueQueryMultiPageEditor.this.controlButton(true, new String[]{"add", "delete"});
                }
            }
        });
    }

    private void makeQueryDetail(Composite composite) {
        Group detailGroup = new Group(composite, 4);
        detailGroup.setText("Details");
        detailGroup.setLayout((Layout)new GridLayout(2, false));
        GridData detailGridData = new GridData(1808);
        detailGridData.minimumHeight = 155;
        detailGroup.setLayoutData((Object)detailGridData);
        Label idLabel = new Label((Composite)detailGroup, 131072);
        idLabel.setText("ID");
        idLabel.setFont(composite.getFont());
        this.idText = new Text((Composite)detailGroup, 2052);
        this.idText.setLayoutData((Object)new GridData(768));
        Label descLabel = new Label((Composite)detailGroup, 131072);
        descLabel.setText("Description");
        descLabel.setFont(composite.getFont());
        this.descText = new Text((Composite)detailGroup, 2052);
        this.descText.setLayoutData((Object)new GridData(768));
        Label typeLabel = new Label((Composite)detailGroup, 131072);
        typeLabel.setText("Result Type");
        typeLabel.setFont(composite.getFont());
        this.resultTypeText = new Text((Composite)detailGroup, 2052);
        this.resultTypeText.setLayoutData((Object)new GridData(768));
        Label queryLabel = new Label((Composite)detailGroup, 131072);
        queryLabel.setText("Named Query");
        queryLabel.setFont(composite.getFont());
        this.namedChk = new Button((Composite)detailGroup, 16416);
        this.namedChk.setLayoutData((Object)new GridData(768));
        this.makeButton((Composite)detailGroup);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (GlueQueryMultiPageEditor.this.idText.getText() == null || "".equals(GlueQueryMultiPageEditor.this.idText.getText().trim())) {
                    return;
                }
                Object selection = ((IStructuredSelection)GlueQueryMultiPageEditor.this.treeViewer.getSelection()).getFirstElement();
                if (selection instanceof GlueQueryMap) {
                    ((GlueQueryMap)selection).setName(GlueQueryMultiPageEditor.this.idText.getText());
                } else if (selection instanceof GlueQuery) {
                    ((GlueQuery)selection).setId(GlueQueryMultiPageEditor.this.idText.getText());
                }
                GlueQueryMultiPageEditor.this.loadQueryEditor();
            }
        });
        this.descText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Object selection = ((IStructuredSelection)GlueQueryMultiPageEditor.this.treeViewer.getSelection()).getFirstElement();
                if (selection instanceof GlueQueryMap) {
                    ((GlueQueryMap)selection).setDesc(GlueQueryMultiPageEditor.this.descText.getText());
                } else if (selection instanceof GlueQuery) {
                    ((GlueQuery)selection).setDesc(GlueQueryMultiPageEditor.this.descText.getText());
                }
                GlueQueryMultiPageEditor.this.loadQueryEditor();
            }
        });
        this.resultTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Object selection = ((IStructuredSelection)GlueQueryMultiPageEditor.this.treeViewer.getSelection()).getFirstElement();
                if (selection instanceof GlueQuery) {
                    ((GlueQuery)selection).setResultType(GlueQueryMultiPageEditor.this.resultTypeText.getText());
                }
                GlueQueryMultiPageEditor.this.loadQueryEditor();
            }
        });
        this.namedChk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((IStructuredSelection)GlueQueryMultiPageEditor.this.treeViewer.getSelection()).getFirstElement();
                if (selection instanceof GlueQuery) {
                    ((GlueQuery)selection).setNamed(GlueQueryMultiPageEditor.this.namedChk.getSelection());
                }
                GlueQueryMultiPageEditor.this.loadQueryEditor();
                if (GlueQueryMultiPageEditor.this.queryText.getText().trim().toUpperCase().startsWith("SELECT") && !GlueQueryMultiPageEditor.this.namedChk.getSelection()) {
                    GlueQueryMultiPageEditor.this.controlButton(true, new String[]{"test", "bind"});
                } else {
                    GlueQueryMultiPageEditor.this.controlButton(false, new String[]{"test", "bind"});
                }
            }
        });
    }

    private void makeButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, true);
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1816);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        Button addButton = new Button(composite, 8);
        addButton.setText("Add Query");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Shell shell = new Shell();
                GlueQueryDialog glueQueryDialog = new GlueQueryDialog(shell);
                glueQueryDialog.open();
                if (glueQueryDialog.getReturnCode() == 0) {
                    HashMap<String, String> queryIDMap = new HashMap<String, String>();
                    try {
                        String projectName = ((IFileEditorInput)GlueQueryMultiPageEditor.this.getEditorInput()).getFile().getProject().getName();
                        List queryFileList = GlueEclipseProjectUtil.getFileList((String)"glue_sql", (String[])GlueEclipseProjectUtil.getProjectSourcePaths((String)projectName));
                        for (String queryFilePath : queryFileList) {
                            File queryFile = new File(queryFilePath);
                            for (String queryID : GlueQueryMultiPageEditor.this.parser.parseXml(queryFile).getQueryMap().keySet()) {
                                queryIDMap.put(queryID, queryFile.getName());
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Object selection = ((IStructuredSelection)GlueQueryMultiPageEditor.this.treeViewer.getSelection()).getFirstElement();
                    if (selection != null) {
                        String tempQueryID = glueQueryDialog.getId();
                        if (queryIDMap.containsKey(glueQueryDialog.getId())) {
                            MessageDialog.openInformation((Shell)new Shell(), (String)"Warning!", (String)("Query ID [" + tempQueryID + "] aleady exist in file [" + (String)queryIDMap.get(glueQueryDialog.getId()) + "]!"));
                            tempQueryID = String.valueOf(tempQueryID) + "_1";
                        }
                        GlueQuery glueQuery = ((GlueQueryMap)selection).newQuery();
                        glueQuery.setId(tempQueryID);
                        glueQuery.setDesc(glueQueryDialog.getDesc());
                        glueQuery.setResultType(glueQueryDialog.getResultType());
                        glueQuery.setNamed(glueQueryDialog.isNamedChkValue());
                        glueQuery.setSql(glueQueryDialog.getQuery());
                        GlueQueryMultiPageEditor.this.loadQueryEditor();
                    }
                }
            }
        });
        Button delButton = new Button(composite, 8);
        delButton.setText("Delete Query");
        delButton.setLayoutData((Object)new GridData(768));
        delButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selection = ((IStructuredSelection)GlueQueryMultiPageEditor.this.treeViewer.getSelection()).getFirstElement();
                if (selection != null) {
                    GlueQueryMultiPageEditor.this.treeViewer.remove(selection);
                    if (selection instanceof GlueQuery) {
                        GlueQuery query = (GlueQuery)selection;
                        query.getParent().removeQuery(query);
                    }
                }
            }
        });
        Button testButton = new Button(composite, 0);
        testButton.setText("Test Query");
        testButton.setEnabled(false);
        testButton.setToolTipText("DB SQL Test");
        testButton.setLayoutData((Object)new GridData(768));
        testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    GlueQueryMultiPageEditor.this.getSite().getPage().showView("com.poscoict.glueframework.plugin.query.editor.view.GlueQueryView");
                    GlueQueryView queryView = (GlueQueryView)GlueQueryMultiPageEditor.this.getSite().getPage().findView("com.poscoict.glueframework.plugin.query.editor.view.GlueQueryView");
                    Map queryResultMap = GlueQueryMultiPageEditor.this.executeQuery(GlueQueryMultiPageEditor.this.queryText.getText().trim());
                    queryView.modifyViewer((List)queryResultMap.get("column"), (List)queryResultMap.get("values"));
                }
                catch (CoreException e) {
                    GlueQueryMultiPageEditor.this.showErrorDialogNLogView("query error", "error executing query", e);
                }
            }
        });
        Button bindingButton = new Button(composite, 0);
        bindingButton.setText("Test Binding");
        bindingButton.setEnabled(false);
        bindingButton.setToolTipText("Binding List");
        bindingButton.setLayoutData((Object)new GridData(768));
        bindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    Shell shell = new Shell();
                    GlueBindingDialog bindingDialog = new GlueBindingDialog(shell);
                    bindingDialog.setBindCount(GlueQueryMultiPageEditor.this.getBindCountInQuery(GlueQueryMultiPageEditor.this.queryText.getText()));
                    bindingDialog.setBindValueList((List)GlueQueryMultiPageEditor.this.bindListMap.get(GlueQueryMultiPageEditor.this.idText.getText()));
                    bindingDialog.open();
                    if (bindingDialog.getReturnCode() == 0) {
                        GlueQueryMultiPageEditor.this.bindListMap.put(GlueQueryMultiPageEditor.this.idText.getText(), bindingDialog.getBindValueList());
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, "com.poscoict.glueframework.plugin.query.editor.designer", 0, "error binding query : " + e.getMessage(), (Throwable)e);
                    CoreException ce = new CoreException((IStatus)status);
                    GlueQueryMultiPageEditor.this.showErrorDialogNLogView("bind dialog error", ce.getMessage(), ce);
                }
            }
        });
        this.buttonMap.put("add", addButton);
        this.buttonMap.put("delete", delButton);
        this.buttonMap.put("test", testButton);
        this.buttonMap.put("bind", bindingButton);
    }

    private void makeQuerySql(Composite composite) {
        Group sqlGroup = new Group(composite, 4);
        sqlGroup.setText("SQL");
        sqlGroup.setLayout((Layout)new GridLayout());
        GridData sqlData = new GridData(1808);
        sqlData.horizontalSpan = 2;
        sqlData.minimumHeight = 150;
        sqlGroup.setLayoutData((Object)sqlData);
        this.queryText = new Text((Composite)sqlGroup, 2818);
        this.queryText.setLayoutData((Object)new GridData(1810));
        this.queryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (GlueQueryMultiPageEditor.this.queryText.getText() == null || "".equals(GlueQueryMultiPageEditor.this.queryText.getText().trim())) {
                    return;
                }
                String query = GlueQueryMultiPageEditor.this.queryText.getText();
                Object selection = ((IStructuredSelection)GlueQueryMultiPageEditor.this.treeViewer.getSelection()).getFirstElement();
                if (selection instanceof GlueQuery) {
                    ((GlueQuery)selection).setSql(query);
                }
                GlueQueryMultiPageEditor.this.loadQueryEditor();
                if (query.trim().toUpperCase().startsWith("SELECT") && !GlueQueryMultiPageEditor.this.namedChk.getSelection()) {
                    GlueQueryMultiPageEditor.this.controlButton(true, new String[]{"test", "bind"});
                } else {
                    GlueQueryMultiPageEditor.this.controlButton(false, new String[]{"test", "bind"});
                }
            }
        });
    }

    private void loadQueryTree() {
        String xmlContent = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        IFile queryFile = ((FileEditorInput)this.getEditorInput()).getFile();
        try {
            GlueQueryMapInfo mapInfo = this.parser.parseXmlString(xmlContent);
            GlueQueryRoot queryRoot = new GlueQueryRoot();
            GlueQueryMap queryMap = queryRoot.newQueryMap();
            queryMap.setName(queryFile.getName().substring(0, queryFile.getName().indexOf(".")));
            queryMap.setDesc(mapInfo.getDesc());
            GlueQuery glueQuery = null;
            for (Map.Entry entry : mapInfo.getQueryMap().entrySet()) {
                GlueQueryMapInfo.GlueQueryInfo queryInfo = (GlueQueryMapInfo.GlueQueryInfo)entry.getValue();
                glueQuery = queryMap.newQuery();
                glueQuery.setId(queryInfo.getId());
                glueQuery.setDesc(queryInfo.getDesc());
                glueQuery.setResultType(queryInfo.getResultType());
                glueQuery.setNamed(queryInfo.isNamed());
                glueQuery.setSql(queryInfo.getSql());
            }
            this.treeViewer.setInput((Object)queryRoot);
            this.treeViewer.refresh();
            this.treeViewer.expandAll();
        }
        catch (Exception ex) {
            Status status = new Status(4, "com.poscoict.glueframework.plugin.query.editor.designer", 0, "making query tree error. : " + ex.getMessage(), ex.getCause());
            this.showErrorDialogNLogView("xml parsing error", "this file is invalid.", new CoreException((IStatus)status));
        }
    }

    private void loadQueryEditor() {
        try {
            GlueQueryRoot root = (GlueQueryRoot)this.treeViewer.getInput();
            GlueQueryMap queryMap = root.getChildren().get(0);
            GlueQueryMapInfo mapInfo = new GlueQueryMapInfo(queryMap.getDesc());
            for (GlueQuery glueQuery : queryMap) {
                String id = glueQuery.getId();
                String desc = glueQuery.getDesc();
                String resultType = glueQuery.getResultType();
                boolean isNamed = glueQuery.isNamed();
                String sql = glueQuery.getSql();
                mapInfo.addQueryInfo(id, desc, resultType, isNamed, sql);
            }
            this.treeViewer.refresh(true);
            IDocument queryDocument = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            String newQuery = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + this.parser.makeXmlString(mapInfo);
            if (!queryDocument.get().equals(newQuery)) {
                queryDocument.set(newQuery);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "com.poscoict.glueframework.plugin.query.editor.designer", 0, "error updating texteditor from tree\n" + e.getMessage(), (Throwable)e);
            CoreException ce = new CoreException((IStatus)status);
            this.showErrorDialogNLogView("error update textEditor", ce.getMessage(), ce);
        }
    }

    private void showErrorDialogNLogView(String title, String message, CoreException e) {
        ErrorDialog.openError((Shell)super.getSite().getShell(), (String)title, (String)message, (IStatus)e.getStatus());
    }

    private Map<String, Object> executeQuery(String query) throws CoreException {
        String driverFilePath = GlueQueryEditorPlugin.getDefault().getPreferenceStore().getString("GLUE_DRIVER_PATH");
        String driverClassName = GlueQueryEditorPlugin.getDefault().getPreferenceStore().getString("GLUE_CLASS_NAME");
        String connectionUrl = GlueQueryEditorPlugin.getDefault().getPreferenceStore().getString("GLUE_CONNECTION_URL");
        String userName = GlueQueryEditorPlugin.getDefault().getPreferenceStore().getString("GLUE_USER_NAME");
        String password = GlueQueryEditorPlugin.getDefault().getPreferenceStore().getString("GLUE_PASSWORD");
        Connection connection = this.getConnection(driverFilePath, driverClassName, connectionUrl, userName, password);
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            if (query == null || "".equals(query)) {
                throw new Exception("Query is empty");
            }
            stmt = connection.prepareStatement(query);
            List<String> bindList = this.bindListMap.get(this.idText.getText());
            if (query.indexOf("?") >= 0 && bindList != null && !bindList.isEmpty()) {
                int i = 1;
                while (i <= bindList.size()) {
                    stmt.setObject(i, bindList.get(i - 1));
                    ++i;
                }
            } else {
                query = query.replaceAll("\\?", "null");
            }
            resultSet = stmt.executeQuery();
            ResultSetMetaData meta = resultSet.getMetaData();
            ArrayList<String> columnNameList = new ArrayList<String>();
            int i = 0;
            while (i < meta.getColumnCount()) {
                columnNameList.add(meta.getColumnName(i + 1));
                ++i;
            }
            ArrayList resultList = new ArrayList();
            while (resultSet.next()) {
                ArrayList<Object> valueList = new ArrayList<Object>();
                for (String columnName : columnNameList) {
                    valueList.add(resultSet.getObject(columnName));
                }
                resultList.add(valueList);
            }
            HashMap<String, Object> queryMap = new HashMap<String, Object>(2);
            queryMap.put("column", columnNameList);
            queryMap.put("values", resultList);
            HashMap<String, Object> hashMap = queryMap;
            return hashMap;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.poscoict.glueframework.plugin.query.editor.designer", 0, "Error Executing Query : " + e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                    stmt.close();
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Connection getConnection(String driverFilePath, String driverClassName, String connectionUrl, String userName, String password) throws CoreException {
        try {
            if (driver == null) {
                URL[] classes = new URL[]{new File(driverFilePath).toURI().toURL()};
                URLClassLoader loader = new URLClassLoader(classes, ((Object)((Object)this)).getClass().getClassLoader());
                Class<?> clazz = Class.forName(driverClassName, true, loader);
                driver = (Driver)clazz.newInstance();
            }
            Properties props = new Properties();
            props.put("user", userName);
            props.put("password", password);
            return driver.connect(connectionUrl, props);
        }
        catch (Exception ex) {
            Status status = new Status(4, "com.poscoict.glueframework.plugin.query.editor.designer", 0, "Error DB Connection : " + ex.getMessage(), (Throwable)ex);
            throw new CoreException((IStatus)status);
        }
    }

    private int getBindCountInQuery(String query) {
        if (query.endsWith("?")) {
            query = String.valueOf(query) + " ";
        }
        String[] splitQuery = query.split("\\?");
        return splitQuery.length - 1;
    }

    private void controlButton(boolean enabled, String ... buttonNames) {
        if (!"".equals(buttonNames[0])) {
            String[] stringArray = buttonNames;
            int n = buttonNames.length;
            int n2 = 0;
            while (n2 < n) {
                String buttonName = stringArray[n2];
                this.buttonMap.get(buttonName).setEnabled(enabled);
                ++n2;
            }
        } else {
            for (Button button : this.buttonMap.values()) {
                button.setEnabled(enabled);
            }
        }
    }

    private void superSetInput(IEditorInput input) {
        IFile file;
        if (super.getEditorInput() != null) {
            file = ((FileEditorInput)super.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
        super.setInput(input);
        if (super.getEditorInput() != null) {
            file = ((FileEditorInput)super.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener(this.resourceListener);
            super.setPartName(file.getName());
        }
    }

    private void closeEditor(boolean save) {
        IWorkbenchPage[] iWorkbenchPageArray = super.getSite().getWorkbenchWindow().getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            page.closeEditor(page.findEditor(this.editor.getEditorInput()), save);
            ++n2;
        }
    }

    private class GlueQueryResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private GlueQueryResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {}
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta == null || !delta.getResource().equals((Object)((FileEditorInput)GlueQueryMultiPageEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                Display display = GlueQueryMultiPageEditor.this.getSite().getShell().getDisplay();
                if ((0x2000 & delta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!GlueQueryMultiPageEditor.this.isDirty()) {
                                GlueQueryMultiPageEditor.this.closeEditor(false);
                            }
                        }
                    });
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GlueQueryMultiPageEditor.this.superSetInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }
    }
}

