/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.sdk.wizards;

import com.poscoict.mobileframework.sdk.wizards.GlueJSConstants;
import com.poscoict.mobileframework.sdk.wizards.IGlueMobileCreationPage;
import com.poscoict.mobileframework.sdk.wizards.PageCreationUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class ViewCreationPage
extends WizardNewFileCreationPage
implements GlueJSConstants,
IGlueMobileCreationPage {
    private final IWorkbench workbench;
    private static int count = 1;
    private PageCreationUtils pageUtils = new PageCreationUtils(this);
    private String el = "#contents";
    private String template = "templateFileName";
    private String collection = "collection";
    private String model;
    private String modelType = this.model = "model";
    private String modelText = "Model Name";
    private String onBeforeRender = "console.log('onBeforeRender')";
    private String onAfterRender = "console.log('onAfterRender')";

    public ViewCreationPage(IWorkbench workbench, IStructuredSelection selection) {
        super("Glue Mobile Model Wizard", selection);
        this.setTitle("Mobile View");
        this.setDescription("Mobile View File");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        Composite topLevel = this.pageUtils.createTopLevelComposite(parent, 1);
        Composite myLevel = this.pageUtils.createComposite(topLevel);
        this.pageUtils.addLabelText(myLevel, "el", this.el, Component.EL.ordinal());
        this.pageUtils.addLabelText(myLevel, "template", this.template, Component.TEMPLATE.ordinal());
        Composite radioTextComposite = this.pageUtils.createComposite(myLevel);
        Composite positionComposite = this.pageUtils.createCompositeWithStyle(radioTextComposite, 3, 0);
        Label positionLabel = new Label(positionComposite, 0);
        positionLabel.setText("model:  ");
        this.pageUtils.addRadio(positionComposite, "model", true, Component.MODEL.ordinal());
        this.pageUtils.addRadio(positionComposite, "collection", false, Component.COLLECTION.ordinal());
        Composite textComposite = this.pageUtils.createComposite(radioTextComposite, 0);
        this.pageUtils.addText(textComposite, "", this.modelText, Component.MODELTEXT.ordinal());
        this.pageUtils.addLabelText(myLevel, "onBeforeRender", this.onBeforeRender, Component.ONBEFORERENDER.ordinal());
        this.pageUtils.addLabelText(myLevel, "onAfterRender", this.onAfterRender, Component.ONAFTERRENDER.ordinal());
        super.createControl(topLevel);
        this.setFileName("GlueView" + count + ".js");
        super.setPageComplete(super.validatePage());
    }

    public InputStream getInitialContents() {
        Map<String, String> dataModel = this.makeDataModel();
        String contents = this.pageUtils.makeTemplateCode(dataModel, "view.ftl");
        return new ByteArrayInputStream(contents.getBytes());
    }

    @Override
    public boolean finish() {
        IFile newFile = super.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        ++count;
        return true;
    }

    @Override
    public void setBooleanType(int ele, boolean value) {
        Component cfr_ignored_0 = Component.values()[ele];
    }

    @Override
    public void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case EL: {
                this.el = value;
                break;
            }
            case TEMPLATE: {
                this.template = value;
                break;
            }
            case MODEL: {
                this.model = value;
                this.modelType = "model";
                break;
            }
            case COLLECTION: {
                this.modelType = "collection";
                break;
            }
            case ONBEFORERENDER: {
                this.onBeforeRender = value;
                break;
            }
            case ONAFTERRENDER: {
                this.onAfterRender = value;
                break;
            }
            case MODELTEXT: {
                this.modelText = value;
            }
        }
    }

    public Map<String, String> makeDataModel() {
        HashMap<String, String> dataModel = new HashMap<String, String>();
        dataModel.put("el", this.el.trim());
        dataModel.put("template", this.template.trim());
        dataModel.put("modelType", this.modelType.trim());
        dataModel.put("modelText", this.modelText.trim());
        dataModel.put("onBeforeRender", this.onBeforeRender.trim());
        dataModel.put("onAfterRender", this.onAfterRender.trim());
        return dataModel;
    }

    private static enum Component {
        EL,
        TEMPLATE,
        MODEL,
        COLLECTION,
        ONBEFORERENDER,
        ONAFTERRENDER,
        MODELTEXT;

    }
}

