/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.sdk.wizards;

import com.poscoict.mobileframework.htmleditor.datamodel.TemplateConfiguration;
import com.poscoict.mobileframework.sdk.wizards.IGlueMobileCreationPage;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PageCreationUtils {
    private IGlueMobileCreationPage defaultCreationPage;

    protected PageCreationUtils(IGlueMobileCreationPage defaultCreationPage) {
        this.defaultCreationPage = defaultCreationPage;
    }

    protected Map<String, ?> makeDataModel() {
        return this.defaultCreationPage.makeDataModel();
    }

    protected void setBooleanType(int ele, boolean value) {
        this.defaultCreationPage.setBooleanType(ele, value);
    }

    protected void setStringType(int ele, String value) {
        this.defaultCreationPage.setStringType(ele, value);
    }

    protected Composite createTopLevelComposite(Composite container, int layout) {
        Composite composite = new Composite(container, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.verticalSpan = 2;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(layout, false);
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    protected Text addLabelText(Composite container, String titleText, String textValue, final int eleId) {
        Label labelCom = new Label(container, 0);
        labelCom.setText(titleText);
        final Text textCom = new Text(container, 2048);
        textCom.setText(textValue);
        textCom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PageCreationUtils.this.setStringType(eleId, textCom.getText());
            }
        });
        textCom.setLayoutData((Object)new GridData(4, 4, true, false));
        return textCom;
    }

    protected void addText(Composite container, String titleText, String textValue, final int eleId) {
        final Text textCom = new Text(container, 2048);
        textCom.setText(textValue);
        textCom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PageCreationUtils.this.setStringType(eleId, textCom.getText());
            }
        });
        textCom.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected void addLineHorizontal(Composite container) {
        GridData gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        Label label = new Label(container, 258);
        label.setLayoutData((Object)gridData);
    }

    protected void addCheckButtonText(Composite container, String headerText, String textvalue, boolean checked, final int eleId) {
        final Button checkButton = new Button(container, 32);
        final Text headLabel = new Text(container, 2048);
        checkButton.setText(headerText);
        checkButton.setSelection(checked);
        headLabel.setText(textvalue);
        headLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkButton.getSelection()) {
                    PageCreationUtils.this.setBooleanType(eleId, true);
                    headLabel.setEditable(true);
                } else {
                    PageCreationUtils.this.setBooleanType(eleId, false);
                    headLabel.setEditable(false);
                }
            }
        });
        headLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PageCreationUtils.this.setStringType(eleId, headLabel.getText());
            }
        });
    }

    protected void addCheckButton(Composite container, String labelText, boolean checked, final int eleId) {
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        final Button checkButton = new Button(container, 32);
        checkButton.setText(labelText);
        checkButton.setSelection(checked);
        checkButton.setLayoutData((Object)gridData);
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkButton.getSelection()) {
                    PageCreationUtils.this.setBooleanType(eleId, true);
                } else {
                    PageCreationUtils.this.setBooleanType(eleId, false);
                }
            }
        });
    }

    protected void addLabelCheckButton(Composite container, String labelText, boolean checked, final int eleId) {
        Label label = new Label(container, 0);
        label.setText(labelText);
        final Button checkButton = new Button(container, 32);
        checkButton.setSelection(checked);
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkButton.getSelection()) {
                    PageCreationUtils.this.setBooleanType(eleId, true);
                } else {
                    PageCreationUtils.this.setBooleanType(eleId, false);
                }
            }
        });
        checkButton.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected Composite createComposite(Composite container) {
        return this.createCompositeWithStyle(container, 2, 2048);
    }

    protected Composite createComposite(Composite container, int style) {
        return this.createCompositeWithStyle(container, 2, style);
    }

    protected Composite createCompositeWithStyle(Composite container, int layout, int style) {
        Composite composite = new Composite(container, style);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(layout, false));
        return composite;
    }

    protected Composite createCompositeWithOptions(Composite container, int layout, int style) {
        Composite composite = new Composite(container, style);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 10;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(layout, false));
        return composite;
    }

    protected Composite createGroup(Composite container, String title) {
        return this.createGroupWithStyle(container, title, 4, 0);
    }

    protected Composite createGroup(Composite container, String title, int style) {
        return this.createGroupWithStyle(container, title, 4, style);
    }

    protected Composite createGroupWithStyle(Composite container, String title, int layout, int style) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        Group group = new Group(container, style);
        group.setText(title);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(layout, false));
        return group;
    }

    protected void addCombo(Composite container, String label, String[] elements, int eleId) {
        this.addCombo(container, label, elements, "", eleId);
    }

    protected Combo addCombo(Composite container, String label, String[] elements, String initValue, final int eleId) {
        Label labelCom = new Label(container, 0);
        labelCom.setText(label);
        final Combo comboEle = new Combo(container, 2052);
        Arrays.sort(elements);
        int i = 0;
        while (i < elements.length) {
            comboEle.add(elements[i]);
            ++i;
        }
        comboEle.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PageCreationUtils.this.setStringType(eleId, comboEle.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = comboEle.getText();
                if (comboEle.indexOf(text) < 0) {
                    comboEle.add(text);
                    Object[] items = comboEle.getItems();
                    Arrays.sort(items);
                    comboEle.setItems((String[])items);
                }
            }
        });
        comboEle.setText(initValue);
        comboEle.setLayoutData((Object)new GridData(4, 4, true, false));
        return comboEle;
    }

    protected Button addRadio(Composite container, String label, boolean selected, final int eleId) {
        final Button radio = new Button(container, 16);
        radio.setText(label);
        radio.setSelection(selected);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageCreationUtils.this.setStringType(eleId, radio.getText());
            }
        });
        radio.setLayoutData((Object)new GridData(4, 4, true, true));
        return radio;
    }

    protected void addRadioSelectionAdapter(final Button radio, final int eleId, final Control[] controls) {
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageCreationUtils.this.setStringType(eleId, radio.getText());
                if (radio.getSelection()) {
                    Control[] controlArray = controls;
                    int n = controls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.setEnabled(true);
                        ++n2;
                    }
                } else {
                    Control[] controlArray = controls;
                    int n = controls.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Control control = controlArray[n3];
                        control.setEnabled(false);
                        ++n3;
                    }
                }
            }
        });
        radio.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected String makeTemplateCode(Map dataModel, String fileName) {
        StringWriter out = new StringWriter();
        Template temp = TemplateConfiguration.getInstance().getTemplate("gluejs/" + fileName);
        try {
            temp.process((Object)dataModel, (Writer)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((Object)out).toString();
    }
}

