/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.sdk.wizards;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.utils.BundleLocator;
import com.poscoict.mobileframework.sdk.wizards.GlueJSConstants;
import com.poscoict.mobileframework.sdk.wizards.IGlueMobileCreationPage;
import com.poscoict.mobileframework.sdk.wizards.JavascriptAnalyzeUtils;
import com.poscoict.mobileframework.sdk.wizards.PageCreationUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;

public class PageCreationPage
extends WizardPage
implements GlueJSConstants,
IGlueMobileCreationPage {
    private String naviType = "page";
    private String pageName = "pageName";
    private String eventType = "click";
    private String tagId = "#contents";
    private String controlFuncName = "controllerFunction";
    private boolean hasModel = true;
    private boolean hasCollection = true;
    private boolean hasView = true;
    private boolean hasTemplate = true;
    private final IWorkbench workbench;
    private ContainerSelectionGroup containerGroup;
    private PageCreationUtils pageUtils = new PageCreationUtils(this);

    public PageCreationPage(IWorkbench workbench, IStructuredSelection selection) {
        super("Glue Mobile Page Wizard");
        this.setTitle("Mobile Page");
        this.setDescription("Mobile Page Files");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        Composite controller = this.pageUtils.createTopLevelComposite(parent, 1);
        Label appLabel = new Label(controller, 0);
        appLabel.setText("appliction");
        Composite appGroup = this.pageUtils.createComposite(controller);
        Button pageRadio = this.pageUtils.addRadio(appGroup, "page", true, Component.PAGE.ordinal());
        Composite pageGroup = this.pageUtils.createCompositeWithOptions(appGroup, 2, 0);
        Text pageText = this.pageUtils.addLabelText(pageGroup, "name", this.pageName, Component.PAGE_NAME.ordinal());
        Control[] pageControls = new Control[]{pageText};
        Button eventRadio = this.pageUtils.addRadio(appGroup, "event", false, Component.EVENT.ordinal());
        Composite eventGroup = this.pageUtils.createCompositeWithOptions(appGroup, 4, 0);
        Combo combo = this.pageUtils.addCombo(eventGroup, "type", EVENT_TYPES, this.eventType, Component.EVENT_TYPE.ordinal());
        Text eventText = this.pageUtils.addLabelText(eventGroup, "html_tag_id", "html_tag_id", Component.TAG_ID.ordinal());
        combo.setEnabled(false);
        eventText.setEnabled(false);
        Control[] eventControls = new Control[]{combo, eventText};
        this.pageUtils.addRadioSelectionAdapter(pageRadio, Component.PAGE.ordinal(), pageControls);
        this.pageUtils.addRadioSelectionAdapter(eventRadio, Component.EVENT.ordinal(), eventControls);
        Label ctrlLabel = new Label(controller, 0);
        ctrlLabel.setText("controller");
        Composite ctrlGroup = this.pageUtils.createComposite(controller);
        this.pageUtils.addLabelText(ctrlGroup, "function", this.controlFuncName, Component.CONTROL.ordinal());
        this.pageUtils.addCheckButton(controller, "model", true, Component.MODEL.ordinal());
        this.pageUtils.addCheckButton(controller, "collection", true, Component.COLLECTION.ordinal());
        this.pageUtils.addCheckButton(controller, "view", true, Component.VIEW.ordinal());
        this.pageUtils.addCheckButton(controller, "template", true, Component.TEMPLATE.ordinal());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
            }
        };
        this.containerGroup = new ContainerSelectionGroup(controller, listener, true, null, true, 120, 10);
        IProject iproject = BundleLocator.getInstance().getCurrentProject();
        IPath path = null;
        if (iproject != null) {
            path = iproject.getFullPath();
        }
        this.setSelectedContainer(this.containerGroup, path);
        this.setControl((Control)controller);
        this.setPageComplete(true);
    }

    public void setSelectedContainer(ContainerSelectionGroup containerGroup, IPath path) {
        IResource initial = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (initial != null) {
            if (!(initial instanceof IContainer)) {
                initial = initial.getParent();
            }
            containerGroup.setSelectedContainer((IContainer)initial);
        }
    }

    private String covertStreamToString(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder out = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            out.append(line);
            out.append(newLine);
        }
        return out.toString();
    }

    private void createModuleFile(IProject iproject, String filePath, String templateFileName) throws CoreException {
        String[] subDirs = filePath.split("/");
        String path = "";
        int i = 0;
        while (i < subDirs.length - 1) {
            IFolder moduleFolder = iproject.getFolder(path = String.valueOf(path) + subDirs[i] + "/");
            if (!moduleFolder.exists()) {
                moduleFolder.create(true, true, null);
            }
            ++i;
        }
        IFile modelIFile = iproject.getFile(filePath);
        Map<String, Object> dataModel = this.makeDataModel();
        String module = this.pageUtils.makeTemplateCode(dataModel, templateFileName);
        modelIFile.create((InputStream)new ByteArrayInputStream(module.getBytes()), true, null);
    }

    private void addPropertiesModule(IProject iproject, String filePath, String templateFileName, String scriptFileName) throws CoreException, IOException, NoSuchMethodException, ScriptException {
        IFile file = iproject.getFile(filePath);
        if (!file.exists()) {
            this.createModuleFile(iproject, filePath, templateFileName);
        }
        String scriptContents = this.covertStreamToString(file.getContents());
        Map<String, Object> dataModel = this.makeDataModel();
        String javascript = this.pageUtils.makeTemplateCode(dataModel, scriptFileName);
        String modifiedContents = JavascriptAnalyzeUtils.getInstance().esprimaParse(scriptContents, javascript);
        file.setContents((InputStream)new ByteArrayInputStream(modifiedContents.getBytes()), 2, null);
    }

    @Override
    public boolean finish() {
        this.containerGroup.getContainerFullPath();
        IProject iproject = BundleLocator.getInstance().getCurrentProject();
        if (iproject == null) {
            return false;
        }
        if (iproject.exists() && !iproject.isOpen()) {
            try {
                iproject.open(null);
            }
            catch (CoreException cex) {
                cex.printStackTrace();
            }
        }
        String modelPath = "WebContent/js/models/" + this.pageName + "Model.js";
        String viewPath = "WebContent/js/views/" + this.pageName + "View.js";
        String collectionPath = "WebContent/js/collections/" + this.pageName + "Collection.js";
        String templatePath = "WebContent/templates/" + this.pageName + "Template.html";
        if (iproject.getFile(modelPath).exists() || iproject.getFile(viewPath).exists() || iproject.getFile(collectionPath).exists() || iproject.getFile(templatePath).exists()) {
            return false;
        }
        try {
            this.createModuleFile(iproject, modelPath, "model.ftl");
            this.createModuleFile(iproject, viewPath, "view.ftl");
            this.createModuleFile(iproject, collectionPath, "collection.ftl");
            this.createModuleFile(iproject, templatePath, "template.ftl");
            this.addPropertiesModule(iproject, "WebContent/js/App.js", "app.ftl", "addAppProperty.ftl");
            this.addPropertiesModule(iproject, "WebContent/js/controllers/Controller.js", "controller.ftl", "addControllerProperty.ftl");
        }
        catch (Exception cex) {
            cex.printStackTrace();
        }
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        store.getString("_pref_palette_image_color");
        return true;
    }

    @Override
    public void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case MODEL: {
                this.hasModel = value;
                break;
            }
            case COLLECTION: {
                this.hasCollection = value;
                break;
            }
            case VIEW: {
                this.hasView = value;
                break;
            }
            case TEMPLATE: {
                this.hasTemplate = value;
            }
        }
    }

    @Override
    public void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case PAGE: {
                this.naviType = value;
                break;
            }
            case EVENT: {
                this.naviType = value;
                break;
            }
            case PAGE_NAME: {
                this.pageName = value;
                break;
            }
            case EVENT_TYPE: {
                this.eventType = value;
                break;
            }
            case TAG_ID: {
                this.tagId = value;
                break;
            }
            case CONTROL: {
                this.controlFuncName = value;
            }
        }
    }

    public Map<String, Object> makeDataModel() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("isView", Boolean.toString(this.hasView));
        dataModel.put("viewName", String.valueOf(this.pageName) + "View");
        dataModel.put("isModel", Boolean.toString(this.hasModel));
        dataModel.put("modelName", String.valueOf(this.pageName) + "Model");
        dataModel.put("isCollection", Boolean.toString(this.hasCollection));
        dataModel.put("collectionName", String.valueOf(this.pageName) + "Collection");
        dataModel.put("isTemplate", Boolean.toString(this.hasTemplate));
        dataModel.put("templateName", String.valueOf(this.pageName) + "Template");
        dataModel.put("functionName", this.controlFuncName);
        if (this.naviType == "page") {
            dataModel.put("isPage", Boolean.toString(true));
            dataModel.put("pageName", this.pageName);
            dataModel.put("isEvent", Boolean.toString(false));
            dataModel.put("eventType", this.eventType);
            dataModel.put("tagId", this.tagId);
        } else if (this.naviType == "event") {
            dataModel.put("isPage", Boolean.toString(false));
            dataModel.put("pageName", this.pageName);
            dataModel.put("isEvent", Boolean.toString(true));
            dataModel.put("eventType", this.eventType);
            dataModel.put("tagId", this.tagId);
        }
        dataModel.put("idAttributes", "id");
        dataModel.put("urlType", "url");
        dataModel.put("urlText", "http://localhost:8080");
        dataModel.put("el", "#div_tag");
        dataModel.put("template", String.valueOf(this.pageName) + "Template");
        dataModel.put("modelType", "collection");
        dataModel.put("modelText", String.valueOf(this.pageName) + "Collection");
        dataModel.put("onBeforeRender", "console.log('onBeforeRender')");
        dataModel.put("onAfterRender", "console.log('onAfterRender')");
        dataModel.put("url", "http://localhost:8080");
        dataModel.put("model", String.valueOf(this.pageName) + "Model");
        dataModel.put("initialize", "console.log('initialize');");
        dataModel.put("defaultAction", "console.log('defaultAction');");
        return dataModel;
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("naviType : " + this.naviType);
        strBuffer.append("\n");
        strBuffer.append("pageName : " + this.pageName);
        strBuffer.append("\n");
        strBuffer.append("eventType : " + this.eventType);
        strBuffer.append("\n");
        strBuffer.append("tagId : " + this.tagId);
        strBuffer.append("\n");
        strBuffer.append("model : " + this.hasModel);
        strBuffer.append("\n");
        strBuffer.append("collection : " + this.hasCollection);
        strBuffer.append("\n");
        strBuffer.append("view : " + this.hasView);
        strBuffer.append("\n");
        strBuffer.append("template : " + this.hasTemplate);
        strBuffer.append("\n");
        return strBuffer.toString();
    }

    private static enum Component {
        PAGE,
        EVENT,
        PAGE_NAME,
        EVENT_TYPE,
        TAG_ID,
        CONTROL,
        MODEL,
        COLLECTION,
        VIEW,
        TEMPLATE;

    }
}

