/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.sdk.wizards;

import com.poscoict.mobileframework.sdk.wizards.GlueJSConstants;
import com.poscoict.mobileframework.sdk.wizards.IGlueMobileCreationPage;
import com.poscoict.mobileframework.sdk.wizards.PageCreationUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class ModelCreationPage
extends WizardNewFileCreationPage
implements GlueJSConstants,
IGlueMobileCreationPage {
    private final IWorkbench workbench;
    private static int count = 1;
    private PageCreationUtils pageUtils = new PageCreationUtils(this);
    private String moduleName = "GlueJS Model";
    private String idAttributes = "id";
    private String urlType = "url";
    private String urlText = "http://localhost:8080/context_root";

    public ModelCreationPage(IWorkbench workbench, IStructuredSelection selection) {
        super("Glue Mobile Model Wizard", selection);
        this.setTitle("Mobile Model");
        this.setDescription("Mobile Model File");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        Composite topLevel = this.pageUtils.createTopLevelComposite(parent, 1);
        Composite myLevel = this.pageUtils.createComposite(topLevel);
        this.pageUtils.addLabelText(myLevel, "idAttributes", this.idAttributes, Component.IDATTRIBUTES.ordinal());
        Composite radioTextComposite = this.pageUtils.createComposite(myLevel);
        Composite positionComposite = this.pageUtils.createCompositeWithStyle(radioTextComposite, 3, 0);
        Label positionLabel = new Label(positionComposite, 0);
        positionLabel.setText("url : ");
        this.pageUtils.addRadio(positionComposite, "url", true, Component.URL.ordinal());
        this.pageUtils.addRadio(positionComposite, "urlRoot", false, Component.URLROOT.ordinal());
        Composite textComposite = this.pageUtils.createComposite(radioTextComposite, 0);
        this.pageUtils.addText(textComposite, "", this.urlText, Component.URLTEXT.ordinal());
        super.createControl(topLevel);
        this.setFileName("GlueModel" + count + ".js");
        super.setPageComplete(super.validatePage());
    }

    public InputStream getInitialContents() {
        Map<String, String> dataModel = this.makeDataModel();
        String contents = this.pageUtils.makeTemplateCode(dataModel, "model.ftl");
        return new ByteArrayInputStream(contents.getBytes());
    }

    @Override
    public boolean finish() {
        IFile newFile = super.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        ++count;
        return true;
    }

    @Override
    public void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case MODULENAME: {
                break;
            }
            case IDATTRIBUTES: {
                break;
            }
            case URL: {
                break;
            }
        }
    }

    @Override
    public void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case MODULENAME: {
                this.moduleName = value;
                break;
            }
            case IDATTRIBUTES: {
                this.idAttributes = value;
                break;
            }
            case URL: {
                this.urlType = value;
                break;
            }
            case URLROOT: {
                this.urlType = value;
                break;
            }
            case URLTEXT: {
                this.urlText = value;
            }
        }
    }

    public Map<String, String> makeDataModel() {
        HashMap<String, String> dataModel = new HashMap<String, String>();
        dataModel.put("idAttributes", this.idAttributes.trim());
        dataModel.put("urlType", this.urlType.trim());
        dataModel.put("urlText", this.urlText.trim());
        return dataModel;
    }

    private static enum Component {
        MODULENAME,
        IDATTRIBUTES,
        URL,
        URLROOT,
        URLTEXT;

    }
}

