/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.sdk.wizards;

import com.poscoict.mobileframework.sdk.wizards.GlueJSConstants;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.Platform;

public class JavascriptAnalyzeUtils
implements GlueJSConstants {
    private static final JavascriptAnalyzeUtils jsManipulator = new JavascriptAnalyzeUtils();
    private ScriptEngine engine;
    private CompiledScript script;

    private JavascriptAnalyzeUtils() {
        try {
            String parser = this.readFile("esprima.js");
            String traverse = this.readFile("estraverse.js");
            String code = this.readFile("code.js");
            String codegen = this.readFile("escodegen.js");
            ScriptEngineManager factory = new ScriptEngineManager();
            this.engine = factory.getEngineByName("JavaScript");
            this.engine.eval(parser);
            this.engine.eval(traverse);
            this.engine.eval(code);
            this.engine.eval(codegen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JavascriptAnalyzeUtils getInstance() {
        return jsManipulator;
    }

    public String readFile(String fileName) throws IOException, FileNotFoundException {
        String path = "ui/lib/" + fileName;
        URL url = Platform.getBundle((String)"com.poscoict.mobileframework.htmleditor").getEntry(path);
        InputStream inputStream = url.openStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        return IOUtils.toString((Reader)in);
    }

    public String esprimaParse(String jsContents, String jsFunction) throws ScriptException, NoSuchMethodException {
        Object result = new Object();
        this.engine.eval(jsFunction);
        Invocable inv = (Invocable)((Object)this.engine);
        result = inv.invokeFunction("analyzeCode", jsContents);
        return result.toString();
    }
}

