/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.sdk.wizards;

import com.poscoict.mobileframework.sdk.wizards.GlueJSConstants;
import com.poscoict.mobileframework.sdk.wizards.IGlueMobileCreationPage;
import com.poscoict.mobileframework.sdk.wizards.PageCreationUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class ControllerCreationPage
extends WizardNewFileCreationPage
implements GlueJSConstants,
IGlueMobileCreationPage {
    private final IWorkbench workbench;
    private static int count = 1;
    private String initialize = "console.log('initialize function is called ')";
    private String defaultAction = "console.log('defaultAction function is called ')";
    private PageCreationUtils pageUtils = new PageCreationUtils(this);

    public ControllerCreationPage(IWorkbench workbench, IStructuredSelection selection) {
        super("Glue Mobile Controller Wizard", selection);
        this.setTitle("Mobile Controller");
        this.setDescription("Mobile Controller File");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        Composite topLevel = this.pageUtils.createTopLevelComposite(parent, 1);
        Composite myLevel = this.pageUtils.createComposite(topLevel);
        this.pageUtils.addLabelText(myLevel, "initialize", "console.log('initialize function is called ')", Component.INITIALIZE.ordinal());
        this.pageUtils.addLabelText(myLevel, "defaultAction", "console.log('defaultAction function is called ')", Component.DEFAULTACTION.ordinal());
        super.createControl(topLevel);
        this.setFileName("GlueController" + count + ".js");
        super.setPageComplete(super.validatePage());
    }

    public InputStream getInitialContents() {
        Map<String, String> dataModel = this.makeDataModel();
        String contents = this.pageUtils.makeTemplateCode(dataModel, "controller.ftl");
        return new ByteArrayInputStream(contents.getBytes());
    }

    @Override
    public boolean finish() {
        IFile newFile = super.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        ++count;
        return true;
    }

    @Override
    public void setBooleanType(int ele, boolean value) {
        Component cfr_ignored_0 = Component.values()[ele];
    }

    @Override
    public void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case INITIALIZE: {
                this.initialize = value;
                break;
            }
            case DEFAULTACTION: {
                this.defaultAction = value;
            }
        }
    }

    public Map<String, String> makeDataModel() {
        HashMap<String, String> dataModel = new HashMap<String, String>();
        dataModel.put("initialize", this.initialize.trim());
        dataModel.put("defaultAction", this.defaultAction.trim());
        return dataModel;
    }

    private static enum Component {
        INITIALIZE,
        DEFAULTACTION;

    }
}

