/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.sdk.wizards;

import com.poscoict.mobileframework.sdk.wizards.GlueJSConstants;
import com.poscoict.mobileframework.sdk.wizards.IGlueMobileCreationPage;
import com.poscoict.mobileframework.sdk.wizards.PageCreationUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class CollectionCreationPage
extends WizardNewFileCreationPage
implements GlueJSConstants,
IGlueMobileCreationPage {
    private final IWorkbench workbench;
    private static int count = 1;
    private String model = "'ModelName'";
    private String url = "http://localhost:8080/context_root";
    private PageCreationUtils pageUtils = new PageCreationUtils(this);

    public CollectionCreationPage(IWorkbench workbench, IStructuredSelection selection) {
        super("Glue Mobile Collection Wizard", selection);
        this.setTitle("Mobile Collection");
        this.setDescription("Mobile Collection File");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        Composite topLevel = this.pageUtils.createTopLevelComposite(parent, 1);
        Composite myLevel = this.pageUtils.createComposite(topLevel);
        this.pageUtils.addLabelText(myLevel, "model", "'ModelName'", Component.MODEL.ordinal());
        this.pageUtils.addLabelText(myLevel, "url", "http://localhost:8080/context_root", Component.URL.ordinal());
        super.createControl(topLevel);
        this.setFileName("GlueCollection" + count + ".js");
        super.setPageComplete(super.validatePage());
    }

    public InputStream getInitialContents() {
        String contents = this.pageUtils.makeTemplateCode(this.makeDataModel(), "collection.ftl");
        return new ByteArrayInputStream(contents.getBytes());
    }

    @Override
    public boolean finish() {
        IFile newFile = super.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        ++count;
        return true;
    }

    @Override
    public void setBooleanType(int ele, boolean value) {
    }

    @Override
    public void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case MODEL: {
                this.model = value;
                break;
            }
            case URL: {
                this.url = value;
            }
        }
    }

    public Map<String, String> makeDataModel() {
        HashMap<String, String> dataModel = new HashMap<String, String>();
        dataModel.put("model", this.model.trim());
        dataModel.put("url", this.url.trim());
        return dataModel;
    }

    private static enum Component {
        MODEL,
        URL;

    }
}

