/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PaletteToggleSwitchDialog
extends PaletteDefaultDialog {
    private String label;
    private String offLabel;
    private String onLabel;
    private String id;
    private boolean mini;
    private boolean disabled;
    private boolean hideLabel;
    private String layout;
    private String theme;
    private String trackTheme;

    public PaletteToggleSwitchDialog() {
        super(null);
    }

    public PaletteToggleSwitchDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("toggleSwitch.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case MINI: {
                this.mini = value;
                break;
            }
            case DISABLED: {
                this.disabled = value;
                break;
            }
            case HIDELABEL: {
                this.hideLabel = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case LABEL: {
                this.label = value;
                break;
            }
            case OFFLABEL: {
                this.offLabel = value;
                break;
            }
            case ONLABEL: {
                this.onLabel = value;
                break;
            }
            case ID: {
                this.id = value;
                break;
            }
            case LAYOUT: {
                this.layout = value.toLowerCase();
                break;
            }
            case THEME: {
                this.theme = value;
                break;
            }
            case TRACKTHEME: {
                this.trackTheme = value;
            }
        }
    }

    public Map<String, String> makeDataModel() {
        HashMap<String, String> dataModel = new HashMap<String, String>();
        dataModel.put("label", this.label.trim());
        dataModel.put("offLabel", this.offLabel.trim());
        dataModel.put("onLabel", this.onLabel.trim());
        dataModel.put("id", this.id.trim());
        dataModel.put("mini", String.valueOf(this.mini).trim());
        dataModel.put("disabled", String.valueOf(this.disabled).trim());
        dataModel.put("hideLabel", String.valueOf(this.hideLabel).trim());
        dataModel.put("layout", this.layout.trim());
        dataModel.put("theme", this.theme.trim());
        dataModel.put("trackTheme", this.trackTheme.trim());
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Flip Toggle Switch");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile toggle widget.", 1);
    }

    public void initValue() {
        this.label = "Switch: ";
        this.offLabel = "Off";
        this.onLabel = "On";
        this.id = "flip-1";
        this.mini = false;
        this.disabled = false;
        this.hideLabel = false;
        this.layout = "horizontal";
        this.theme = "";
        this.trackTheme = "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.addLabelText(container, "Label: ", "", Component.LABEL.ordinal());
        this.addLabelText(container, "Off Label: ", "", Component.OFFLABEL.ordinal());
        this.addLabelText(container, "On Label: ", "", Component.ONLABEL.ordinal());
        this.addLabelText(container, "ID: ", "Generate", Component.ID.ordinal());
        Composite composite = this.createComposite(container, 6);
        this.addLabelCheckButton(composite, " Mini: ", false, Component.MINI.ordinal());
        this.addLabelCheckButton(composite, "Disabled: ", false, Component.DISABLED.ordinal());
        this.addLabelCheckButton(composite, "Hide Label: ", false, Component.HIDELABEL.ordinal());
        Composite layoutComposite = this.createComposite(container, 3);
        Label displayLabel = new Label(layoutComposite, 0);
        displayLabel.setText("Layout:  ");
        this.addRadio(layoutComposite, "Horizontal", true, Component.LAYOUT.ordinal());
        this.addRadio(layoutComposite, "Vertical", false, Component.LAYOUT.ordinal());
        this.addCombo(container, "Theme", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        this.addCombo(container, "Track Theme", JQueryMobileConstants.THEME_ELEMENTS, Component.TRACKTHEME.ordinal());
        this.createBrowser(container, 200);
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        LABEL,
        OFFLABEL,
        ONLABEL,
        ID,
        MINI,
        DISABLED,
        HIDELABEL,
        LAYOUT,
        THEME,
        TRACKTHEME;

    }
}

