/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PaletteTextInputDialog
extends PaletteDefaultDialog {
    private String type;
    private String label;
    private String id;
    private String value;
    private String pattern;
    private String placeholder;
    private String maxLength;
    private String min;
    private String max;
    private String step;
    private boolean clearButton;
    private boolean mini;
    private boolean required;
    private boolean hideLabel;
    private boolean disabled;
    private boolean autofucus;
    private String layout;
    private String theme;

    public PaletteTextInputDialog() {
        super(null);
    }

    public PaletteTextInputDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("textInput.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case CLEARBUTTON: {
                this.clearButton = value;
                break;
            }
            case MINI: {
                this.mini = value;
                break;
            }
            case REQUIRED: {
                this.required = value;
                break;
            }
            case HIDELABEL: {
                this.hideLabel = value;
                break;
            }
            case DISABLED: {
                this.disabled = value;
                break;
            }
            case AUTOFUCUS: {
                this.autofucus = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case TYPE: {
                this.type = value;
                break;
            }
            case LABEL: {
                this.label = value;
                break;
            }
            case ID: {
                this.id = value;
                break;
            }
            case VALUE: {
                this.value = value;
                break;
            }
            case PATTERN: {
                this.pattern = value;
                break;
            }
            case PLACEHOLDER: {
                this.placeholder = value;
                break;
            }
            case MAXLENGTH: {
                this.maxLength = value;
                break;
            }
            case MIN: {
                this.min = value;
                break;
            }
            case MAX: {
                this.max = value;
                break;
            }
            case STEP: {
                this.step = value;
                break;
            }
            case LAYOUT: {
                this.layout = value.toLowerCase();
                break;
            }
            case THEME: {
                this.theme = value;
            }
        }
    }

    public Map<String, String> makeDataModel() {
        HashMap<String, String> dataModel = new HashMap<String, String>();
        dataModel.put("type", this.type.trim());
        dataModel.put("label", this.label.trim());
        dataModel.put("id", this.id.trim());
        dataModel.put("value", this.value.trim());
        dataModel.put("pattern", this.pattern.trim());
        dataModel.put("placeholder", this.placeholder.trim());
        dataModel.put("maxLength", this.maxLength.trim());
        dataModel.put("min", this.min.trim());
        dataModel.put("max", this.max.trim());
        dataModel.put("step", this.step.trim());
        dataModel.put("clearButton", String.valueOf(this.clearButton).trim());
        dataModel.put("mini", String.valueOf(this.mini).trim());
        dataModel.put("required", String.valueOf(this.required).trim());
        dataModel.put("hideLabel", String.valueOf(this.hideLabel).trim());
        dataModel.put("disabled", String.valueOf(this.disabled).trim());
        dataModel.put("autofocus", String.valueOf(this.autofucus).trim());
        dataModel.put("layout", this.layout);
        dataModel.put("theme", this.theme.trim());
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Text Input");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile text input widget.", 1);
    }

    public void initValue() {
        this.type = "text";
        this.label = "Input";
        this.id = "text-1";
        this.value = "";
        this.pattern = "";
        this.placeholder = "";
        this.maxLength = "";
        this.min = "";
        this.max = "";
        this.step = "";
        this.clearButton = true;
        this.mini = false;
        this.required = false;
        this.hideLabel = false;
        this.disabled = false;
        this.autofucus = false;
        this.layout = "horizontal";
        this.theme = "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        String[] type_eles = new String[]{"text", "textarea", "search", "password", "number", "file", "url", "email", "tel", "date", "time", "datetime", "month", "week", "color"};
        this.addCombo(container, "Type: ", type_eles, Component.TYPE.ordinal());
        this.addLabelText(container, "Label:  ", "Input:", Component.LABEL.ordinal());
        this.addLabelText(container, "ID: ", "Generate", Component.ID.ordinal());
        this.addLabelText(container, "Value: ", "", Component.VALUE.ordinal());
        this.addLabelText(container, "Pattern: ", "", Component.PATTERN.ordinal());
        this.addLabelText(container, "Placeholder: ", "", Component.PLACEHOLDER.ordinal());
        this.addLabelText(container, "Max Length: ", "", Component.MAXLENGTH.ordinal());
        Composite numGroup = this.createGroup(container, "Number", 6);
        this.addLabelText(numGroup, "Min: ", "", Component.MIN.ordinal());
        this.addLabelText(numGroup, "Max: ", "", Component.MAX.ordinal());
        this.addLabelText(numGroup, "Step", "", Component.STEP.ordinal());
        Composite composite = this.createComposite(container, 6);
        this.addLabelCheckButton(composite, " Clear Button: ", false, Component.CLEARBUTTON.ordinal());
        this.addLabelCheckButton(composite, " Mini: ", false, Component.MINI.ordinal());
        this.addLabelCheckButton(composite, " Required: ", false, Component.REQUIRED.ordinal());
        this.addLabelCheckButton(composite, " Hide Label: ", false, Component.HIDELABEL.ordinal());
        this.addLabelCheckButton(composite, " Disabled: ", false, Component.DISABLED.ordinal());
        this.addLabelCheckButton(composite, " Autofocus: ", false, Component.AUTOFUCUS.ordinal());
        Composite layoutGroup = this.createGroup(container, "Layout", 2);
        this.addRadio(layoutGroup, "Horizontal", true, Component.LAYOUT.ordinal());
        this.addRadio(layoutGroup, "Verical", false, Component.LAYOUT.ordinal());
        this.addCombo(container, "Theme", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        this.createBrowser(container, 200);
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        TYPE,
        LABEL,
        ID,
        VALUE,
        PATTERN,
        PLACEHOLDER,
        MAXLENGTH,
        MIN,
        MAX,
        STEP,
        CLEARBUTTON,
        MINI,
        REQUIRED,
        HIDELABEL,
        DISABLED,
        AUTOFUCUS,
        LAYOUT,
        THEME;

    }
}

