/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PaletteTableDialog
extends PaletteDefaultDialog {
    private String mode;
    private String id;
    private boolean reponsive;
    private boolean stripes;
    private String theme;
    private String tableCount;
    private List<String[]> columns = new ArrayList<String[]>();

    public PaletteTableDialog() {
        super(null);
        this.setInitList();
    }

    public PaletteTableDialog(Shell parentShell) {
        super(parentShell);
        this.setInitList();
    }

    private void setInitList() {
        this.columns.add(new String[]{"A", "", "a"});
        this.columns.add(new String[]{"B", "1", "b"});
        this.columns.add(new String[]{"C", "2", "c"});
        this.columns.add(new String[]{"D", "3", "d"});
        this.columns.add(new String[]{"E", "4", "e"});
        this.columns.add(new String[]{"F", "5", "f"});
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("table.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case REPONSIVE: {
                this.reponsive = value;
                break;
            }
            case STRIPES: {
                this.stripes = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case MODE: {
                this.mode = value.replace(" ", "").toLowerCase();
                break;
            }
            case ID: {
                this.id = value;
                break;
            }
            case THEME: {
                this.theme = value;
                break;
            }
            case TABLECOUNT: {
                this.tableCount = value;
            }
        }
    }

    public Map<String, Object> makeDataModel() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("mode", this.mode.trim());
        dataModel.put("id", this.id.trim());
        dataModel.put("reponsive", String.valueOf(this.reponsive));
        dataModel.put("stripes", String.valueOf(this.stripes));
        dataModel.put("theme", this.theme.trim());
        ArrayList items = new ArrayList();
        int i = 0;
        while (i < Integer.parseInt(this.tableCount)) {
            HashMap<String, String> columnMap = new HashMap<String, String>();
            String[] column = this.columns.get(i);
            columnMap.put("header", column[0]);
            columnMap.put("priority", column[1]);
            columnMap.put("rowContent", column[2]);
            items.add(columnMap);
            ++i;
        }
        dataModel.put("columns", items);
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Table");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile table widget.", 1);
    }

    public void initValue() {
        this.mode = "columntoggle";
        this.id = "panel-1";
        this.reponsive = true;
        this.stripes = false;
        this.theme = "b";
        this.tableCount = "3";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(4, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Composite composite = this.createComposite(container);
        this.addLabelText(composite, "ID: ", "Generate", Component.ID.ordinal());
        this.addCombo(composite, "Theme", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        Composite modeComposite = this.createComposite(composite);
        Label modelb = new Label(modeComposite, 0);
        modelb.setText("Mode:    ");
        this.addRadio(modeComposite, "Column Toggle", true, Component.MODE.ordinal());
        Label padding = new Label(modeComposite, 0);
        padding.setText("");
        this.addRadio(modeComposite, "Reflow", false, Component.MODE.ordinal());
        this.addLabelCheckButton(composite, "Responsive: ", true, Component.REPONSIVE.ordinal());
        this.addLabelCheckButton(composite, "Stripes: ", false, Component.STRIPES.ordinal());
        Composite group = this.createGroup(container, "Columns", 2);
        this.addTabGroup(group, Component.TABLECOUNT.ordinal());
        this.createBrowser(container, 200, 4);
        return area;
    }

    private void addTabGroup(Composite container, final int eleId) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("Number :  ");
        final Combo tableCountCombo = new Combo(container, 2052);
        String[] tableCountEle = new String[]{"1", "2", "3", "4", "5", "6"};
        tableCountCombo.setText("3");
        int i = 0;
        while (i < tableCountEle.length) {
            tableCountCombo.add(tableCountEle[i]);
            ++i;
        }
        final TabFolder tabFolder = new TabFolder(container, 0);
        tableCountCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                int count = Integer.parseInt(text);
                TabItem[] tabItemArray = tabFolder.getItems();
                int n = tabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem item = tabItemArray[n2];
                    try {
                        item.dispose();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        tabFolder.getItem(0).dispose();
                    }
                    ++n2;
                }
                PaletteTableDialog.this.createTab(tabFolder, count);
                PaletteTableDialog.this.setStringType(eleId, tableCountCombo.getText());
                PaletteTableDialog.this.makePreview(PaletteTableDialog.this.browser);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                if (tableCountCombo.indexOf(text) < 0) {
                    tableCountCombo.add(text);
                    Object[] items = tableCountCombo.getItems();
                    Arrays.sort(items);
                    tableCountCombo.setItems((String[])items);
                }
                PaletteTableDialog.this.makePreview(PaletteTableDialog.this.browser);
            }
        });
        GridData tabFolderGridData = new GridData(4, 4, true, false);
        tabFolderGridData.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)tabFolderGridData);
        this.createTab(tabFolder, 3);
    }

    private void createTab(TabFolder tabFolder, int count) {
        TabItem tabItem = null;
        int loopIndex = 1;
        while (loopIndex < count + 1) {
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Tab " + loopIndex);
            tabItem.setControl(this.getTabControl(tabFolder, loopIndex));
            ++loopIndex;
        }
    }

    private Control getTabControl(TabFolder tabFolder, int loopIndex) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 1;
        composite.setLayout((Layout)new GridLayout(2, false));
        String[] column = this.columns.get(loopIndex - 1);
        new Label(composite, 16384).setText("Head:");
        Text text = new Text(composite, 2048);
        text.setText(column[0]);
        text.setEnabled(false);
        text.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("Priority:");
        Text priority = new Text(composite, 2048);
        priority.setText(column[1]);
        priority.setEnabled(false);
        priority.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("1st Row Content:");
        Text rowtext = new Text(composite, 2048);
        rowtext.setText(column[2]);
        rowtext.setEnabled(false);
        rowtext.setLayoutData((Object)gridData);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        MODE,
        ID,
        REPONSIVE,
        STRIPES,
        THEME,
        TABLECOUNT;

    }
}

