/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PaletteSelectMenuDialog
extends PaletteDefaultDialog {
    private String label;
    private String id;
    private String layout;
    private boolean mini;
    private boolean roundedCorners;
    private boolean hideLabel;
    private boolean inline;
    private String iconPosition;
    private String theme;
    private String itemsCount;
    private List<String[]> columns = new ArrayList<String[]>();

    public PaletteSelectMenuDialog() {
        super(null);
        this.setInitList();
    }

    public PaletteSelectMenuDialog(Shell parentShell) {
        super(parentShell);
        this.setInitList();
    }

    private void setInitList() {
        this.columns.add(new String[]{"A", "A", "false", "true"});
        this.columns.add(new String[]{"B", "B", "false", "true"});
        this.columns.add(new String[]{"C", "C", "false", "true"});
        this.columns.add(new String[]{"D", "D", "false", "true"});
        this.columns.add(new String[]{"E", "E", "false", "true"});
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("selectMenu.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case MINI: {
                this.mini = value;
                break;
            }
            case ROUNDEDCORNERS: {
                this.roundedCorners = value;
                break;
            }
            case HIDELABEL: {
                this.hideLabel = value;
                break;
            }
            case INLINE: {
                this.inline = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case LABEL: {
                this.label = value;
                break;
            }
            case ID: {
                this.id = value;
                break;
            }
            case LAYOUT: {
                this.layout = value;
                break;
            }
            case ICONPOSITION: {
                this.iconPosition = value;
                break;
            }
            case THEME: {
                this.theme = value;
                break;
            }
            case ITEMSCOUNT: {
                this.itemsCount = value;
            }
        }
    }

    public Map<String, Object> makeDataModel() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("label", this.label.trim());
        dataModel.put("id", this.id.trim());
        dataModel.put("layout", this.layout.trim());
        dataModel.put("mini", String.valueOf(this.mini).trim());
        dataModel.put("roundedCorners", String.valueOf(this.roundedCorners).trim());
        dataModel.put("hideLabel", String.valueOf(this.hideLabel).trim());
        dataModel.put("inline", String.valueOf(this.inline).trim());
        dataModel.put("iconPosition", this.iconPosition.trim());
        dataModel.put("theme", this.theme.trim());
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < Integer.parseInt(this.itemsCount)) {
            HashMap<String, String> buttonMap = new HashMap<String, String>();
            String[] column = this.columns.get(i);
            buttonMap.put("label", column[0]);
            buttonMap.put("value", column[1]);
            buttonMap.put("selected", column[2]);
            buttonMap.put("disabled", column[3]);
            list.add(buttonMap);
            ++i;
        }
        dataModel.put("items", list);
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Select Menu");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile select menu widget.", 1);
    }

    public void initValue() {
        this.label = "Select";
        this.id = "select-1";
        this.layout = "horizontal";
        this.mini = false;
        this.roundedCorners = true;
        this.hideLabel = false;
        this.inline = false;
        this.iconPosition = "";
        this.theme = "";
        this.itemsCount = "3";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(4, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Composite composite = this.createComposite(container);
        this.addLabelText(composite, "Label: ", "Select", Component.LABEL.ordinal());
        this.addLabelText(composite, "ID: ", "Generate", Component.ID.ordinal());
        Label modelb = new Label(composite, 0);
        modelb.setText("Layout:    ");
        this.addRadio(composite, "Horizontal", true, Component.LAYOUT.ordinal());
        Label padding1 = new Label(composite, 0);
        padding1.setText("");
        this.addRadio(composite, "Vertical", false, Component.LAYOUT.ordinal());
        Composite group = this.createGroup(composite, "");
        this.addLabelCheckButton(group, "Mini: ", false, Component.MINI.ordinal());
        this.addLabelCheckButton(group, "Rounded corners: ", true, Component.MINI.ordinal());
        this.addLabelCheckButton(group, "Hide Label: ", false, Component.MINI.ordinal());
        this.addLabelCheckButton(group, "Inline: ", false, Component.MINI.ordinal());
        this.addCombo(composite, "Theme", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        this.addCombo(composite, "Icon position", JQueryMobileConstants.ICON_POSITION_ELEMENTS, Component.ICONPOSITION.ordinal());
        Composite groupItem = this.createGroup(container, "Items", 2);
        this.addTabGroup(groupItem, Component.ITEMSCOUNT.ordinal());
        this.createBrowser(container, 200, 4);
        return area;
    }

    private void addTabGroup(Composite container, final int eleId) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("Number :  ");
        final Combo tableCountCombo = new Combo(container, 2052);
        String[] tableCountEle = new String[]{"1", "2", "3", "4", "5"};
        tableCountCombo.setText("3");
        int i = 0;
        while (i < tableCountEle.length) {
            tableCountCombo.add(tableCountEle[i]);
            ++i;
        }
        final TabFolder tabFolder = new TabFolder(container, 0);
        tableCountCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                int count = Integer.parseInt(text);
                TabItem[] tabItemArray = tabFolder.getItems();
                int n = tabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem item = tabItemArray[n2];
                    try {
                        item.dispose();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        tabFolder.getItem(0).dispose();
                    }
                    ++n2;
                }
                PaletteSelectMenuDialog.this.createTab(tabFolder, count);
                PaletteSelectMenuDialog.this.setStringType(eleId, tableCountCombo.getText());
                PaletteSelectMenuDialog.this.makePreview(PaletteSelectMenuDialog.this.browser);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                if (tableCountCombo.indexOf(text) < 0) {
                    tableCountCombo.add(text);
                    Object[] items = tableCountCombo.getItems();
                    Arrays.sort(items);
                    tableCountCombo.setItems((String[])items);
                }
                PaletteSelectMenuDialog.this.makePreview(PaletteSelectMenuDialog.this.browser);
            }
        });
        GridData tabFolderGridData = new GridData(4, 4, true, false);
        tabFolderGridData.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)tabFolderGridData);
        this.createTab(tabFolder, 3);
    }

    private void createTab(TabFolder tabFolder, int count) {
        TabItem tabItem = null;
        int loopIndex = 1;
        while (loopIndex < count + 1) {
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Tab " + loopIndex);
            tabItem.setControl(this.getTabControl(tabFolder, loopIndex));
            ++loopIndex;
        }
    }

    private Control getTabControl(TabFolder tabFolder, int loopIndex) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayout((Layout)new GridLayout(2, false));
        String[] column = this.columns.get(loopIndex - 1);
        new Label(composite, 16384).setText("Label:");
        Text text = new Text(composite, 2048);
        text.setText(column[0]);
        text.setEnabled(false);
        text.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("Value:");
        Text text1 = new Text(composite, 2048);
        text1.setText(column[1]);
        text1.setEnabled(false);
        text1.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("Selected:");
        Button btn1 = new Button(composite, 32);
        btn1.setEnabled(false);
        new Label(composite, 131072).setText("Disable:");
        Button btn2 = new Button(composite, 32);
        btn2.setSelection(true);
        btn2.setEnabled(false);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        LABEL,
        ID,
        LAYOUT,
        MINI,
        ROUNDEDCORNERS,
        HIDELABEL,
        INLINE,
        ICONPOSITION,
        THEME,
        ITEMSCOUNT;

    }
}

