/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PalettePopupDialog
extends PaletteDefaultDialog {
    private String id;
    private String closeButton;
    private boolean dismissable;
    private boolean shadow;
    private boolean padding;
    private boolean roundedCorners;
    private String theme;
    private String overlayTheme;
    private boolean openPopupButton;
    private String label;
    private boolean infoStyled;
    private String transition;
    private String positionTo;

    public PalettePopupDialog() {
        super(null);
    }

    public PalettePopupDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("popup.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case DISMISSABLE: {
                this.dismissable = value;
                break;
            }
            case SHADOW: {
                this.shadow = value;
                break;
            }
            case PADDING: {
                this.padding = value;
                break;
            }
            case ROUNDED_CORNERS: {
                this.roundedCorners = value;
                break;
            }
            case OPEN_POPUP_BUTTON: {
                this.openPopupButton = value;
                break;
            }
            case INFO_STYLED: {
                this.infoStyled = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case ID: {
                this.id = value;
                break;
            }
            case CLOSE_BUTTON: {
                this.closeButton = value;
                break;
            }
            case THEME: {
                this.theme = value;
                break;
            }
            case OVERLAY_THEME: {
                this.overlayTheme = value;
                break;
            }
            case LABEL: {
                this.label = value;
                break;
            }
            case TRANSITION: {
                this.transition = value;
                break;
            }
            case POSITION_TO: {
                this.positionTo = value;
            }
        }
    }

    public Map<String, String> makeDataModel() {
        HashMap<String, String> dataModel = new HashMap<String, String>();
        dataModel.put("id", this.id.trim());
        dataModel.put("closeButton", String.valueOf(this.closeButton));
        dataModel.put("dismissable", String.valueOf(this.dismissable));
        dataModel.put("shadow", String.valueOf(this.shadow));
        dataModel.put("padding", String.valueOf(this.padding));
        dataModel.put("roundedCorners", String.valueOf(this.roundedCorners));
        dataModel.put("theme", this.theme.trim());
        dataModel.put("overlayTheme", String.valueOf(this.overlayTheme));
        dataModel.put("openPopupButton", String.valueOf(this.openPopupButton));
        dataModel.put("label", this.label.trim());
        dataModel.put("infoStyled", String.valueOf(this.infoStyled));
        dataModel.put("transition", this.transition.trim());
        dataModel.put("positionTo", this.positionTo.trim());
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Popup");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile popup widget.", 1);
    }

    public void initValue() {
        this.id = "popup-1";
        this.closeButton = "";
        this.dismissable = true;
        this.shadow = true;
        this.padding = true;
        this.roundedCorners = true;
        this.theme = "";
        this.overlayTheme = "";
        this.openPopupButton = true;
        this.label = "Popup";
        this.infoStyled = false;
        this.transition = "";
        this.positionTo = "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Composite group = this.createGroup(container, "Popup Window");
        this.addLabelText(group, "ID:", "Generate", Component.ID.ordinal());
        this.addCombo(group, "Close Button", new String[]{"none", "left", "right"}, Component.CLOSE_BUTTON.ordinal());
        this.addLabelCheckButton(group, "Dismissable:", true, Component.DISMISSABLE.ordinal());
        this.addLabelCheckButton(group, "Shadow:", true, Component.SHADOW.ordinal());
        this.addLabelCheckButton(group, "Padding:", true, Component.PADDING.ordinal());
        this.addLabelCheckButton(group, "Rounded corners:", true, Component.ROUNDED_CORNERS.ordinal());
        this.addCombo(group, "Theme:", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        this.addCombo(group, "Overlay Theme:", JQueryMobileConstants.THEME_ELEMENTS, Component.OVERLAY_THEME.ordinal());
        this.addCheckButton(container, "Open Popup Button", true, Component.OPEN_POPUP_BUTTON.ordinal());
        Composite composite = this.createComposite(container);
        this.addLabelText(composite, "Label", "Popup", Component.LABEL.ordinal());
        this.addLabelCheckButton(composite, "Info-styled", false, Component.INFO_STYLED.ordinal());
        String[] transition_eles = new String[]{"", "fade", "pop", "flip", "turn", "flow", "slidefade", "slidedown", "slide", "slideup", "none"};
        this.addCombo(composite, "Transition:", transition_eles, Component.TRANSITION.ordinal());
        this.addCombo(composite, "Position To:", new String[]{"", "window", "origin"}, Component.POSITION_TO.ordinal());
        this.createBrowser(container, 200);
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        ID,
        CLOSE_BUTTON,
        DISMISSABLE,
        SHADOW,
        PADDING,
        ROUNDED_CORNERS,
        THEME,
        OVERLAY_THEME,
        OPEN_POPUP_BUTTON,
        LABEL,
        INFO_STYLED,
        TRANSITION,
        POSITION_TO;

    }
}

