/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PalettePanelDialog
extends PaletteDefaultDialog {
    private String id;
    private String display;
    private String position;
    private boolean fixedPosition;
    private boolean dismissable;
    private boolean swipeToClose;
    private String theme;

    public PalettePanelDialog() {
        super(null);
    }

    public PalettePanelDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("panel.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case FIXED_POSITION: {
                this.fixedPosition = value;
                break;
            }
            case DISMISSABLE: {
                this.dismissable = value;
                break;
            }
            case SWIPE_TO_CLOSE: {
                this.swipeToClose = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case ID: {
                this.id = value;
                break;
            }
            case DISPLAY: {
                this.display = value;
                break;
            }
            case POSITION: {
                this.position = value;
                break;
            }
            case THEME: {
                this.theme = value;
            }
        }
    }

    public Map<String, String> makeDataModel() {
        HashMap<String, String> dataModel = new HashMap<String, String>();
        dataModel.put("id", this.id.trim());
        dataModel.put("display", this.display.trim());
        dataModel.put("position", this.position.trim());
        dataModel.put("fixedPosition", String.valueOf(this.fixedPosition));
        dataModel.put("dismissable", String.valueOf(this.dismissable));
        dataModel.put("swipeToClose", String.valueOf(this.swipeToClose));
        dataModel.put("theme", this.theme.trim());
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Panel");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile panel widget.", 1);
    }

    public void initValue() {
        this.id = "panel-1";
        this.display = "reveal";
        this.position = "left";
        this.fixedPosition = false;
        this.dismissable = true;
        this.swipeToClose = true;
        this.theme = "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.addLabelText(container, "ID: ", "Generate", Component.ID.ordinal());
        this.addCombo(container, "Theme", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        Composite composite = this.createComposite(container, 6);
        this.addLabelCheckButton(composite, " Fixed Position:", false, Component.FIXED_POSITION.ordinal());
        this.addLabelCheckButton(composite, "Dismissable:", true, Component.DISMISSABLE.ordinal());
        this.addLabelCheckButton(composite, " Swipe to Close:", true, Component.SWIPE_TO_CLOSE.ordinal());
        Composite displayComposite = this.createGroup(container, "");
        Label displayLabel = new Label(displayComposite, 0);
        displayLabel.setText("Display:  ");
        this.addRadio(displayComposite, "overlay", false, Component.DISPLAY.ordinal());
        this.addRadio(displayComposite, "reveal", true, Component.DISPLAY.ordinal());
        this.addRadio(displayComposite, "push", false, Component.DISPLAY.ordinal());
        Composite positionComposite = this.createGroup(container, "");
        Label positionLabel = new Label(positionComposite, 0);
        positionLabel.setText("Position:  ");
        this.addRadio(positionComposite, "left", true, Component.POSITION.ordinal());
        this.addRadio(positionComposite, "right", false, Component.POSITION.ordinal());
        this.createBrowser(container, 200);
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        ID,
        DISPLAY,
        POSITION,
        FIXED_POSITION,
        DISMISSABLE,
        SWIPE_TO_CLOSE,
        THEME;

    }
}

