/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PaletteNaviBarDialog
extends PaletteDefaultDialog {
    private boolean checkID;
    private String id;
    private String theme;
    private String iconPosition = "";
    private boolean iconPositionFlag = true;
    private String buttonsCount;
    private List<String[]> columns = new ArrayList<String[]>();

    public PaletteNaviBarDialog() {
        super(null);
        this.setInitList();
    }

    public PaletteNaviBarDialog(Shell parentShell) {
        super(parentShell);
        this.setInitList();
    }

    private void setInitList() {
        this.columns.add(new String[]{"A", "#", "bars"});
        this.columns.add(new String[]{"B", "#", "alert"});
        this.columns.add(new String[]{"C", "#", "gear"});
        this.columns.add(new String[]{"D", "#", "arrow-d"});
        this.columns.add(new String[]{"E", "#", "arrow-r"});
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("navbar.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case ID: {
                this.checkID = value;
                break;
            }
            case ICONPOSITIONFLAG: {
                this.iconPositionFlag = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case ID: {
                this.id = value;
                break;
            }
            case THEME: {
                this.theme = value;
                break;
            }
            case BUTTONSCOUNT: {
                this.buttonsCount = value;
                break;
            }
            case ICONPOSITION: {
                this.iconPosition = value;
            }
        }
    }

    public Map<String, Object> makeDataModel() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("checkId", String.valueOf(this.checkID).trim());
        dataModel.put("id", this.id.trim());
        dataModel.put("theme", this.theme.trim());
        dataModel.put("iconPosition", this.iconPosition.trim());
        dataModel.put("iconPositionFlag", String.valueOf(this.iconPositionFlag).trim());
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < Integer.parseInt(this.buttonsCount)) {
            HashMap<String, String> buttonMap = new HashMap<String, String>();
            String[] column = this.columns.get(i);
            buttonMap.put("label", column[0]);
            buttonMap.put("url", column[1]);
            buttonMap.put("icon", column[2]);
            list.add(buttonMap);
            ++i;
        }
        dataModel.put("items", list);
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New NavBar");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile footer navbar widget.", 1);
    }

    public void initValue() {
        this.checkID = true;
        this.id = "";
        this.theme = "";
        this.buttonsCount = "3";
        this.iconPosition = "left";
        this.iconPositionFlag = true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(4, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Composite composite = this.createComposite(container);
        this.addCheckButtonText(composite, "ID: ", "", true, Component.ID.ordinal());
        this.addCombo(composite, "Theme", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        this.addCombo(composite, "Icon Position", JQueryMobileConstants.ICON_POSITION_ELEMENTS, Component.ICONPOSITION.ordinal());
        this.addLabelCheckButton(composite, "Icon Position Flag: ", true, Component.ICONPOSITIONFLAG.ordinal());
        Composite group = this.createGroup(container, "Buttons", 2);
        this.addTabGroup(group, Component.BUTTONSCOUNT.ordinal());
        this.createBrowser(container, 200, 4);
        return area;
    }

    private void addTabGroup(Composite container, final int eleId) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("Number :  ");
        final Combo tableCountCombo = new Combo(container, 2052);
        String[] tableCountEle = new String[]{"1", "2", "3", "4", "5"};
        tableCountCombo.setText("3");
        int i = 0;
        while (i < tableCountEle.length) {
            tableCountCombo.add(tableCountEle[i]);
            ++i;
        }
        final TabFolder tabFolder = new TabFolder(container, 0);
        tableCountCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                int count = Integer.parseInt(text);
                TabItem[] tabItemArray = tabFolder.getItems();
                int n = tabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem item = tabItemArray[n2];
                    try {
                        item.dispose();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        tabFolder.getItem(0).dispose();
                    }
                    ++n2;
                }
                PaletteNaviBarDialog.this.createTab(tabFolder, count);
                PaletteNaviBarDialog.this.setStringType(eleId, tableCountCombo.getText());
                PaletteNaviBarDialog.this.makePreview(PaletteNaviBarDialog.this.browser);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                if (tableCountCombo.indexOf(text) < 0) {
                    tableCountCombo.add(text);
                    Object[] items = tableCountCombo.getItems();
                    Arrays.sort(items);
                    tableCountCombo.setItems((String[])items);
                }
                PaletteNaviBarDialog.this.makePreview(PaletteNaviBarDialog.this.browser);
            }
        });
        GridData tabFolderGridData = new GridData(4, 4, true, false);
        tabFolderGridData.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)tabFolderGridData);
        this.createTab(tabFolder, 3);
    }

    private void createTab(TabFolder tabFolder, int count) {
        TabItem tabItem = null;
        int loopIndex = 1;
        while (loopIndex < count + 1) {
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Tab " + loopIndex);
            tabItem.setControl(this.getTabControl(tabFolder, loopIndex));
            ++loopIndex;
        }
    }

    private Control getTabControl(TabFolder tabFolder, int loopIndex) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayout((Layout)new GridLayout(2, false));
        String[] column = this.columns.get(loopIndex - 1);
        new Label(composite, 16384).setText("Label:");
        Text text = new Text(composite, 2048);
        text.setText(column[0]);
        text.setEnabled(false);
        text.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("URL(href):");
        Text text1 = new Text(composite, 2048);
        text1.setText(column[1]);
        text1.setEnabled(false);
        text1.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("Icon:");
        Text iconcombo = new Text(composite, 2048);
        iconcombo.setText(column[2]);
        iconcombo.setEnabled(false);
        iconcombo.setLayoutData((Object)gridData);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        ID,
        THEME,
        BUTTONSCOUNT,
        ICONPOSITION,
        ICONPOSITIONFLAG;

    }
}

