/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PaletteListViewDialog
extends PaletteDefaultDialog {
    private boolean numbered;
    private boolean readOnly;
    private boolean autodividers;
    private boolean searchFilter;
    private boolean inset;
    private String id;
    private String theme;
    private String dividerTheme;
    private String itemsCount;
    private List<String[]> columns = new ArrayList<String[]>();

    public PaletteListViewDialog() {
        super(null);
        this.setInitList();
    }

    public PaletteListViewDialog(Shell parentShell) {
        super(parentShell);
        this.setInitList();
    }

    private void setInitList() {
        this.columns.add(new String[]{"Item 1", "false", "item1.html"});
        this.columns.add(new String[]{"Item 2", "false", "item2.html"});
        this.columns.add(new String[]{"Item 3", "false", "item3.html"});
        this.columns.add(new String[]{"Item 4", "false", "item4.html"});
        this.columns.add(new String[]{"Item 5", "false", "item5.html"});
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("listview.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case NUMBERED: {
                this.numbered = value;
                break;
            }
            case READONLY: {
                this.readOnly = value;
                break;
            }
            case AUTODIVIDERS: {
                this.autodividers = value;
                break;
            }
            case SEARCHFILTER: {
                this.searchFilter = value;
                break;
            }
            case INSET: {
                this.inset = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case ID: {
                this.id = value;
                break;
            }
            case THEME: {
                this.theme = value;
                break;
            }
            case DIVIDERTHEME: {
                this.dividerTheme = value;
                break;
            }
            case ITEMSCOUNT: {
                this.itemsCount = value;
            }
        }
    }

    public Map<String, Object> makeDataModel() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("numbered", String.valueOf(this.numbered).trim());
        dataModel.put("readOnly", String.valueOf(this.readOnly).trim());
        dataModel.put("autodividers", String.valueOf(this.autodividers).trim());
        dataModel.put("searchFilter", String.valueOf(this.searchFilter).trim());
        dataModel.put("inset", String.valueOf(this.inset).trim());
        dataModel.put("id", this.id.trim());
        dataModel.put("theme", this.theme.trim());
        dataModel.put("dividerTheme", this.dividerTheme.trim());
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < Integer.parseInt(this.itemsCount)) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            String[] column = this.columns.get(i);
            itemMap.put("label", column[0]);
            itemMap.put("divider", column[1]);
            itemMap.put("url", column[2]);
            list.add(itemMap);
            ++i;
        }
        dataModel.put("items", list);
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Listview");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile listview widget.", 1);
    }

    public void initValue() {
        this.numbered = false;
        this.readOnly = false;
        this.autodividers = false;
        this.searchFilter = false;
        this.inset = false;
        this.id = "listview-1";
        this.theme = "";
        this.dividerTheme = "";
        this.itemsCount = "3";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(4, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Composite composite = this.createComposite(container);
        this.addLabelText(composite, "ID: ", "Generate", Component.ID.ordinal());
        Composite group = this.createGroup(composite, "");
        this.addLabelCheckButton(group, "Numbered: ", false, Component.NUMBERED.ordinal());
        this.addLabelCheckButton(group, "Read-only: ", false, Component.READONLY.ordinal());
        this.addLabelCheckButton(group, "Autodividers: ", false, Component.AUTODIVIDERS.ordinal());
        this.addLabelCheckButton(group, "Search filter: ", false, Component.SEARCHFILTER.ordinal());
        this.addLabelCheckButton(group, "Inset: ", false, Component.INSET.ordinal());
        this.addCombo(composite, "Theme: ", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        this.addCombo(composite, "Divider Theme: ", JQueryMobileConstants.THEME_ELEMENTS, Component.DIVIDERTHEME.ordinal());
        Composite groupItem = this.createGroup(container, "Items", 2);
        this.addTabGroup(groupItem, Component.ITEMSCOUNT.ordinal());
        this.createBrowser(container, 200, 4);
        return area;
    }

    private void addTabGroup(Composite container, final int eleId) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("Number :  ");
        final Combo tableCountCombo = new Combo(container, 2052);
        String[] tableCountEle = new String[]{"1", "2", "3", "4", "5"};
        tableCountCombo.setText("3");
        int i = 0;
        while (i < tableCountEle.length) {
            tableCountCombo.add(tableCountEle[i]);
            ++i;
        }
        final TabFolder tabFolder = new TabFolder(container, 0);
        tableCountCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                int count = Integer.parseInt(text);
                TabItem[] tabItemArray = tabFolder.getItems();
                int n = tabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem item = tabItemArray[n2];
                    try {
                        item.dispose();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        tabFolder.getItem(0).dispose();
                    }
                    ++n2;
                }
                PaletteListViewDialog.this.createTab(tabFolder, count);
                PaletteListViewDialog.this.setStringType(eleId, tableCountCombo.getText());
                PaletteListViewDialog.this.makePreview(PaletteListViewDialog.this.browser);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                if (tableCountCombo.indexOf(text) < 0) {
                    tableCountCombo.add(text);
                    Object[] items = tableCountCombo.getItems();
                    Arrays.sort(items);
                    tableCountCombo.setItems((String[])items);
                }
                PaletteListViewDialog.this.makePreview(PaletteListViewDialog.this.browser);
            }
        });
        GridData tabFolderGridData = new GridData(4, 4, true, false);
        tabFolderGridData.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)tabFolderGridData);
        this.createTab(tabFolder, 3);
    }

    private void createTab(TabFolder tabFolder, int count) {
        TabItem tabItem = null;
        int loopIndex = 1;
        while (loopIndex < count + 1) {
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Tab " + loopIndex);
            tabItem.setControl(this.getTabControl(tabFolder, loopIndex));
            ++loopIndex;
        }
    }

    private Control getTabControl(TabFolder tabFolder, int loopIndex) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayout((Layout)new GridLayout(2, false));
        String[] column = this.columns.get(loopIndex - 1);
        new Label(composite, 16384).setText("Label:");
        Text text = new Text(composite, 2048);
        text.setText(column[0]);
        text.setEnabled(false);
        text.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("Divider:");
        Button btn1 = new Button(composite, 32);
        btn1.setEnabled(false);
        new Label(composite, 16384).setText("URL(href):");
        Text text1 = new Text(composite, 2048);
        text1.setText(column[2]);
        text1.setEnabled(false);
        text1.setLayoutData((Object)gridData);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        NUMBERED,
        READONLY,
        AUTODIVIDERS,
        SEARCHFILTER,
        INSET,
        ID,
        THEME,
        DIVIDERTHEME,
        ITEMSCOUNT;

    }
}

