/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PaletteGroupCheckboxesDialog
extends PaletteDefaultDialog {
    private String legend;
    private boolean checkID;
    private String id;
    private boolean layout;
    private boolean mini;
    private String iconPosition;
    private String theme;
    private String itemsCount;
    private List<String[]> columns = new ArrayList<String[]>();

    public PaletteGroupCheckboxesDialog() {
        super(null);
        this.setInitList();
    }

    public PaletteGroupCheckboxesDialog(Shell parentShell) {
        super(parentShell);
        this.setInitList();
    }

    private void setInitList() {
        this.columns.add(new String[]{"A", " false"});
        this.columns.add(new String[]{"B", " false"});
        this.columns.add(new String[]{"C", " false"});
        this.columns.add(new String[]{"D", " false"});
        this.columns.add(new String[]{"E", " false"});
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("groupedCheckboxes.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case ID: {
                this.checkID = value;
                break;
            }
            case MINI: {
                this.mini = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case LEGEND: {
                this.legend = value;
                break;
            }
            case ID: {
                this.id = value;
                break;
            }
            case LAYOUT: {
                if ("Horizontal".equals(value)) {
                    this.layout = true;
                    break;
                }
                this.layout = false;
                break;
            }
            case ICONPOSITION: {
                this.iconPosition = value;
                break;
            }
            case THEME: {
                this.theme = value;
                break;
            }
            case ITEMSCOUNT: {
                this.itemsCount = value;
            }
        }
    }

    public Map<String, Object> makeDataModel() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("legend", this.legend.trim());
        dataModel.put("checkId", String.valueOf(this.checkID).trim());
        dataModel.put("id", this.id.trim());
        dataModel.put("layout", String.valueOf(this.layout).trim());
        dataModel.put("mini", String.valueOf(this.mini).trim());
        dataModel.put("iconPosition", this.iconPosition.trim());
        dataModel.put("theme", this.theme.trim());
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < Integer.parseInt(this.itemsCount)) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            String[] column = this.columns.get(i);
            itemMap.put("label", column[0]);
            itemMap.put("checked", column[1]);
            list.add(itemMap);
            ++i;
        }
        dataModel.put("items", list);
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Grouped Checkboxes");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile grouped checkboxes widget.", 1);
    }

    public void initValue() {
        this.legend = "";
        this.checkID = true;
        this.id = "radio-1";
        this.layout = false;
        this.mini = false;
        this.iconPosition = "";
        this.theme = "";
        this.itemsCount = "3";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(4, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Composite composite = this.createComposite(container);
        this.addLabelText(composite, "Legend", "", Component.LEGEND.ordinal());
        this.addCheckButtonText(composite, "ID: ", "", true, Component.ID.ordinal());
        this.addCombo(composite, "Theme: ", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        Composite layoutComposite = this.createComposite(composite);
        Label modelb = new Label(layoutComposite, 0);
        modelb.setText("Layout:    ");
        this.addRadio(layoutComposite, "Horizontal", false, Component.LAYOUT.ordinal());
        Label padding = new Label(layoutComposite, 0);
        padding.setText("");
        this.addRadio(layoutComposite, "Vertical", true, Component.LAYOUT.ordinal());
        this.addLabelCheckButton(composite, "Mini: ", false, Component.MINI.ordinal());
        this.addCombo(composite, "Icon Position: ", JQueryMobileConstants.ICON_POSITION_ELEMENTS, Component.ICONPOSITION.ordinal());
        Composite groupItem = this.createGroup(container, "Items", 2);
        this.addTabGroup(groupItem, Component.ITEMSCOUNT.ordinal());
        this.createBrowser(container, 200, 4);
        return area;
    }

    private void addTabGroup(Composite container, final int eleId) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("Number :  ");
        final Combo tableCountCombo = new Combo(container, 2052);
        String[] tableCountEle = new String[]{"1", "2", "3", "4", "5"};
        tableCountCombo.setText("3");
        int i = 0;
        while (i < tableCountEle.length) {
            tableCountCombo.add(tableCountEle[i]);
            ++i;
        }
        final TabFolder tabFolder = new TabFolder(container, 0);
        tableCountCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                int count = Integer.parseInt(text);
                TabItem[] tabItemArray = tabFolder.getItems();
                int n = tabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem item = tabItemArray[n2];
                    try {
                        item.dispose();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        tabFolder.getItem(0).dispose();
                    }
                    ++n2;
                }
                PaletteGroupCheckboxesDialog.this.createTab(tabFolder, count);
                PaletteGroupCheckboxesDialog.this.setStringType(eleId, tableCountCombo.getText());
                PaletteGroupCheckboxesDialog.this.makePreview(PaletteGroupCheckboxesDialog.this.browser);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                if (tableCountCombo.indexOf(text) < 0) {
                    tableCountCombo.add(text);
                    Object[] items = tableCountCombo.getItems();
                    Arrays.sort(items);
                    tableCountCombo.setItems((String[])items);
                }
                PaletteGroupCheckboxesDialog.this.makePreview(PaletteGroupCheckboxesDialog.this.browser);
            }
        });
        GridData tabFolderGridData = new GridData(4, 4, true, false);
        tabFolderGridData.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)tabFolderGridData);
        this.createTab(tabFolder, 3);
    }

    private void createTab(TabFolder tabFolder, int count) {
        TabItem tabItem = null;
        int loopIndex = 1;
        while (loopIndex < count + 1) {
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Tab " + loopIndex);
            tabItem.setControl(this.getTabControl(tabFolder, loopIndex));
            ++loopIndex;
        }
    }

    private Control getTabControl(TabFolder tabFolder, int loopIndex) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayout((Layout)new GridLayout(2, false));
        String[] column = this.columns.get(loopIndex - 1);
        new Label(composite, 16384).setText("Label:");
        Text text = new Text(composite, 2048);
        text.setText(column[0]);
        text.setEnabled(false);
        text.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("Checked:");
        Button lbbtn = new Button(composite, 32);
        lbbtn.setEnabled(false);
        lbbtn.setLayoutData((Object)gridData);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        LEGEND,
        CHECKID,
        ID,
        LAYOUT,
        MINI,
        ICONPOSITION,
        THEME,
        ITEMSCOUNT;

    }
}

