/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PaletteFooterBarDialog
extends PaletteDefaultDialog {
    private String title;
    private boolean checkID;
    private String id;
    private boolean fixedPosition;
    private boolean fullScreen;
    private String arragement;
    private String iconPosition;
    private boolean iconOnly;
    private String theme;
    private String buttonsCount;
    private List<String[]> columns = new ArrayList<String[]>();

    public PaletteFooterBarDialog() {
        super(null);
        this.setInitList();
    }

    public PaletteFooterBarDialog(Shell parentShell) {
        super(parentShell);
        this.setInitList();
    }

    private void setInitList() {
        this.columns.add(new String[]{"Add", "#", "plus"});
        this.columns.add(new String[]{"Up", "#", "arrow-u"});
        this.columns.add(new String[]{"Down", "#", "arrow-d"});
        this.columns.add(new String[]{"Down", "#", "arrow-d"});
        this.columns.add(new String[]{"Down", "#", "arrow-d"});
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("footerBar.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case ID: {
                this.checkID = value;
                break;
            }
            case FIXEDPOSITION: {
                this.fixedPosition = value;
                break;
            }
            case FULLSCREEN: {
                this.fullScreen = value;
                break;
            }
            case ICONONLY: {
                this.iconOnly = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case TITLE: {
                this.title = value;
                break;
            }
            case ID: {
                this.id = value;
                break;
            }
            case ARRAGEMENT: {
                this.arragement = value.replace(" ", "").toLowerCase();
                break;
            }
            case ICONPOSITION: {
                this.iconPosition = value;
                break;
            }
            case THEME: {
                this.theme = value;
                break;
            }
            case BUTTONSCOUNT: {
                this.buttonsCount = value;
            }
        }
    }

    public Map<String, Object> makeDataModel() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("title", this.title.trim());
        dataModel.put("checkId", String.valueOf(this.checkID).trim());
        dataModel.put("id", this.id.trim());
        dataModel.put("fixedPosition", String.valueOf(this.fixedPosition).trim());
        dataModel.put("fullScreen", String.valueOf(this.fullScreen).trim());
        dataModel.put("arragement", this.arragement.trim());
        dataModel.put("iconPosition", this.iconPosition.trim());
        dataModel.put("iconOnly", String.valueOf(this.iconOnly).trim());
        dataModel.put("theme", this.theme.trim());
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < Integer.parseInt(this.buttonsCount)) {
            HashMap<String, String> buttonMap = new HashMap<String, String>();
            String[] column = this.columns.get(i);
            buttonMap.put("label", column[0]);
            buttonMap.put("url", column[1]);
            buttonMap.put("icon", column[2]);
            list.add(buttonMap);
            ++i;
        }
        dataModel.put("buttons", list);
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Footer Bar");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile footer bar widget.", 1);
    }

    public void initValue() {
        this.title = "";
        this.checkID = true;
        this.id = "";
        this.fixedPosition = false;
        this.fullScreen = false;
        this.arragement = "default";
        this.iconPosition = "";
        this.iconOnly = false;
        this.theme = "";
        this.buttonsCount = "3";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(4, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Composite composite = this.createComposite(container);
        this.addLabelText(composite, "Title", "", Component.TITLE.ordinal());
        this.addCheckButtonText(composite, "ID: ", "", true, Component.ID.ordinal());
        this.addCombo(composite, "Theme", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        Label modelb = new Label(composite, 0);
        modelb.setText("Arrangement:    ");
        this.addRadio(composite, "Default", true, Component.ARRAGEMENT.ordinal());
        Label padding1 = new Label(composite, 0);
        padding1.setText("");
        this.addRadio(composite, "Control Group", false, Component.ARRAGEMENT.ordinal());
        Label padding2 = new Label(composite, 0);
        padding2.setText("");
        this.addRadio(composite, "Navbar", false, Component.ARRAGEMENT.ordinal());
        this.addLabelCheckButton(composite, "Fixed Position: ", false, Component.FIXEDPOSITION.ordinal());
        this.addLabelCheckButton(composite, "Full Screen: ", false, Component.FULLSCREEN.ordinal());
        this.addCombo(composite, "Icon Position", JQueryMobileConstants.ICON_POSITION_ELEMENTS, Component.ICONPOSITION.ordinal());
        this.addLabelCheckButton(composite, "Icon only: ", false, Component.ICONONLY.ordinal());
        Composite group = this.createGroup(container, "Buttons", 2);
        this.addTabGroup(group, Component.BUTTONSCOUNT.ordinal());
        this.createBrowser(container, 200, 4);
        return area;
    }

    private void addTabGroup(Composite container, final int eleId) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("Number :  ");
        final Combo tableCountCombo = new Combo(container, 2052);
        String[] tableCountEle = new String[]{"1", "2", "3", "4", "5"};
        tableCountCombo.setText("3");
        int i = 0;
        while (i < tableCountEle.length) {
            tableCountCombo.add(tableCountEle[i]);
            ++i;
        }
        final TabFolder tabFolder = new TabFolder(container, 0);
        tableCountCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                int count = Integer.parseInt(text);
                TabItem[] tabItemArray = tabFolder.getItems();
                int n = tabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem item = tabItemArray[n2];
                    try {
                        item.dispose();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        tabFolder.getItem(0).dispose();
                    }
                    ++n2;
                }
                PaletteFooterBarDialog.this.createTab(tabFolder, count);
                PaletteFooterBarDialog.this.setStringType(eleId, tableCountCombo.getText());
                PaletteFooterBarDialog.this.makePreview(PaletteFooterBarDialog.this.browser);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                if (tableCountCombo.indexOf(text) < 0) {
                    tableCountCombo.add(text);
                    Object[] items = tableCountCombo.getItems();
                    Arrays.sort(items);
                    tableCountCombo.setItems((String[])items);
                }
                PaletteFooterBarDialog.this.makePreview(PaletteFooterBarDialog.this.browser);
            }
        });
        GridData tabFolderGridData = new GridData(4, 4, true, false);
        tabFolderGridData.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)tabFolderGridData);
        this.createTab(tabFolder, 3);
    }

    private void createTab(TabFolder tabFolder, int count) {
        TabItem tabItem = null;
        int loopIndex = 1;
        while (loopIndex < count + 1) {
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Tab " + loopIndex);
            tabItem.setControl(this.getTabControl(tabFolder, loopIndex));
            ++loopIndex;
        }
    }

    private Control getTabControl(TabFolder tabFolder, int loopIndex) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayout((Layout)new GridLayout(2, false));
        String[] column = this.columns.get(loopIndex - 1);
        new Label(composite, 16384).setText("Label:");
        Text text = new Text(composite, 2048);
        text.setText(column[0]);
        text.setEnabled(false);
        text.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("URL(href):");
        Text text1 = new Text(composite, 2048);
        text1.setText(column[1]);
        text1.setEnabled(false);
        text1.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("Icon:");
        Text iconcombo = new Text(composite, 2048);
        iconcombo.setText(column[2]);
        iconcombo.setEnabled(false);
        iconcombo.setLayoutData((Object)gridData);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        TITLE,
        CHECKID,
        ID,
        FIXEDPOSITION,
        FULLSCREEN,
        ARRAGEMENT,
        ICONPOSITION,
        ICONONLY,
        THEME,
        BUTTONSCOUNT;

    }
}

