/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.datamodel.TemplateConfiguration;
import com.poscoict.mobileframework.htmleditor.utils.BundleLocator;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteGenericDialog;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class PaletteDefaultDialog
extends TitleAreaDialog
implements PaletteGenericDialog,
JQueryMobileConstants {
    protected Browser browser;

    public PaletteDefaultDialog(Shell parentShell) {
        super(parentShell);
    }

    protected abstract Map<String, ?> makeDataModel();

    protected abstract void setBooleanType(int var1, boolean var2);

    protected abstract void setStringType(int var1, String var2);

    protected Browser createBrowser(Composite container, int height) {
        return this.createBrowser(container, height, 2);
    }

    protected Browser createBrowser(Composite container, int height, int hSpan) {
        Composite composite = new Composite(container, 2048);
        GridData compositeGridData = new GridData(1808);
        compositeGridData.horizontalSpan = hSpan;
        compositeGridData.minimumHeight = height;
        composite.setLayoutData((Object)compositeGridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(composite, 0);
        this.browser.setLayoutData((Object)new GridData(1808));
        this.setBrowser(this.browser);
        return this.browser;
    }

    protected void addLabelText(Composite container, String titleText, String textValue, final int eleId) {
        Label labelCom = new Label(container, 0);
        labelCom.setText(titleText);
        final Text textCom = new Text(container, 2048);
        textCom.setText(textValue);
        textCom.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PaletteDefaultDialog.this.setStringType(eleId, textCom.getText());
                PaletteDefaultDialog.this.makePreview(PaletteDefaultDialog.this.browser);
            }
        });
        textCom.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected void addLineHorizontal(Composite container) {
        GridData gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        Label label = new Label(container, 258);
        label.setLayoutData((Object)gridData);
    }

    protected void addCheckButtonText(Composite container, String headerText, String textvalue, boolean checked, final int eleId) {
        final Button checkButton = new Button(container, 32);
        final Text headLabel = new Text(container, 2048);
        checkButton.setText(headerText);
        checkButton.setSelection(checked);
        headLabel.setText(textvalue);
        headLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkButton.getSelection()) {
                    PaletteDefaultDialog.this.setBooleanType(eleId, true);
                    headLabel.setEditable(true);
                } else {
                    PaletteDefaultDialog.this.setBooleanType(eleId, false);
                    headLabel.setEditable(false);
                }
                PaletteDefaultDialog.this.makePreview(PaletteDefaultDialog.this.browser);
            }
        });
        headLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PaletteDefaultDialog.this.setStringType(eleId, headLabel.getText());
                PaletteDefaultDialog.this.makePreview(PaletteDefaultDialog.this.browser);
            }
        });
    }

    protected void addCheckButton(Composite container, String labelText, boolean checked, final int eleId) {
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        final Button checkButton = new Button(container, 32);
        checkButton.setText(labelText);
        checkButton.setSelection(checked);
        checkButton.setLayoutData((Object)gridData);
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkButton.getSelection()) {
                    PaletteDefaultDialog.this.setBooleanType(eleId, true);
                } else {
                    PaletteDefaultDialog.this.setBooleanType(eleId, false);
                }
                PaletteDefaultDialog.this.makePreview(PaletteDefaultDialog.this.browser);
            }
        });
    }

    protected void addLabelCheckButton(Composite container, String labelText, boolean checked, final int eleId) {
        Label label = new Label(container, 0);
        label.setText(labelText);
        final Button checkButton = new Button(container, 32);
        checkButton.setSelection(checked);
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkButton.getSelection()) {
                    PaletteDefaultDialog.this.setBooleanType(eleId, true);
                } else {
                    PaletteDefaultDialog.this.setBooleanType(eleId, false);
                }
                PaletteDefaultDialog.this.makePreview(PaletteDefaultDialog.this.browser);
            }
        });
        checkButton.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected Composite createComposite(Composite container) {
        return this.createComposite(container, 2);
    }

    protected Composite createComposite(Composite container, int layout) {
        Composite composite = new Composite(container, 2048);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(layout, false));
        return composite;
    }

    protected Composite createGroup(Composite container, String title) {
        return this.createGroup(container, title, 4);
    }

    protected Composite createGroup(Composite container, String title, int layout) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        Group group = new Group(container, 0);
        group.setText(title);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(layout, false));
        return group;
    }

    protected void addCombo(Composite container, String label, String[] elements, int eleId) {
        this.addCombo(container, label, elements, "", eleId);
    }

    protected void addCombo(Composite container, String label, String[] elements, String initValue, final int eleId) {
        Label labelCom = new Label(container, 0);
        labelCom.setText(label);
        final Combo comboEle = new Combo(container, 2052);
        Arrays.sort(elements);
        int i = 0;
        while (i < elements.length) {
            comboEle.add(elements[i]);
            ++i;
        }
        comboEle.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PaletteDefaultDialog.this.setStringType(eleId, comboEle.getText());
                PaletteDefaultDialog.this.makePreview(PaletteDefaultDialog.this.browser);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = comboEle.getText();
                if (comboEle.indexOf(text) < 0) {
                    comboEle.add(text);
                    Object[] items = comboEle.getItems();
                    Arrays.sort(items);
                    comboEle.setItems((String[])items);
                }
                PaletteDefaultDialog.this.makePreview(PaletteDefaultDialog.this.browser);
            }
        });
        comboEle.setText(initValue);
        comboEle.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected void addRadio(Composite container, String label, boolean selected, final int eleId) {
        final Button radio = new Button(container, 16);
        radio.setText(label);
        radio.setSelection(selected);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaletteDefaultDialog.this.setStringType(eleId, radio.getText());
                PaletteDefaultDialog.this.makePreview(PaletteDefaultDialog.this.browser);
            }
        });
        radio.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected String makejQuerySrc(String fileName) {
        StringWriter out = new StringWriter();
        Template temp = TemplateConfiguration.getInstance().getTemplate(fileName);
        try {
            temp.process(this.makeDataModel(), (Writer)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((Object)out).toString();
    }

    private void setBrowser(final Browser browser) {
        StringWriter writer = new StringWriter();
        Template temp = TemplateConfiguration.getInstance().getTemplate("editorPreview.ftl");
        HashMap<String, String> dataModel = new HashMap<String, String>();
        String filePath = BundleLocator.getInstance().getBundleFilePath();
        dataModel.put("JQUERY_MOBILE_CSS", "file://" + filePath + "css/jquery.mobile.css");
        dataModel.put("GLUE_MOBILE_CSS", "file://" + filePath + "css/theme-posco.css");
        dataModel.put("JQUEYR", "file://" + filePath + "js/libs/jquery.js");
        dataModel.put("JQUERY_MOBILE", "file://" + filePath + "js/libs/jquerymobile.js");
        try {
            temp.process(dataModel, (Writer)writer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String html = ((Object)writer).toString();
        browser.setText(html, false);
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                PaletteDefaultDialog.this.makePreview(browser);
            }
        });
    }

    protected void makePreview(Browser browser) {
        String content = this.makejQuerySrc();
        String modifiedContent = content.replaceAll("\r\n", "");
        String script = "var myPage='" + modifiedContent + "';" + "changePage(myPage);";
        if (modifiedContent.indexOf("ui-gird-temp-id") > 0) {
            script = String.valueOf(script) + "$('#ui-gird-temp-id').css('border-right', '1px dashed red').css('border-bottom', '1px dashed red').css('color', 'gray');" + "$('#ui-gird-temp-id > div').css('border-left', '1px dashed red').css('border-top', '1px dashed red').css('padding', '5px').css('text-align', 'center');";
        }
        browser.execute(script);
    }
}

