/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PaletteCollapsibleSetDialog
extends PaletteDefaultDialog {
    private boolean mini;
    private boolean inset;
    private boolean checkId;
    private String id;
    private String collapsedIcon;
    private String expandedIcon;
    private String iconPosition;
    private String theme;
    private String contentTheme;
    private String itemCount;
    private List<String[]> columns = new ArrayList<String[]>();

    public PaletteCollapsibleSetDialog() {
        super(null);
        this.setInitList();
    }

    public PaletteCollapsibleSetDialog(Shell parentShell) {
        super(parentShell);
        this.setInitList();
    }

    private void setInitList() {
        this.columns.add(new String[]{"A", "true"});
        this.columns.add(new String[]{"B", "true"});
        this.columns.add(new String[]{"C", "true"});
        this.columns.add(new String[]{"D", "true"});
        this.columns.add(new String[]{"E", "true"});
        this.columns.add(new String[]{"F", "true"});
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("collapsibleSet.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case ID: {
                this.checkId = value;
                break;
            }
            case MINI: {
                this.mini = value;
                break;
            }
            case INSET: {
                this.inset = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case ID: {
                this.id = value;
                break;
            }
            case COLLAPEDICON: {
                this.collapsedIcon = value;
                break;
            }
            case EXPANDEDICON: {
                this.expandedIcon = value;
                break;
            }
            case ICONPOSITION: {
                this.iconPosition = value;
                break;
            }
            case THEME: {
                this.theme = value;
                break;
            }
            case CONTENTTHEME: {
                this.contentTheme = value;
                break;
            }
            case ITEMCOUNT: {
                this.itemCount = value;
            }
        }
    }

    public Map<String, Object> makeDataModel() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("mini", String.valueOf(this.mini).trim());
        dataModel.put("checkId", String.valueOf(this.checkId).trim());
        dataModel.put("id", this.id.trim());
        dataModel.put("collapsedIcon", this.collapsedIcon.trim());
        dataModel.put("expandedIcon", this.expandedIcon.trim());
        dataModel.put("iconPosition", this.iconPosition.trim());
        dataModel.put("theme", this.theme.trim());
        dataModel.put("contentTheme", this.contentTheme.trim());
        dataModel.put("inset", String.valueOf(this.inset).trim());
        ArrayList items = new ArrayList();
        int i = 0;
        while (i < Integer.parseInt(this.itemCount)) {
            HashMap<String, String> columnMap = new HashMap<String, String>();
            String[] column = this.columns.get(i);
            columnMap.put("header", column[0]);
            columnMap.put("collapsed", column[1]);
            items.add(columnMap);
            ++i;
        }
        dataModel.put("collapsibles", items);
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Collapsible Set");
        this.setMessage(null);
        this.setMessage("Create a new JQuery Mobile collapsible set widget.", 1);
    }

    public void initValue() {
        this.mini = false;
        this.inset = true;
        this.checkId = true;
        this.id = "collapsible-set-1";
        this.collapsedIcon = "";
        this.expandedIcon = "";
        this.iconPosition = "";
        this.theme = "";
        this.contentTheme = "";
        this.itemCount = "3";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(4, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Composite composite = this.createComposite(container);
        this.addCheckButtonText(composite, "ID: ", "Generate", true, Component.ID.ordinal());
        this.addCombo(composite, "Theme: ", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        this.addCombo(composite, "Content Theme: ", JQueryMobileConstants.THEME_ELEMENTS, Component.CONTENTTHEME.ordinal());
        Composite group = this.createGroup(composite, "");
        this.addLabelCheckButton(group, "Mini:  ", true, Component.MINI.ordinal());
        this.addLabelCheckButton(group, "Inset: ", true, Component.INSET.ordinal());
        this.addLineHorizontal(composite);
        this.addCombo(composite, "Collapsed Icon: ", JQueryMobileConstants.ICON_ELEMENTS, Component.COLLAPEDICON.ordinal());
        this.addCombo(composite, "Expanded Icon: ", JQueryMobileConstants.ICON_ELEMENTS, Component.EXPANDEDICON.ordinal());
        this.addCombo(composite, "Icon position: ", JQueryMobileConstants.ICON_POSITION_ELEMENTS, Component.ICONPOSITION.ordinal());
        Composite itemGroup = this.createGroup(container, "Items", 2);
        this.addTabGroup(itemGroup, Component.ITEMCOUNT.ordinal());
        this.createBrowser(container, 300, 4);
        return area;
    }

    private void addTabGroup(Composite container, final int eleId) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("Number :  ");
        final Combo tableCountCombo = new Combo(container, 2052);
        String[] tableCountEle = new String[]{"1", "2", "3", "4", "5", "6"};
        tableCountCombo.setText("3");
        int i = 0;
        while (i < tableCountEle.length) {
            tableCountCombo.add(tableCountEle[i]);
            ++i;
        }
        final TabFolder tabFolder = new TabFolder(container, 0);
        tableCountCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                int count = Integer.parseInt(text);
                TabItem[] tabItemArray = tabFolder.getItems();
                int n = tabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem item = tabItemArray[n2];
                    try {
                        item.dispose();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        tabFolder.getItem(0).dispose();
                    }
                    ++n2;
                }
                PaletteCollapsibleSetDialog.this.createTab(tabFolder, count);
                PaletteCollapsibleSetDialog.this.setStringType(eleId, tableCountCombo.getText());
                PaletteCollapsibleSetDialog.this.makePreview(PaletteCollapsibleSetDialog.this.browser);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String text = tableCountCombo.getText();
                if (tableCountCombo.indexOf(text) < 0) {
                    tableCountCombo.add(text);
                    Object[] items = tableCountCombo.getItems();
                    Arrays.sort(items);
                    tableCountCombo.setItems((String[])items);
                }
                PaletteCollapsibleSetDialog.this.makePreview(PaletteCollapsibleSetDialog.this.browser);
            }
        });
        GridData tabFolderGridData = new GridData(4, 4, true, false);
        tabFolderGridData.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)tabFolderGridData);
        this.createTab(tabFolder, 3);
    }

    private void createTab(TabFolder tabFolder, int count) {
        TabItem tabItem = null;
        int loopIndex = 1;
        while (loopIndex < count + 1) {
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText("Tab " + loopIndex);
            tabItem.setControl(this.getTabControl(tabFolder, loopIndex));
            ++loopIndex;
        }
    }

    private Control getTabControl(TabFolder tabFolder, int loopIndex) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 1;
        composite.setLayout((Layout)new GridLayout(2, false));
        String[] column = this.columns.get(loopIndex - 1);
        new Label(composite, 16384).setText("Header:");
        Text text = new Text(composite, 2048);
        text.setText(column[0]);
        text.setEnabled(false);
        text.setLayoutData((Object)gridData);
        new Label(composite, 16384).setText("Collapsed:");
        Button resp = new Button(composite, 32);
        resp.setSelection(true);
        resp.setEnabled(false);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        MINI,
        INSET,
        ID,
        COLLAPEDICON,
        EXPANDEDICON,
        ICONPOSITION,
        THEME,
        CONTENTTHEME,
        ITEMCOUNT;

    }
}

