/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views.dialog;

import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDefaultDialog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PaletteCheckboxDialog
extends PaletteDefaultDialog {
    private String label;
    private String id;
    private boolean mini;
    private String iconPosition;
    private String theme;

    public PaletteCheckboxDialog() {
        super(null);
    }

    public PaletteCheckboxDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public String makejQuerySrc() {
        return this.makejQuerySrc("checkbox.ftl");
    }

    @Override
    protected void setBooleanType(int ele, boolean value) {
        Component component = Component.values()[ele];
        switch (component) {
            case MINI: {
                this.mini = value;
            }
        }
    }

    @Override
    protected void setStringType(int ele, String value) {
        Component component = Component.values()[ele];
        switch (component) {
            case LABEL: {
                this.label = value;
                break;
            }
            case ID: {
                this.id = value;
                break;
            }
            case ICONPOSITION: {
                this.iconPosition = value;
                break;
            }
            case THEME: {
                this.theme = value;
            }
        }
    }

    public Map<String, String> makeDataModel() {
        HashMap<String, String> dataModel = new HashMap<String, String>();
        dataModel.put("label", this.label.trim());
        dataModel.put("id", this.id.trim());
        dataModel.put("mini", String.valueOf(this.mini).trim());
        dataModel.put("iconPosition", this.iconPosition.trim());
        dataModel.put("theme", this.theme.trim());
        return dataModel;
    }

    public void create() {
        super.create();
        this.initValue();
        this.setTitle("New Checkbox");
        this.setMessage(null);
        this.setMessage("Create a new JQuery checkbox widget.", 1);
    }

    public void initValue() {
        this.label = "I agree";
        this.id = "checkbox-1";
        this.mini = false;
        this.iconPosition = "";
        this.theme = "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.addLabelText(container, "Label: ", "I agree", Component.LABEL.ordinal());
        this.addLabelText(container, "ID: ", "Generate", Component.ID.ordinal());
        this.addLabelCheckButton(container, "Mini: ", false, Component.MINI.ordinal());
        this.addCombo(container, "Icon Position", JQueryMobileConstants.ICON_POSITION_ELEMENTS, Component.ICONPOSITION.ordinal());
        this.addCombo(container, "Theme", JQueryMobileConstants.THEME_ELEMENTS, Component.THEME.ordinal());
        this.createBrowser(container, 200);
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private static enum Component {
        LABEL,
        ID,
        MINI,
        ICONPOSITION,
        THEME;

    }
}

