/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.HTMLUtil;
import com.poscoict.mobileframework.htmleditor.editors.HTMLSourceEditor;
import com.poscoict.mobileframework.htmleditor.views.DefaultPaletteItem;
import com.poscoict.mobileframework.htmleditor.views.DialogPaletteItem;
import com.poscoict.mobileframework.htmleditor.views.IPaletteContributer;
import com.poscoict.mobileframework.htmleditor.views.IPaletteItem;
import com.poscoict.mobileframework.htmleditor.views.IPaletteTarget;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteButtonDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteCheckboxDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteCollapsibleDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteCollapsibleSetDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteDialogDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteFooterBarDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteGenericDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteGridDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteGroupButtonsDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteGroupCheckboxesDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteHeaderBarDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteLinkDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteListViewDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteNaviBarDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PalettePageDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PalettePanelDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PalettePopupDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteRadioDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteSelectMenuDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteSliderDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteTableDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteTextInputDialog;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteToggleSwitchDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.gef.Tool;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.DefaultPaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class PaletteView
extends ViewPart {
    private PaletteViewer viewer;
    private final TreeMap<String, List<IPaletteItem>> items = new TreeMap();
    private final HashMap<HTMLPaletteEntry, IPaletteItem> tools = new HashMap();
    private final String[] defaultCategories;

    public PaletteView() {
        this.addPaletteItem("HTML", new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_form"), "<form action=\"\" method=\"\"></form>"));
        this.addPaletteItem("HTML", new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_text"), "<input type=\"text\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_textarea"), "<textarea name=\"\" rows=\"\" cols=\"\"></textarea>"));
        this.addPaletteItem("HTML", new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_pass"), "<input type=\"password\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_radio"), "<input type=\"radio\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_check"), "<input type=\"checkbox\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_button"), "<input type=\"button\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_submit"), "<input type=\"submit\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_reset"), "<input type=\"reset\" value=\"\" />"));
        this.addPaletteItem("JQuery Mobile", new DefaultPaletteItem("_icon_jquery_jscss", "<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"UTF-8\">\n<meta name=\"viewport\" content=\"width=device-width,initial-scale=1\">\n<link rel=\"stylesheet\" href=\"../css/jquery.mobile.css\">\n<link rel=\"stylesheet\" href=\"../css/theme-posco.css\">\n<script src=\"libs/jquery.js\"></script>\n<script src=\"libs/jquerymobile.js\"></script>\n<title>Insert title here</title>\n</head>\n<body>\n</body>\n</html>\n"));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_page", (PaletteGenericDialog)new PalettePageDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_dialog", (PaletteGenericDialog)new PaletteDialogDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_popup", (PaletteGenericDialog)new PalettePopupDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_grid", (PaletteGenericDialog)new PaletteGridDialog()));
        this.addPaletteItem("JQuery Mobile", new DefaultPaletteItem("_icon_jquery_fieldcontainer", "<div data-role=\"fieldcontain\"></div>\n"));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_panel", (PaletteGenericDialog)new PalettePanelDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_table", (PaletteGenericDialog)new PaletteTableDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_collapsible", (PaletteGenericDialog)new PaletteCollapsibleDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_collapsibleset", (PaletteGenericDialog)new PaletteCollapsibleSetDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_headerbar", (PaletteGenericDialog)new PaletteHeaderBarDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_footerbar", (PaletteGenericDialog)new PaletteFooterBarDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_navbar", (PaletteGenericDialog)new PaletteNaviBarDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_select", (PaletteGenericDialog)new PaletteSelectMenuDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_listview", (PaletteGenericDialog)new PaletteListViewDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_button", (PaletteGenericDialog)new PaletteButtonDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_buttons", (PaletteGenericDialog)new PaletteGroupButtonsDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_link", (PaletteGenericDialog)new PaletteLinkDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_toggle", (PaletteGenericDialog)new PaletteToggleSwitchDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_radio", (PaletteGenericDialog)new PaletteRadioDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_checkbox", (PaletteGenericDialog)new PaletteCheckboxDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_checkboxes", (PaletteGenericDialog)new PaletteGroupCheckboxesDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_slider", (PaletteGenericDialog)new PaletteSliderDialog()));
        this.addPaletteItem("JQuery Mobile", new DialogPaletteItem("_icon_jquery_textinput", (PaletteGenericDialog)new PaletteTextInputDialog()));
        String[] groups = HTMLPlugin.getDefault().getPaletteContributerGroups();
        int i = 0;
        while (i < groups.length) {
            IPaletteContributer contributer = HTMLPlugin.getDefault().getPaletteContributer(groups[i]);
            IPaletteItem[] items = contributer.getPaletteItems();
            int j = 0;
            while (j < items.length) {
                this.addPaletteItem(groups[i], items[j]);
                ++j;
            }
            ++i;
        }
        this.defaultCategories = this.getCategories();
    }

    private void createToolBar() {
        Action customize = new Action("Configuration", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_property")){

            public void run() {
                PaletteCustomizeDialog dialog = new PaletteCustomizeDialog(PaletteView.this.getViewSite().getShell());
                dialog.open();
            }
        };
        customize.setToolTipText("Configuration");
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)customize);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new PaletteViewer();
        DefaultPaletteViewerPreferences paletteViewerPreferences = new DefaultPaletteViewerPreferences();
        paletteViewerPreferences.setLayoutSetting(1);
        this.viewer.setPaletteViewerPreferences((PaletteViewerPreferences)paletteViewerPreferences);
        this.viewer.createControl(parent);
        PaletteRoot root = new PaletteRoot();
        String[] category = this.getCategories();
        int i = 0;
        while (i < category.length) {
            PaletteDrawer group = new PaletteDrawer(category[i]);
            IPaletteItem[] items = this.getPaletteItems(category[i]);
            int j = 0;
            while (j < items.length) {
                HTMLPaletteEntry entry = new HTMLPaletteEntry(items[j].getLabel(), null, items[j].getImageDescriptor());
                this.tools.put(entry, items[j]);
                group.add((PaletteEntry)entry);
                ++j;
            }
            root.add((PaletteEntry)group);
            ++i;
        }
        this.viewer.setPaletteRoot(root);
        this.viewer.addPaletteListener(new PaletteListener(){

            public void activeToolChanged(PaletteViewer palette, ToolEntry tool) {
                Object obj = palette.getEditPartRegistry().get(tool);
                if (!(obj instanceof ToolEntryEditPart)) {
                    return;
                }
                ToolEntryEditPart part = (ToolEntryEditPart)obj;
                if (part != null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart editorPart = page.getActiveEditor();
                    if (editorPart != null) {
                        if (editorPart instanceof HTMLSourceEditor) {
                            IPaletteItem item = (IPaletteItem)PaletteView.this.tools.get(tool);
                            item.execute((HTMLSourceEditor)editorPart);
                        } else if (editorPart instanceof IPaletteTarget) {
                            IPaletteItem item = (IPaletteItem)PaletteView.this.tools.get(tool);
                            item.execute(((IPaletteTarget)editorPart).getPaletteTarget());
                        }
                    }
                    part.setToolSelected(false);
                }
            }
        });
        this.viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.getActiveEditor();
                if (editorPart != null) {
                    editorPart.setFocus();
                }
            }
        });
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String xml = store.getString("_pref_palette_items");
        if (xml != null) {
            FuzzyXMLDocument doc = new FuzzyXMLParser().parse(xml);
            FuzzyXMLNode[] groups = HTMLUtil.selectXPathNodes(doc.getDocumentElement(), "/palette/groups/group");
            int i2 = 0;
            while (i2 < groups.length) {
                FuzzyXMLElement group = (FuzzyXMLElement)groups[i2];
                String name = group.getAttributeNode("name").getValue();
                boolean visible = Boolean.valueOf(group.getAttributeNode("visible").getValue());
                List entries = this.viewer.getPaletteRoot().getChildren();
                PaletteDrawer drawer = null;
                int j = 0;
                while (j < entries.size()) {
                    drawer = (PaletteDrawer)entries.get(j);
                    if (drawer.getLabel().equals(name)) {
                        drawer.setVisible(visible);
                        break;
                    }
                    drawer = null;
                    ++j;
                }
                if (drawer == null) {
                    drawer = new PaletteDrawer(name);
                    drawer.setVisible(visible);
                    this.viewer.getPaletteRoot().add((PaletteEntry)drawer);
                }
                ++i2;
            }
            FuzzyXMLNode[] items = HTMLUtil.selectXPathNodes(doc.getDocumentElement(), "/palette/items/item");
            Object[] categories = this.getCategories();
            int i3 = 0;
            while (i3 < items.length) {
                FuzzyXMLElement item = (FuzzyXMLElement)items[i3];
                item.getAttributeNode("name").getValue();
                String group = item.getAttributeNode("group").getValue();
                String text = item.getValue();
                if (Arrays.binarySearch(categories, group) < 0) {
                    this.addPaletteItem(group, new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_tag"), text));
                }
                ++i3;
            }
        }
        List entries = this.viewer.getPaletteRoot().getChildren();
        int i4 = 0;
        while (i4 < entries.size()) {
            PaletteDrawer group = (PaletteDrawer)entries.get(i4);
            if (Arrays.binarySearch(this.defaultCategories, group.getLabel()) < 0) {
                IPaletteItem[] items = this.getPaletteItems(group.getLabel());
                ArrayList<HTMLPaletteEntry> itemList = new ArrayList<HTMLPaletteEntry>();
                int j = 0;
                while (j < items.length) {
                    HTMLPaletteEntry entry = new HTMLPaletteEntry(items[j].getLabel(), null, items[j].getImageDescriptor());
                    this.tools.put(entry, items[j]);
                    itemList.add(entry);
                    ++j;
                }
                group.setChildren(itemList);
            }
            ++i4;
        }
        this.createToolBar();
    }

    private void addPaletteItem(String category, IPaletteItem item) {
        List<Object> list;
        if (this.items.get(category) == null) {
            list = new ArrayList();
            this.items.put(category, list);
        }
        list = this.items.get(category);
        list.add(item);
    }

    private void updateCategory(String category, List<Map<String, String>> items) {
        this.viewer.setActiveTool(null);
        List<IPaletteItem> list = this.items.get(category);
        if (list != null) {
            list.clear();
        }
        List entries = this.viewer.getPaletteRoot().getChildren();
        PaletteDrawer group = null;
        int i = 0;
        while (i < entries.size()) {
            group = (PaletteDrawer)entries.get(i);
            if (group.getLabel().equals(category)) break;
            group = null;
            ++i;
        }
        if (group == null) {
            group = new PaletteDrawer(category);
            this.viewer.getPaletteRoot().add((PaletteEntry)group);
        }
        i = 0;
        while (i < items.size()) {
            Map<String, String> map = items.get(i);
            this.addPaletteItem(category, new DefaultPaletteItem(HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_tag"), map.get("text")));
            ++i;
        }
        ArrayList<HTMLPaletteEntry> itemList = new ArrayList<HTMLPaletteEntry>();
        IPaletteItem[] newItems = this.getPaletteItems(category);
        int i2 = 0;
        while (i2 < newItems.length) {
            HTMLPaletteEntry entry = new HTMLPaletteEntry(newItems[i2].getLabel(), null, newItems[i2].getImageDescriptor());
            this.tools.put(entry, newItems[i2]);
            itemList.add(entry);
            ++i2;
        }
        group.setChildren(itemList);
    }

    private void removeCategory(String category) {
        this.viewer.setActiveTool(null);
        this.items.remove(category);
        List entries = this.viewer.getPaletteRoot().getChildren();
        PaletteDrawer group = null;
        int i = 0;
        while (i < entries.size()) {
            group = (PaletteDrawer)entries.get(i);
            if (group.getLabel().equals(category)) {
                List children = group.getChildren();
                int j = 0;
                while (j < children.size()) {
                    this.tools.remove(children.get(j));
                    group.remove((PaletteEntry)children.get(j));
                    ++j;
                }
                this.viewer.getPaletteRoot().remove((PaletteEntry)group);
                break;
            }
            ++i;
        }
    }

    private IPaletteItem[] getPaletteItems(String category) {
        List<IPaletteItem> list = this.items.get(category);
        if (list == null) {
            return new IPaletteItem[0];
        }
        return list.toArray(new IPaletteItem[list.size()]);
    }

    private String[] getCategories() {
        return this.items.keySet().toArray(new String[0]);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private String getPreferenceXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<palette>");
        List entries = this.viewer.getPaletteRoot().getChildren();
        sb.append("<groups>");
        int i = 0;
        while (i < entries.size()) {
            PaletteDrawer group = (PaletteDrawer)entries.get(i);
            sb.append("<group name=\"" + HTMLUtil.escapeXML(group.getLabel()) + "\"" + " visible=\"" + HTMLUtil.escapeXML(String.valueOf(group.isVisible())) + "\" />");
            ++i;
        }
        sb.append("</groups>");
        sb.append("<items>");
        String[] categories = this.getCategories();
        int i2 = 0;
        while (i2 < categories.length) {
            if (Arrays.binarySearch(this.defaultCategories, categories[i2]) < 0) {
                IPaletteItem[] items = this.getPaletteItems(categories[i2]);
                int j = 0;
                while (j < items.length) {
                    sb.append("<item group=\"" + HTMLUtil.escapeXML(categories[i2]) + "\"" + " name=\"" + HTMLUtil.escapeXML(items[j].getLabel()) + "\">" + HTMLUtil.escapeXML(((DefaultPaletteItem)items[j]).getContent()) + "</item>");
                    ++j;
                }
            }
            ++i2;
        }
        sb.append("</items>");
        sb.append("</palette>");
        return sb.toString();
    }

    private class HTMLPaletteEntry
    extends ToolEntry {
        public HTMLPaletteEntry(String label, String shortDescription, ImageDescriptor icon) {
            super(label, shortDescription, icon, icon);
        }

        public Tool createTool() {
            return null;
        }
    }

    private class PaletteCustomizeDialog
    extends Dialog {
        private Table table;
        private Button add;
        private Button edit;
        private Button remove;
        private final Map<String, Object> operations;

        public PaletteCustomizeDialog(Shell parentShell) {
            super(parentShell);
            this.operations = new HashMap<String, Object>();
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Point getInitialSize() {
            return new Point(300, 300);
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(HTMLPlugin.getResourceString("Dialog.PaletteConfig"));
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            container.setLayoutData((Object)new GridData(1808));
            this.table = new Table(container, 2080);
            this.table.setLayoutData((Object)new GridData(1808));
            List entries = PaletteView.this.viewer.getPaletteRoot().getChildren();
            int i = 0;
            while (i < entries.size()) {
                TableItem item = new TableItem(this.table, 16384);
                item.setText(((PaletteDrawer)entries.get(i)).getLabel());
                item.setChecked(((PaletteDrawer)entries.get(i)).isVisible());
                ++i;
            }
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    TableItem[] items = PaletteCustomizeDialog.this.table.getSelection();
                    if (items.length == 0 || Arrays.binarySearch(PaletteView.this.defaultCategories, items[0].getText()) >= 0) {
                        PaletteCustomizeDialog.this.edit.setEnabled(false);
                        PaletteCustomizeDialog.this.remove.setEnabled(false);
                    } else {
                        PaletteCustomizeDialog.this.edit.setEnabled(true);
                        PaletteCustomizeDialog.this.remove.setEnabled(true);
                    }
                }
            });
            Composite buttons = new Composite(container, 0);
            buttons.setLayout((Layout)new GridLayout());
            buttons.setLayoutData((Object)new GridData(2));
            this.add = new Button(buttons, 8);
            this.add.setText(HTMLPlugin.getResourceString("Button.AddGroup"));
            this.add.setLayoutData((Object)new GridData(768));
            this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    PaletteGroupDialog dialog = new PaletteGroupDialog(PaletteCustomizeDialog.this.getShell());
                    if (dialog.open() == 0) {
                        TableItem item = new TableItem(PaletteCustomizeDialog.this.table, 0);
                        item.setText(dialog.getGroupName());
                        item.setChecked(true);
                        PaletteCustomizeDialog.this.operations.put(dialog.getGroupName(), dialog.getPaletteItems());
                    }
                }
            });
            this.edit = new Button(buttons, 8);
            this.edit.setText(HTMLPlugin.getResourceString("Button.EditGroup"));
            this.edit.setLayoutData((Object)new GridData(768));
            this.edit.setEnabled(false);
            this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    TableItem[] items = PaletteCustomizeDialog.this.table.getSelection();
                    ArrayList<Map<String, String>> initItems = new ArrayList();
                    Object obj = PaletteCustomizeDialog.this.operations.get(items[0].getText());
                    if (obj != null && obj instanceof List) {
                        initItems = (List)obj;
                    } else {
                        IPaletteItem[] paletteItems = PaletteView.this.getPaletteItems(items[0].getText());
                        int i = 0;
                        while (i < paletteItems.length) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("name", paletteItems[i].getLabel());
                            map.put("text", ((DefaultPaletteItem)paletteItems[i]).getContent());
                            initItems.add(map);
                            ++i;
                        }
                    }
                    PaletteGroupDialog dialog = new PaletteGroupDialog(PaletteCustomizeDialog.this.getShell(), items[0].getText(), initItems);
                    if (dialog.open() == 0) {
                        items[0].setText(dialog.getGroupName());
                        PaletteCustomizeDialog.this.operations.put(items[0].getText(), dialog.getPaletteItems());
                    }
                }
            });
            this.remove = new Button(buttons, 8);
            this.remove.setText(HTMLPlugin.getResourceString("Button.RemoveGroup"));
            this.remove.setLayoutData((Object)new GridData(768));
            this.remove.setEnabled(false);
            this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    TableItem[] items = PaletteCustomizeDialog.this.table.getSelection();
                    PaletteCustomizeDialog.this.operations.put(items[0].getText(), "remove");
                    PaletteCustomizeDialog.this.table.remove(PaletteCustomizeDialog.this.table.getSelectionIndex());
                }
            });
            return container;
        }

        protected void okPressed() {
            for (String key : this.operations.keySet()) {
                Object obj = this.operations.get(key);
                if (obj.equals("remove")) {
                    PaletteView.this.removeCategory(key);
                    continue;
                }
                PaletteView.this.updateCategory(key, (List)obj);
            }
            List entries = PaletteView.this.viewer.getPaletteRoot().getChildren();
            int i = 0;
            while (i < entries.size()) {
                ((PaletteDrawer)entries.get(i)).setVisible(this.table.getItem(i).getChecked());
                ++i;
            }
            IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
            store.setValue("_pref_palette_items", PaletteView.this.getPreferenceXML());
            super.okPressed();
        }
    }

    private class PaletteGroupDialog
    extends Dialog {
        private Text name;
        private Table table;
        private Button add;
        private Button edit;
        private Button remove;
        private String initialName;
        private List<Map<String, String>> initialItems;
        private String inputedName;
        private List<Map<String, String>> inputedItems;

        public PaletteGroupDialog(Shell parentShell) {
            this(parentShell, null, new ArrayList<Map<String, String>>());
        }

        public PaletteGroupDialog(Shell parentShell, String name, List<Map<String, String>> items) {
            super(parentShell);
            this.initialName = null;
            this.initialItems = null;
            this.inputedName = null;
            this.inputedItems = null;
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.initialName = name;
            this.initialItems = items;
        }

        protected Point getInitialSize() {
            return new Point(450, 350);
        }

        protected Control createDialogArea(Composite parent) {
            if (this.initialName == null) {
                this.getShell().setText(HTMLPlugin.getResourceString("Dialog.AddPaletteGroup"));
            } else {
                this.getShell().setText(HTMLPlugin.getResourceString("Dialog.EditPaletteGroup"));
            }
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(3, false));
            container.setLayoutData((Object)new GridData(1808));
            Label label = new Label(container, 0);
            label.setText(HTMLPlugin.getResourceString("Label.GroupName"));
            this.name = new Text(container, 2048);
            if (this.initialName != null) {
                this.name.setText(this.initialName);
                this.name.setEditable(false);
            }
            this.name.setLayoutData((Object)new GridData(768));
            label = new Label(container, 0);
            label = new Label(container, 0);
            label.setText(HTMLPlugin.getResourceString("Label.Items"));
            this.table = new Table(container, 67584);
            this.table.setLayoutData((Object)new GridData(1808));
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    TableItem[] items = PaletteGroupDialog.this.table.getSelection();
                    if (items.length == 0) {
                        PaletteGroupDialog.this.edit.setEnabled(false);
                        PaletteGroupDialog.this.remove.setEnabled(false);
                    } else {
                        PaletteGroupDialog.this.edit.setEnabled(true);
                        PaletteGroupDialog.this.remove.setEnabled(true);
                    }
                }
            });
            TableColumn col1 = new TableColumn(this.table, 16384);
            col1.setText(HTMLPlugin.getResourceString("Message.ItemName"));
            col1.setWidth(100);
            TableColumn col2 = new TableColumn(this.table, 16384);
            col2.setText(HTMLPlugin.getResourceString("Message.InsertText"));
            col2.setWidth(250);
            if (this.initialName != null) {
                int i = 0;
                while (i < this.initialItems.size()) {
                    Map<String, String> map = this.initialItems.get(i);
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(new String[]{map.get("name"), map.get("text")});
                    ++i;
                }
            }
            Composite buttons = new Composite(container, 0);
            buttons.setLayout((Layout)new GridLayout());
            buttons.setLayoutData((Object)new GridData(2));
            this.add = new Button(buttons, 8);
            this.add.setText(HTMLPlugin.getResourceString("Button.AddItem"));
            this.add.setLayoutData((Object)new GridData(768));
            this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    PaletteItemDialog dialog = new PaletteItemDialog(PaletteGroupDialog.this.getShell());
                    if (dialog.open() == 0) {
                        String name = dialog.getItemName();
                        String text = dialog.getInsertText();
                        TableItem item = new TableItem(PaletteGroupDialog.this.table, 0);
                        item.setText(new String[]{name, text});
                    }
                }
            });
            this.edit = new Button(buttons, 8);
            this.edit.setText(HTMLPlugin.getResourceString("Button.EditItem"));
            this.edit.setLayoutData((Object)new GridData(768));
            this.edit.setEnabled(false);
            this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    TableItem[] item = PaletteGroupDialog.this.table.getSelection();
                    PaletteItemDialog dialog = new PaletteItemDialog(PaletteGroupDialog.this.getShell(), item[0].getText(0), item[0].getText(1));
                    if (dialog.open() == 0) {
                        String name = dialog.getItemName();
                        String text = dialog.getInsertText();
                        item[0].setText(new String[]{name, text});
                    }
                }
            });
            this.remove = new Button(buttons, 8);
            this.remove.setText(HTMLPlugin.getResourceString("Button.RemoveItem"));
            this.remove.setLayoutData((Object)new GridData(768));
            this.remove.setEnabled(false);
            this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    PaletteGroupDialog.this.table.remove(PaletteGroupDialog.this.table.getSelectionIndices());
                }
            });
            return container;
        }

        protected void okPressed() {
            int i;
            if (this.name.getText().equals("")) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("Message.GroupName")}));
                return;
            }
            if (this.initialName == null) {
                String[] categories = PaletteView.this.getCategories();
                i = 0;
                while (i < categories.length) {
                    if (categories[i].equals(this.name.getText())) {
                        HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.AlreadyExists"), new String[]{this.name.getText()}));
                        return;
                    }
                    ++i;
                }
            }
            this.inputedName = this.name.getText();
            this.inputedItems = new ArrayList<Map<String, String>>();
            TableItem[] items = this.table.getItems();
            i = 0;
            while (i < items.length) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", items[i].getText(0));
                map.put("text", items[i].getText(1));
                this.inputedItems.add(map);
                ++i;
            }
            super.okPressed();
        }

        public String getGroupName() {
            return this.inputedName;
        }

        public List<Map<String, String>> getPaletteItems() {
            return this.inputedItems;
        }
    }

    private class PaletteItemDialog
    extends Dialog {
        private Text itemName;
        private Text insertText;
        private String inputedName;
        private String inputedText;
        private String initialName;
        private String initialText;

        public PaletteItemDialog(Shell parentShell) {
            this(parentShell, null, null);
        }

        public PaletteItemDialog(Shell parentShell, String name, String text) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.initialName = name;
            this.initialText = text;
        }

        protected Point getInitialSize() {
            return new Point(400, 180);
        }

        protected Control createDialogArea(Composite parent) {
            if (this.initialName == null) {
                this.getShell().setText(HTMLPlugin.getResourceString("Dialog.AddPaletteItem"));
            } else {
                this.getShell().setText(HTMLPlugin.getResourceString("Dialog.EditPaletteItem"));
            }
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            container.setLayoutData((Object)new GridData(1808));
            Label label = new Label(container, 0);
            label.setText(HTMLPlugin.getResourceString("Label.ItemName"));
            this.itemName = new Text(container, 2048);
            this.itemName.setLayoutData((Object)new GridData(768));
            if (this.initialName != null) {
                this.itemName.setText(this.initialName);
            }
            label = new Label(container, 0);
            label.setText(HTMLPlugin.getResourceString("Label.InsertText"));
            this.insertText = new Text(container, 2818);
            this.insertText.setLayoutData((Object)new GridData(1808));
            if (this.initialText != null) {
                this.insertText.setText(this.initialText);
            }
            return container;
        }

        protected void okPressed() {
            if (this.itemName.getText().equals("")) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("Message.ItemName")}));
                return;
            }
            if (this.insertText.getText().equals("")) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("Message.InsertText")}));
                return;
            }
            this.inputedName = this.itemName.getText();
            this.inputedText = this.insertText.getText();
            super.okPressed();
        }

        public String getItemName() {
            return this.inputedName;
        }

        public String getInsertText() {
            return this.inputedText;
        }
    }
}

