/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.editors.HTMLSourceEditor;
import com.poscoict.mobileframework.htmleditor.views.IPaletteItem;
import com.poscoict.mobileframework.htmleditor.views.dialog.PaletteGenericDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;

public class DialogPaletteItem
implements IPaletteItem {
    private ImageDescriptor image;
    private PaletteGenericDialog dialog;
    private String content;
    private String imageDescriptorKey;

    public DialogPaletteItem(ImageDescriptor image, PaletteGenericDialog dialog) {
        this.image = image;
        this.dialog = dialog;
    }

    public DialogPaletteItem(String imageDescriptorKey, PaletteGenericDialog dialog) {
        this.imageDescriptorKey = imageDescriptorKey;
        this.dialog = dialog;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String colorOption = store.getString("_pref_palette_image_color");
        HTMLPlugin.getDefault();
        HTMLPlugin.logDebug("colorOption = " + colorOption);
        return HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_" + colorOption + this.imageDescriptorKey);
    }

    @Override
    public String getLabel() {
        return null;
    }

    public PaletteGenericDialog getContent() {
        return this.dialog;
    }

    @Override
    public void execute(HTMLSourceEditor editor) {
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        ITextSelection sel = (ITextSelection)editor.getSelectionProvider().getSelection();
        try {
            if (this.dialog.open() == 0) {
                this.content = this.dialog.makejQuerySrc();
                int caret = this.content.length();
                if (this.content.indexOf("></") != -1) {
                    caret = this.content.indexOf("></") + 1;
                }
                doc.replace(sel.getOffset(), sel.getLength(), this.content);
                editor.selectAndReveal(sel.getOffset() + caret, 0);
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

