/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.views;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.editors.HTMLSourceEditor;
import com.poscoict.mobileframework.htmleditor.views.IPaletteItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;

public class DefaultPaletteItem
implements IPaletteItem {
    private ImageDescriptor image;
    private String ImageDescriptorKey;
    private final String content;

    public DefaultPaletteItem(ImageDescriptor image, String content) {
        this.image = image;
        this.content = content;
    }

    public DefaultPaletteItem(String ImageDescriptorKey, String content) {
        this.ImageDescriptorKey = ImageDescriptorKey;
        this.content = content;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String colorOption = store.getString("_pref_palette_image_color");
        if (this.image == null) {
            return HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_" + colorOption + this.ImageDescriptorKey);
        }
        return this.image;
    }

    @Override
    public String getLabel() {
        return null;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public void execute(HTMLSourceEditor editor) {
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        ITextSelection sel = (ITextSelection)editor.getSelectionProvider().getSelection();
        try {
            int caret = this.content.length();
            if (this.content.indexOf("></") != -1) {
                caret = this.content.indexOf("></") + 1;
            }
            doc.replace(sel.getOffset(), sel.getLength(), this.content);
            editor.selectAndReveal(sel.getOffset() + caret, 0);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

