/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.tasktag;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;

public class TaskTag
implements Cloneable {
    private String tag;
    private int priority;
    public static final String HIGH = "High";
    public static final String NORMAL = "Normal";
    public static final String LOW = "Low";
    public static final String[] PRIORITIES = new String[]{"High", "Normal", "Low"};

    public TaskTag(String tag, int priority) {
        this.setTag(tag);
        this.setPriority(priority);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getPriorityName() {
        switch (this.priority) {
            case 2: {
                return HIGH;
            }
            case 1: {
                return NORMAL;
            }
            case 0: {
                return LOW;
            }
        }
        return "";
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    protected TaskTag clone() throws CloneNotSupportedException {
        return new TaskTag(this.getTag(), this.getPriority());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskTag) {
            TaskTag tag = (TaskTag)obj;
            return this.getTag().equals(tag.getTag()) && this.getPriority() == tag.getPriority();
        }
        return false;
    }

    public static boolean hasChange(List<TaskTag> tags1, List<TaskTag> tags2) {
        if (tags1.size() != tags2.size()) {
            return true;
        }
        int i = 0;
        while (i < tags1.size()) {
            TaskTag tag2;
            TaskTag tag1 = tags1.get(i);
            if (!tag1.equals(tag2 = tags2.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List<TaskTag> loadFromPreference(boolean defaults) {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String value = null;
        value = defaults ? store.getDefaultString("__pref_task_tags") : store.getString("__pref_task_tags");
        ArrayList<TaskTag> list = new ArrayList<TaskTag>();
        if (value != null) {
            String[] values = value.split("\n");
            int i = 0;
            while (i < values.length) {
                String[] split = values[i].split("\t");
                if (split.length == 2) {
                    list.add(new TaskTag(split[0], Integer.parseInt(split[1])));
                }
                ++i;
            }
        }
        return list;
    }

    public static void saveToPreference(List<TaskTag> list) {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        StringBuffer sb = new StringBuffer();
        for (TaskTag tag : list) {
            sb.append(tag.getTag());
            sb.append("\t");
            sb.append(tag.getPriority());
            sb.append("\n");
        }
        store.setValue("__pref_task_tags", sb.toString());
    }

    public static int convertPriority(String name) {
        int priority = 1;
        if (name.equals(HIGH)) {
            priority = 2;
        } else if (name.equals(NORMAL)) {
            priority = 1;
        } else if (name.equals(LOW)) {
            priority = 0;
        }
        return priority;
    }
}

