/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.tasktag;

import com.poscoict.mobileframework.htmleditor.tasktag.AbstractTaskTagDetector;
import jp.aonir.fuzzyxml.FuzzyXMLComment;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.FuzzyXMLText;

public class HTMLTaskTagDetector
extends AbstractTaskTagDetector {
    public HTMLTaskTagDetector() {
        this.addSupportedExtension("html");
        this.addSupportedExtension("htm");
        this.addSupportedExtension("xml");
        this.addSupportedExtension("tld");
        this.addSupportedExtension("xsd");
        this.addSupportedExtension("jsp");
        this.addSupportedExtension("jspf");
        this.addSupportedExtension("jspx");
    }

    @Override
    public void doDetect() throws Exception {
        FuzzyXMLDocument doc = new FuzzyXMLParser().parse(this.contents);
        this.processElement(doc.getDocumentElement());
    }

    private void processElement(FuzzyXMLElement element) {
        FuzzyXMLNode[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            String value;
            if (children[i] instanceof FuzzyXMLElement) {
                this.processElement((FuzzyXMLElement)children[i]);
            } else if (children[i] instanceof FuzzyXMLComment) {
                this.detectTaskTag(((FuzzyXMLComment)children[i]).getValue(), children[i].getOffset());
            } else if (children[i] instanceof FuzzyXMLText && (value = ((FuzzyXMLText)children[i]).getValue()).startsWith("<%--")) {
                if (value.endsWith("--%>")) {
                    value = value.substring(0, value.length() - 4);
                }
                this.detectTaskTag(value, children[i].getOffset());
            }
            ++i;
        }
    }
}

