/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.tasktag;

import com.poscoict.mobileframework.htmleditor.HTMLUtil;
import com.poscoict.mobileframework.htmleditor.IOUtil;
import com.poscoict.mobileframework.htmleditor.tasktag.ITaskTagDetector;
import com.poscoict.mobileframework.htmleditor.tasktag.TaskTag;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public abstract class AbstractTaskTagDetector
implements ITaskTagDetector {
    protected String contents;
    protected IFile file;
    protected TaskTag[] tags;
    private final List<String> extensions = new ArrayList<String>();

    protected void addSupportedExtension(String ext) {
        this.extensions.add(ext);
    }

    @Override
    public boolean isSupported(IFile file) {
        String fileName = file.getName();
        int i = 0;
        while (i < this.extensions.size()) {
            String ext = this.extensions.get(i);
            if (fileName.endsWith("." + ext)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void detect(IFile file, TaskTag[] tags) throws Exception {
        this.file = file;
        this.tags = tags;
        this.contents = new String(IOUtil.readStream(file.getContents()), file.getCharset());
        this.contents = this.contents.replaceAll("\r\n", "\n");
        this.contents = this.contents.replaceAll("\r", "\n");
        this.doDetect();
    }

    protected abstract void doDetect() throws Exception;

    protected void detectTaskTag(String value, int offset) {
        String[] lines = value.split("\n");
        int i = 0;
        while (i < lines.length) {
            int j = 0;
            while (j < this.tags.length) {
                int index = lines[i].indexOf(this.tags[j].getTag());
                if (index >= 0) {
                    HTMLUtil.addTaskMarker((IResource)this.file, 1, this.getLineAtOffset(offset) + i, lines[i].substring(index));
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private int getLineAtOffset(int offset) {
        String text = this.contents.substring(0, offset);
        int line = 0;
        int index = 0;
        while ((index = text.indexOf(10, index)) >= 0) {
            ++line;
            ++index;
        }
        return line + 1;
    }
}

