/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.editors;

import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;

public class SoftTabVerifyListener
implements VerifyListener {
    private boolean useSoftTab;
    private String softTab;

    public void verifyText(VerifyEvent evt) {
        if (this.useSoftTab && evt.text.equals("\t")) {
            evt.text = this.softTab;
        }
    }

    public void preferenceChanged(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("_pref_use_softtab")) {
            Object value = event.getNewValue();
            boolean enable = false;
            if (value instanceof String) {
                enable = Boolean.valueOf((String)value);
            } else if (value instanceof Boolean) {
                enable = (Boolean)value;
            }
            this.setUseSoftTab(enable);
        }
        if (key.equals("_pref_softtab_width")) {
            int width = (Integer)event.getNewValue();
            this.setSoftTabWidth(width);
        }
    }

    public void setUseSoftTab(boolean useSoftTab) {
        this.useSoftTab = useSoftTab;
    }

    public void setSoftTabWidth(int softTabWidth) {
        this.softTab = "";
        int i = 0;
        while (i < softTabWidth) {
            this.softTab = String.valueOf(this.softTab) + " ";
            ++i;
        }
    }
}

