/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.editors;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.editors.HTMLEditor;
import com.poscoict.mobileframework.htmleditor.editors.HTMLEditorPart;
import com.poscoict.mobileframework.htmleditor.editors.HTMLSourceEditor;
import com.poscoict.mobileframework.htmleditor.editors.RCPConsoleManager;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPageHTMLEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
HTMLEditorPart {
    public static final String GLUE_CONSOLE = "GlueConsole";
    private HTMLSourceEditor editor;
    private Browser browser;
    private final HTMLEditor wrapper;

    public MultiPageHTMLEditor(HTMLEditor wrapper, HTMLSourceEditor editor) {
        this.wrapper = wrapper;
        this.editor = editor;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public HTMLSourceEditor getSourceEditor() {
        return this.editor;
    }

    private void createPage0() {
        try {
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, HTMLPlugin.getResourceString("MultiPageHTMLEditor.Source"));
            this.setPartName(this.getEditorInput().getName());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    private void createPage1() {
        if (this.isFileEditorInput()) {
            Composite container = new Composite(this.getContainer(), 0);
            container.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout(2, false);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            container.setLayout((Layout)layout);
            Composite composite = new Composite(container, 2048);
            GridData compositeGridData = new GridData(1808);
            compositeGridData.horizontalSpan = 2;
            compositeGridData.minimumHeight = 200;
            composite.setLayoutData((Object)compositeGridData);
            composite.setLayout((Layout)new GridLayout(1, false));
            this.browser = new Browser(composite, 0);
            GridData browserGridData = new GridData(1808);
            this.browser.setLayoutData((Object)browserGridData);
            int index = this.addPage((Control)container);
            this.setPageText(index, HTMLPlugin.getResourceString("MultiPageHTMLEditor.Preview"));
        }
    }

    private void createComponent(Composite container) {
        GridData gridData = new GridData(4, 4, true, false);
        Composite composite = new Composite(container, 2048);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createTextInput(composite);
    }

    private void createTextInput(Composite container) {
        new GridData(4, 4, true, false);
        GridData textGrid = new GridData(1808);
        textGrid.minimumHeight = 100;
        final StyledText t = new StyledText(container, 2626);
        t.setEditable(true);
        t.setLayoutData((Object)textGrid);
        Button button = new Button(container, 8);
        GridData bGridData = new GridData(8);
        button.setLayoutData((Object)bGridData);
        button.setText("Apply Model Data");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = t.getText().trim().replaceAll("\r\n", "");
                try {
                    MultiPageHTMLEditor.this.browser.evaluate("changePage('" + data + "')");
                    MultiPageHTMLEditor.this.browser.execute("changePage('" + data + "')");
                }
                catch (SWTException swte) {
                    MessageConsole myConsole = RCPConsoleManager.findConsole(MultiPageHTMLEditor.GLUE_CONSOLE);
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    String id = "org.eclipse.ui.console.ConsoleView";
                    try {
                        IConsoleView view = (IConsoleView)page.showView(id);
                        view.display((IConsole)myConsole);
                    }
                    catch (Exception ie) {
                        ie.printStackTrace();
                    }
                    MessageConsoleStream out = RCPConsoleManager.getMessageConsoleStream(MultiPageHTMLEditor.GLUE_CONSOLE);
                    out.println("'" + data + "' is " + swte.getMessage());
                }
            }
        });
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
    }

    public void dispose() {
        File tmpFile = this.editor.getTempFile();
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setInput(editor.getEditorInput());
        this.setPartName(this.getEditorInput().getName());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
    }

    @Override
    public boolean isFileEditorInput() {
        return this.editor.isFileEditorInput();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 1) {
            this.wrapper.updatePreview();
        }
    }

    public void setOffset(int offset) {
        this.setActivePage(0);
        this.editor.selectAndReveal(offset, 0);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IEditorInput input;
        if (event.getType() == 1 && (input = this.editor.getEditorInput()) instanceof IFileEditorInput) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IFile file = ((IFileEditorInput)input).getFile();
                    if (!file.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.closeEditor((IEditorPart)MultiPageHTMLEditor.this, false);
                    } else if (!MultiPageHTMLEditor.this.getPartName().equals(file.getName())) {
                        MultiPageHTMLEditor.this.setPartName(file.getName());
                    }
                }
            });
        }
    }

    public Object getAdapter(Class adapter) {
        return this.editor.getAdapter(adapter);
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.wrapper.firePropertyChange2(propertyId);
    }
}

