/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.editors;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.HTMLUtil;
import com.poscoict.mobileframework.htmleditor.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.tidy.Tidy;

public class HTMLValidator
implements FuzzyXMLErrorListener {
    private String original;
    private String contents;
    private IFile file;
    private final Pattern tidy_error;
    private boolean showXMLErrors;

    public HTMLValidator(IFile file) {
        this.file = file;
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        this.showXMLErrors = store.getBoolean("__pref_show_xml_errors");
        this.tidy_error = Pattern.compile("^line ([0-9]+?) column ([0-9]+?) - (.+?)$", 32);
    }

    public void doValidate() {
        try {
            if (this.validateUsingTidy()) {
                ByteArrayOutputStream out = null;
                try {
                    out = new ByteArrayOutputStream();
                    Tidy tidy = new Tidy();
                    tidy.setXHTML(false);
                    tidy.setQuiet(true);
                    tidy.setInputEncoding(this.file.getCharset());
                    tidy.setOutputEncoding("UTF-8");
                    tidy.setErrout(new PrintWriter(out, true));
                    tidy.parse(this.file.getContents(), null);
                    String errors = new String(out.toByteArray());
                    errors = errors.replaceAll("\r\n", "\n");
                    errors = errors.replaceAll("\r", "\n");
                    String[] dim = errors.split("\n");
                    int i = 0;
                    while (i < dim.length) {
                        Matcher matcher;
                        if (dim[i].startsWith("line") && (matcher = this.tidy_error.matcher(dim[i])).matches()) {
                            String message = matcher.group(3);
                            if (message.startsWith("Warning")) {
                                HTMLUtil.addMarker((IResource)this.file, 1, Integer.parseInt(matcher.group(1)), matcher.group(3));
                            } else {
                                HTMLUtil.addMarker((IResource)this.file, 2, Integer.parseInt(matcher.group(1)), matcher.group(3));
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            if (this.validateUsingFuzzyXML()) {
                this.original = new String(IOUtil.readStream(this.file.getContents()), this.file.getCharset());
                String contents = this.filterContents(this.original, this.file);
                this.contents = contents = HTMLUtil.scriptlet2space(contents, false);
                this.contents = this.contents.replaceAll("\r\n", " \n");
                this.contents = this.contents.replaceAll("\r", "\n");
                FuzzyXMLParser parser = new FuzzyXMLParser();
                parser.addErrorListener((FuzzyXMLErrorListener)this);
                FuzzyXMLDocument doc = parser.parse(contents);
                this.validateDocument(doc);
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected boolean validateUsingTidy() {
        String source;
        block5: {
            if (this.file.getName().endsWith(".xhtml")) {
                return false;
            }
            try {
                source = new String(IOUtil.readStream(this.file.getContents()), this.file.getCharset());
                if (source.indexOf("xmlns=\"http://www.w3.org/1999/xhtml\"") < 0) break block5;
                return false;
            }
            catch (Exception exception) {}
        }
        if (source.indexOf("<?xml version=\"1.0\"") >= 0) {
            return false;
        }
        return true;
    }

    protected boolean validateUsingFuzzyXML() {
        return !this.validateUsingTidy();
    }

    protected void validateDocument(FuzzyXMLDocument doc) {
    }

    protected IFile getFile() {
        return this.file;
    }

    protected String getContent() {
        return this.original;
    }

    protected int getLineAtOffset(int offset) {
        String text = this.contents.substring(0, offset + 1);
        return text.split("\n").length;
    }

    protected String filterContents(String contents, IFile file) {
        return contents;
    }

    public void error(FuzzyXMLErrorEvent event) {
        if (!this.showXMLErrors) {
            return;
        }
        int offset = event.getOffset();
        int length = event.getLength();
        String message = event.getMessage();
        HTMLUtil.addMarker((IResource)this.getFile(), 2, this.getLineAtOffset(offset), offset, length, message);
    }
}

