/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.editors;

import com.egen.develop.util.jspFormatter.JSPFormatter;
import com.poscoict.mobileframework.htmleditor.ColorProvider;
import com.poscoict.mobileframework.htmleditor.HTMLHyperlinkDetector;
import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.HTMLProjectParams;
import com.poscoict.mobileframework.htmleditor.HTMLUtil;
import com.poscoict.mobileframework.htmleditor.SearchXPathDialog;
import com.poscoict.mobileframework.htmleditor.assist.HTMLAssistProcessor;
import com.poscoict.mobileframework.htmleditor.editors.FoldingInfo;
import com.poscoict.mobileframework.htmleditor.editors.HTMLAutoEditStrategy;
import com.poscoict.mobileframework.htmleditor.editors.HTMLCharacterPairMatcher;
import com.poscoict.mobileframework.htmleditor.editors.HTMLConfiguration;
import com.poscoict.mobileframework.htmleditor.editors.HTMLFileDocumentProvider;
import com.poscoict.mobileframework.htmleditor.editors.HTMLOutlinePage;
import com.poscoict.mobileframework.htmleditor.editors.HTMLTextDocumentProvider;
import com.poscoict.mobileframework.htmleditor.editors.HTMLValidator;
import com.poscoict.mobileframework.htmleditor.editors.IHTMLOutlinePage;
import com.poscoict.mobileframework.htmleditor.editors.SoftTabVerifyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.Revision;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class HTMLSourceEditor
extends TextEditor {
    private ColorProvider colorProvider;
    private IHTMLOutlinePage outlinePage;
    private HTMLCharacterPairMatcher pairMatcher;
    private SoftTabVerifyListener softTabListener;
    private EditorSelectionChangedListener selectionChangeListener;
    public static final String GROUP_HTML = "_html";
    public static final String ACTION_ESCAPE_HTML = "_escape_html";
    public static final String ACTION_COMMENT = "_comment";
    public static final String ACTION_OPEN_PALETTE = "_open_palette";
    public static final String ACTION_CHOOSE_COLOR = "_choose_color";
    public static final String ACTION_COMPLETION = "ContentAssistProposal";
    public static final String ACTION_FORMAT_HTML = "_format";
    public static final String ACTION_SEARCH_XPATH = "_search_xpath";
    private boolean validation = true;
    private IWorkbenchPage page;
    private ProjectionSupport fProjectionSupport;
    private Pattern tagPattern = Pattern.compile("<([^<]*?)>");
    private Pattern valuePattern = Pattern.compile("\".*?\"");
    private static SearchXPathDialog dialog;

    public HTMLSourceEditor(HTMLConfiguration config) {
        this.colorProvider = HTMLPlugin.getDefault().getColorProvider();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)config);
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), HTMLPlugin.getDefault().getPreferenceStore()}));
        this.setAction(ACTION_ESCAPE_HTML, (IAction)new EscapeHTMLAction());
        this.setAction(ACTION_COMMENT, (IAction)new CommentAction());
        this.setAction(ACTION_OPEN_PALETTE, (IAction)new OpenPaletteAction());
        this.setAction(ACTION_FORMAT_HTML, (IAction)new FormatHTMLAction());
        this.setAction(ACTION_SEARCH_XPATH, (IAction)new SearchXPathAction());
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        this.softTabListener = new SoftTabVerifyListener();
        this.softTabListener.setUseSoftTab(store.getBoolean("_pref_use_softtab"));
        this.softTabListener.setSoftTabWidth(store.getInt("_pref_softtab_width"));
        this.outlinePage = this.createOutlinePage();
        this.setEditorContextMenuId("#AmaterasHTMLEditor");
    }

    protected HTMLCharacterPairMatcher getPairMatcher() {
        return this.pairMatcher;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public boolean getValidation() {
        return this.validation;
    }

    protected IHTMLOutlinePage createOutlinePage() {
        return new HTMLOutlinePage(this);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        viewer.getTextWidget().addVerifyListener((VerifyListener)this.softTabListener);
        return viewer;
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.install();
        projectionViewer.doOperation(19);
        projectionViewer.getTextWidget().setTabs(this.getPreferenceStore().getInt("tabWidth"));
        ITextViewerExtension2 extension = (ITextViewerExtension2)this.getSourceViewer();
        this.pairMatcher = new HTMLCharacterPairMatcher();
        this.pairMatcher.setEnable(this.getPreferenceStore().getBoolean("__pref_pair_character"));
        MatchingCharacterPainter painter = new MatchingCharacterPainter(this.getSourceViewer(), (ICharacterPairMatcher)this.pairMatcher);
        painter.setColor(Display.getDefault().getSystemColor(15));
        extension.addPainter((IPainter)painter);
        this.selectionChangeListener = new EditorSelectionChangedListener();
        this.selectionChangeListener.install(this.getSelectionProvider());
        this.update();
        this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            this.page.showView("com.poscoict.mobileframework.htmleditor.views.PaletteView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return super.affectsTextPresentation(event) || this.colorProvider.affectsTextPresentation(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.colorProvider.handlePreferenceStoreChanged(event);
        this.updateAssistProperties(event);
        this.softTabListener.preferenceChanged(event);
        String key = event.getProperty();
        if (key.equals("__pref_pair_character")) {
            Object value = event.getNewValue();
            boolean enable = false;
            if (value instanceof String) {
                enable = Boolean.valueOf((String)value);
            } else if (value instanceof Boolean) {
                enable = (Boolean)value;
            }
            this.pairMatcher.setEnable(enable);
        }
        if (key.equals("__pref_auto_edit")) {
            boolean enable = (Boolean)event.getNewValue();
            HTMLConfiguration config = (HTMLConfiguration)this.getSourceViewerConfiguration();
            HTMLAutoEditStrategy autoEdit = config.getAutoEditStrategy();
            autoEdit.setEnabled(enable);
        }
        super.handlePreferenceStoreChanged(event);
    }

    private void updateAssistProperties(PropertyChangeEvent event) {
        String key = event.getProperty();
        try {
            if (key.equals("_pref_assist_times")) {
                ContentAssistant assistant = (ContentAssistant)this.getSourceViewerConfiguration().getContentAssistant(null);
                assistant.setAutoActivationDelay(Integer.parseInt((String)event.getNewValue()));
            } else if (key.equals("_pref_assist_chars")) {
                ContentAssistant assistant = (ContentAssistant)this.getSourceViewerConfiguration().getContentAssistant(null);
                HTMLAssistProcessor processor = (HTMLAssistProcessor)assistant.getContentAssistProcessor("__dftl_partition_content_type");
                processor.setAutoAssistChars(((String)event.getNewValue()).toCharArray());
            } else if (key.equals("_pref_assist_close")) {
                ContentAssistant assistant = (ContentAssistant)this.getSourceViewerConfiguration().getContentAssistant(null);
                HTMLAssistProcessor processor = (HTMLAssistProcessor)assistant.getContentAssistProcessor("__dftl_partition_content_type");
                processor.setAssistCloseTag((Boolean)event.getNewValue());
            } else if (key.equals("_pref_assist_auto")) {
                ContentAssistant assistant = (ContentAssistant)this.getSourceViewerConfiguration().getContentAssistant(null);
                assistant.enableAutoActivation(((Boolean)event.getNewValue()).booleanValue());
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected void addContextMenuActions(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(GROUP_HTML));
        this.addAction(menu, GROUP_HTML, ACTION_SEARCH_XPATH);
        this.addAction(menu, GROUP_HTML, ACTION_CHOOSE_COLOR);
        this.addAction(menu, GROUP_HTML, ACTION_OPEN_PALETTE);
        this.addAction(menu, GROUP_HTML, ACTION_ESCAPE_HTML);
        this.addAction(menu, GROUP_HTML, ACTION_COMMENT);
        this.addAction(menu, GROUP_HTML, ACTION_FORMAT_HTML);
    }

    protected final void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addContextMenuActions(menu);
    }

    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        ITextSelection sel = (ITextSelection)this.getSelectionProvider().getSelection();
        if (sel.getText().equals("")) {
            this.getAction(ACTION_COMMENT).setEnabled(false);
            this.getAction(ACTION_ESCAPE_HTML).setEnabled(false);
        } else {
            this.getAction(ACTION_COMMENT).setEnabled(true);
            this.getAction(ACTION_ESCAPE_HTML).setEnabled(true);
        }
    }

    protected void doValidate() {
        new Job("HTML Validation"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IFileEditorInput input = (IFileEditorInput)HTMLSourceEditor.this.getEditorInput();
                    IFile file = input.getFile();
                    file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                    HTMLProjectParams params = new HTMLProjectParams(file.getProject());
                    if (params.getValidateHTML()) {
                        new HTMLValidator(input.getFile()).doValidate();
                    }
                }
                catch (Exception exception) {}
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public String getHTMLSource() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
    }

    protected void update() {
        this.updateFolding();
        this.updateAssist();
        this.outlinePage.update();
        this.outlinePage.setSelection(this.getViewer().getTextWidget().getCaretOffset());
        if (this.validation && this.isFileEditorInput()) {
            this.doValidate();
        }
        HTMLHyperlinkDetector hyperlinkDetector = ((HTMLConfiguration)this.getSourceViewerConfiguration()).getHyperlinkDetector();
        hyperlinkDetector.setEditor(this);
    }

    protected void updateAssist() {
        final String html = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
        new Job("Update Content Assist Information"){

            protected IStatus run(IProgressMonitor monitor) {
                HTMLAssistProcessor processor = ((HTMLConfiguration)HTMLSourceEditor.this.getSourceViewerConfiguration()).getAssistProcessor();
                processor.update(HTMLSourceEditor.this, html);
                if (!HTMLSourceEditor.this.isFileEditorInput()) {
                    return Status.OK_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void dispose() {
        if (this.selectionChangeListener != null) {
            this.selectionChangeListener.uninstall(this.getSelectionProvider());
            this.selectionChangeListener = null;
        }
        if (this.isFileEditorInput() && this.validation) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            IFileEditorInput input = (IFileEditorInput)HTMLSourceEditor.this.getEditorInput();
                            HTMLProjectParams params = new HTMLProjectParams(input.getFile().getProject());
                            if (params.getRemoveMarkers()) {
                                input.getFile().deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                            }
                        }
                        catch (Exception exception) {}
                    }
                }, null);
            }
            catch (Exception exception) {}
        }
        this.fProjectionSupport.dispose();
        this.pairMatcher.dispose();
        super.dispose();
    }

    public File getFile() {
        IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        return file.getLocation().makeAbsolute().toFile();
    }

    public File getTempFile() {
        IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        return new File(file.getLocation().makeAbsolute().toFile().getParentFile(), "." + file.getName());
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(HTMLPlugin.getDefault().getResourceBundle(), ACTION_COMPLETION, (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(ACTION_COMPLETION, (IAction)action);
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            return this.outlinePage;
        }
        if (ProjectionAnnotationModel.class.equals((Object)adapter) && this.fProjectionSupport != null && (obj = this.fProjectionSupport.getAdapter(this.getSourceViewer(), adapter)) != null) {
            return obj;
        }
        if (IDocumentProvider.class.equals((Object)adapter)) {
            return this.getDocumentProvider();
        }
        if (ISelectionProvider.class.equals((Object)adapter)) {
            return this.getSelectionProvider();
        }
        return super.getAdapter(adapter);
    }

    protected IDocumentProvider createDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return new HTMLTextDocumentProvider();
        }
        if (input instanceof IStorageEditorInput) {
            return new HTMLFileDocumentProvider();
        }
        return new HTMLTextDocumentProvider();
    }

    protected final void doSetInput(IEditorInput input) throws CoreException {
        IFile file;
        this.setDocumentProvider(this.createDocumentProvider(input));
        if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()).getName().endsWith(".xhtml")) {
            HTMLConfiguration config = (HTMLConfiguration)this.getSourceViewerConfiguration();
            config.getAssistProcessor().setXHTMLMode(true);
        }
        super.doSetInput(input);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.update();
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.update();
    }

    protected void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        ITextSelection textSelection = (ITextSelection)selection;
        if (this.outlinePage != null) {
            this.outlinePage.setSelection(textSelection.getOffset());
        }
    }

    public void setDiff(String text) {
        IEditorInput input = this.getEditorInput();
        IDocument doc = this.getDocumentProvider().getDocument((Object)input);
        this.getSourceViewer().getTextWidget().setRedraw(false);
        Object[] text1 = doc.get().split("\n");
        Object[] text2 = text.split("\n");
        try {
            Revision rev = Diff.diff((Object[])text1, (Object[])text2);
            int count1 = 0;
            int count2 = 0;
            int index = 0;
            int i = 0;
            while (i < rev.size()) {
                Delta delta = rev.getDelta(i);
                Range orgRange = new Range(delta.getOriginal().rangeString());
                Range revRange = new Range(delta.getRevised().rangeString());
                while (count1 != orgRange.getFrom() - 1) {
                    index = index + ((String)text1[count1]).length() + 1;
                    ++count1;
                }
                count1 = orgRange.getFrom() - 1;
                count2 = revRange.getFrom() - 1;
                if (delta instanceof AddDelta) {
                    while (count2 != revRange.getTo()) {
                        doc.replace(index, 0, String.valueOf(text2[count2]) + "\n");
                        index = index + ((String)text2[count2]).length() + 1;
                        ++count2;
                    }
                } else if (delta instanceof DeleteDelta) {
                    while (count1 != orgRange.getTo()) {
                        doc.replace(index, ((String)text1[count1]).length() + 1, "");
                        ++count1;
                    }
                } else if (delta instanceof ChangeDelta) {
                    while (count1 != orgRange.getTo()) {
                        doc.replace(index, ((String)text1[count1]).length() + 1, "");
                        ++count1;
                    }
                    while (count2 != revRange.getTo()) {
                        doc.replace(index, 0, String.valueOf(text2[count2]) + "\n");
                        index = index + ((String)text2[count2]).length() + 1;
                        ++count2;
                    }
                }
                count1 = orgRange.getTo();
                count2 = revRange.getTo();
                ++i;
            }
        }
        catch (Exception exception) {
            doc.set(text);
        }
        this.getSourceViewer().getTextWidget().setRedraw(true);
    }

    private void updateFolding() {
        try {
            ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
            if (viewer == null) {
                return;
            }
            ProjectionAnnotationModel model = viewer.getProjectionAnnotationModel();
            if (model == null) {
                return;
            }
            ArrayList<FoldingInfo> list = new ArrayList<FoldingInfo>();
            Stack<FoldingInfo> stack = new Stack<FoldingInfo>();
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            String xml = HTMLUtil.scriptlet2space(HTMLUtil.comment2space(doc.get(), true), true);
            Matcher matcher = this.valuePattern.matcher(xml);
            while (matcher.find()) {
                int start = matcher.start(0);
                int length = matcher.group(0).length();
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < length) {
                    sb.append(" ");
                    ++i;
                }
                xml = String.valueOf(xml.substring(0, start)) + sb.toString() + xml.substring(start + length);
            }
            matcher = this.tagPattern.matcher(xml);
            block4: while (matcher.find()) {
                String text = matcher.group(1).trim();
                if (text.startsWith("?")) continue;
                if (text.startsWith("!DOCTYPE")) {
                    if (doc.getLineOfOffset(matcher.start()) == doc.getLineOfOffset(matcher.end())) continue;
                    FoldingInfo info = new FoldingInfo(matcher.start(), matcher.end(), "!DOCTYPE");
                    info.setEnd(info.getEnd() + FoldingInfo.countUpLineDelimiter(xml, matcher.end()));
                    list.add(info);
                    continue;
                }
                if (text.startsWith("%")) {
                    if (doc.getLineOfOffset(matcher.start()) == doc.getLineOfOffset(matcher.end())) continue;
                    FoldingInfo info = new FoldingInfo(matcher.start(), matcher.end(), "%");
                    info.setEnd(info.getEnd() + FoldingInfo.countUpLineDelimiter(xml, matcher.end()));
                    list.add(info);
                    continue;
                }
                if (text.startsWith("!--")) {
                    if (doc.getLineOfOffset(matcher.start()) == doc.getLineOfOffset(matcher.end())) continue;
                    FoldingInfo info = new FoldingInfo(matcher.start(), matcher.end(), "!--");
                    info.setEnd(info.getEnd() + FoldingInfo.countUpLineDelimiter(xml, matcher.end()));
                    list.add(info);
                    continue;
                }
                if (text.startsWith("/")) {
                    text = text.substring(1, text.length());
                    while (stack.size() != 0) {
                        FoldingInfo info = (FoldingInfo)stack.pop();
                        if (!info.getType().toLowerCase().equals(text.toLowerCase())) continue;
                        info.setEnd(matcher.end());
                        if (doc.getLineOfOffset(info.getStart()) == doc.getLineOfOffset(info.getEnd())) continue block4;
                        info.setEnd(info.getEnd() + FoldingInfo.countUpLineDelimiter(xml, matcher.end()));
                        list.add(info);
                        continue block4;
                    }
                    continue;
                }
                if (text.endsWith("/")) {
                    if (doc.getLineOfOffset(matcher.start()) == doc.getLineOfOffset(matcher.end())) continue;
                    text.substring(0, text.length() - 1);
                    if (text.indexOf(" ") != -1) {
                        text = text.substring(0, text.indexOf(" "));
                    }
                    FoldingInfo info = new FoldingInfo(matcher.start(), matcher.end(), text);
                    info.setEnd(info.getEnd() + FoldingInfo.countUpLineDelimiter(xml, matcher.end()));
                    list.add(info);
                    continue;
                }
                if ((text = text.replaceAll("[\\s\r\n]+", " ")).indexOf(" ") != -1) {
                    text = text.substring(0, text.indexOf(" "));
                }
                stack.push(new FoldingInfo(matcher.start(), 0, text));
            }
            FoldingInfo.applyModifiedAnnotations(model, list);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public boolean isFileEditorInput() {
        return this.getEditorInput() instanceof IFileEditorInput;
    }

    private class CommentAction
    extends Action {
        public CommentAction() {
            super(HTMLPlugin.getResourceString("HTMLEditor.CommentAction"));
            this.setEnabled(false);
            this.setAccelerator(262191);
        }

        public void run() {
            ITextSelection sel = (ITextSelection)HTMLSourceEditor.this.getSelectionProvider().getSelection();
            IDocument doc = HTMLSourceEditor.this.getDocumentProvider().getDocument((Object)HTMLSourceEditor.this.getEditorInput());
            String text = sel.getText().trim();
            try {
                if (text.startsWith("<!--") && text.indexOf("-->") > 3) {
                    text = sel.getText().replaceFirst("<!--", "");
                    text = text.replaceFirst("-->", "");
                    doc.replace(sel.getOffset(), sel.getLength(), text);
                } else {
                    doc.replace(sel.getOffset(), sel.getLength(), "<!--" + sel.getText() + "-->");
                }
            }
            catch (BadLocationException e) {
                HTMLPlugin.logException(e);
            }
        }
    }

    private class EditorSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
            super((AbstractTextEditor)HTMLSourceEditor.this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            HTMLSourceEditor.this.selectionChanged(event);
        }
    }

    private class EscapeHTMLAction
    extends Action {
        public EscapeHTMLAction() {
            super(HTMLPlugin.getResourceString("HTMLEditor.EscapeAction"));
            this.setEnabled(false);
            this.setAccelerator(262236);
        }

        public void run() {
            ITextSelection sel = (ITextSelection)HTMLSourceEditor.this.getSelectionProvider().getSelection();
            IDocument doc = HTMLSourceEditor.this.getDocumentProvider().getDocument((Object)HTMLSourceEditor.this.getEditorInput());
            try {
                doc.replace(sel.getOffset(), sel.getLength(), HTMLUtil.escapeHTML(sel.getText()));
            }
            catch (BadLocationException e) {
                HTMLPlugin.logException(e);
            }
        }
    }

    private class FormatHTMLAction
    extends Action {
        public FormatHTMLAction() {
            super(HTMLPlugin.getResourceString("HTMLEditor.Format"));
        }

        public void run() {
            IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
            int prefIndent = store.getInt("_pref_formatter_indent");
            boolean prefUseTab = store.getBoolean("_pref_formatter_tab");
            int lineChars = store.getInt("_pref_formatter_line");
            String defaultIndent = "";
            if (prefUseTab) {
                int i = 0;
                while (i < prefIndent) {
                    defaultIndent = String.valueOf(defaultIndent) + " ";
                    ++i;
                }
            } else {
                prefIndent = 2;
            }
            try {
                IDocument doc = HTMLSourceEditor.this.getDocumentProvider().getDocument((Object)HTMLSourceEditor.this.getEditorInput());
                ITextSelection sel = (ITextSelection)HTMLSourceEditor.this.getSelectionProvider().getSelection();
                if (sel == null || sel.getLength() == 0) {
                    String source = doc.get();
                    JSPFormatter formatter = new JSPFormatter(source, prefIndent, lineChars);
                    String result = formatter.format();
                    if (prefUseTab) {
                        result = result.replaceAll(defaultIndent, "\t");
                    }
                    doc.set(result);
                } else {
                    int offset = sel.getOffset();
                    int length = sel.getLength();
                    int startLine = doc.getLineOfOffset(offset);
                    int startLineOffset = doc.getLineOffset(startLine);
                    int startLineLength = doc.getLineLength(startLine);
                    String lineText = doc.get(startLineOffset, startLineLength);
                    String indent = "";
                    int i = 0;
                    while (i < lineText.length()) {
                        char c = lineText.charAt(i);
                        if (c != ' ' && c != '\t') break;
                        indent = String.valueOf(indent) + c;
                        ++i;
                    }
                    String source = doc.get(offset, length);
                    JSPFormatter formatter = new JSPFormatter(source, prefIndent, lineChars);
                    String result = formatter.format();
                    result = String.valueOf(indent) + result.replaceAll("(\r\n|\r|\n)", "$1" + indent);
                    if (prefUseTab) {
                        result = result.replaceAll(defaultIndent, "\t");
                    }
                    doc.replace(offset, length, result);
                }
            }
            catch (Exception ex) {
                HTMLPlugin.openAlertDialog(ex.toString());
            }
        }
    }

    private class OpenPaletteAction
    extends Action {
        public OpenPaletteAction() {
            super(HTMLPlugin.getResourceString("HTMLEditor.OpenPaletteAction"), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_palette"));
            this.setEnabled(true);
        }

        public void run() {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                window.getActivePage().showView("com.poscoict.mobileframework.htmleditor.views.PaletteView");
            }
            catch (Exception ex) {
                HTMLPlugin.openAlertDialog(ex.toString());
            }
        }
    }

    private class Range {
        private int from;
        private int to;

        public Range(String rangeString) {
            if (rangeString.indexOf(",") != -1) {
                String[] dim = rangeString.split(",");
                this.from = Integer.parseInt(dim[0]);
                this.to = Integer.parseInt(dim[1]);
            } else {
                this.from = Integer.parseInt(rangeString);
                this.to = Integer.parseInt(rangeString);
            }
        }

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }
    }

    private class SearchXPathAction
    extends Action {
        public SearchXPathAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.XPathSearch"));
        }

        public void run() {
            if (dialog == null) {
                dialog = new SearchXPathDialog(HTMLSourceEditor.this.getEditorSite().getShell());
            }
            dialog.open();
        }
    }
}

