/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.editors;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.datamodel.JQueryMobileConstants;
import com.poscoict.mobileframework.htmleditor.datamodel.TemplateConfiguration;
import com.poscoict.mobileframework.htmleditor.editors.HTMLConfiguration;
import com.poscoict.mobileframework.htmleditor.editors.HTMLEditorPart;
import com.poscoict.mobileframework.htmleditor.editors.HTMLSourceEditor;
import com.poscoict.mobileframework.htmleditor.editors.MultiPageHTMLEditor;
import com.poscoict.mobileframework.htmleditor.editors.SplitPageHTMLEditor;
import com.poscoict.mobileframework.htmleditor.utils.BundleLocator;
import com.poscoict.mobileframework.htmleditor.views.IPaletteTarget;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class HTMLEditor
extends EditorPart
implements IPaletteTarget,
JQueryMobileConstants {
    protected EditorPart editor;
    protected File prevTempFile = null;

    public HTMLEditor() {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String type = store.getString("_pref_editor_type");
        if (type.equals("horizontal")) {
            this.editor = new SplitPageHTMLEditor(this, true, this.createHTMLSourceEditor(this.getSourceViewerConfiguration()));
        } else if (type.equals("vertical")) {
            this.editor = new SplitPageHTMLEditor(this, false, this.createHTMLSourceEditor(this.getSourceViewerConfiguration()));
        } else if (type.equals("tab")) {
            this.editor = new MultiPageHTMLEditor(this, this.createHTMLSourceEditor(this.getSourceViewerConfiguration()));
        } else {
            this.editor = this.createHTMLSourceEditor(this.getSourceViewerConfiguration());
            this.editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propertyId) {
                    HTMLEditor.this.firePropertyChange(propertyId);
                }
            });
        }
    }

    protected HTMLConfiguration getSourceViewerConfiguration() {
        return new HTMLConfiguration(HTMLPlugin.getDefault().getColorProvider());
    }

    protected HTMLSourceEditor createHTMLSourceEditor(HTMLConfiguration config) {
        return new HTMLSourceEditor(config);
    }

    @Override
    public HTMLSourceEditor getPaletteTarget() {
        if (this.editor instanceof HTMLSourceEditor) {
            return (HTMLSourceEditor)this.editor;
        }
        return ((HTMLEditorPart)this.editor).getSourceEditor();
    }

    public void updatePreview() {
        if (!(this.editor instanceof HTMLEditorPart)) {
            return;
        }
        try {
            if (!((HTMLEditorPart)this.editor).isFileEditorInput()) {
                return;
            }
            HTMLEditorPart editor = (HTMLEditorPart)this.editor;
            IFileEditorInput input = (IFileEditorInput)this.editor.getEditorInput();
            String charset = input.getFile().getCharset();
            StringWriter writer = new StringWriter();
            Template temp = TemplateConfiguration.getInstance().getTemplate("preview.ftl");
            HashMap<String, String> dataModel = new HashMap<String, String>();
            String filePath = BundleLocator.getInstance().getBundleFilePath();
            dataModel.put("JQUERY_MOBILE_CSS", "file://" + filePath + "css/jquery.mobile.css");
            dataModel.put("GLUE_MOBILE_CSS", "file://" + filePath + "css/theme-posco.css");
            dataModel.put("JQUEYR", "file://" + filePath + "js/libs/jquery.js");
            dataModel.put("JQUERY_MOBILE", "file://" + filePath + "js/libs/jquerymobile.js");
            dataModel.put("components", editor.getSourceEditor().getDocumentProvider().getDocument((Object)input).get());
            temp.process(dataModel, (Writer)writer);
            String html = ((Object)writer).toString();
            File tmpFile = editor.getSourceEditor().getTempFile();
            FileOutputStream out = new FileOutputStream(tmpFile);
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, charset), true);
            pw.write(html);
            pw.close();
            if (this.prevTempFile != null && this.prevTempFile.equals(tmpFile)) {
                editor.getBrowser().refresh();
            } else {
                if (this.prevTempFile != null) {
                    this.prevTempFile.delete();
                }
                this.prevTempFile = tmpFile;
                editor.getBrowser().setUrl("file://" + tmpFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public void createPartControl(Composite parent) {
        this.editor.createPartControl(parent);
    }

    public void dispose() {
        this.editor.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.editor.doSave(monitor);
    }

    public void doSaveAs() {
        this.editor.doSaveAs();
    }

    public Object getAdapter(Class adapter) {
        return this.editor.getAdapter(adapter);
    }

    public String getContentDescription() {
        return this.editor.getContentDescription();
    }

    public IEditorInput getEditorInput() {
        return this.editor.getEditorInput();
    }

    public IEditorSite getEditorSite() {
        return this.editor.getEditorSite();
    }

    public String getPartName() {
        return this.editor.getPartName();
    }

    public IWorkbenchPartSite getSite() {
        return this.editor.getSite();
    }

    public String getTitle() {
        return this.editor.getTitle();
    }

    public Image getTitleImage() {
        return this.editor.getTitleImage();
    }

    public String getTitleToolTip() {
        return this.editor.getTitleToolTip();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.editor.init(site, input);
    }

    public boolean isDirty() {
        return this.editor.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return this.editor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        return this.editor.isSaveOnCloseNeeded();
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.editor.setInitializationData(config, propertyName, data);
    }

    public void showBusy(boolean busy) {
        this.editor.showBusy(busy);
    }

    public void setOffset(int offset) {
        if (this.editor instanceof SplitPageHTMLEditor) {
            ((SplitPageHTMLEditor)this.editor).setOffset(offset);
        } else if (this.editor instanceof MultiPageHTMLEditor) {
            ((MultiPageHTMLEditor)this.editor).setOffset(offset);
        } else if (this.editor instanceof HTMLSourceEditor) {
            ((HTMLSourceEditor)this.editor).selectAndReveal(offset, 0);
        }
    }

    public void firePropertyChange2(int propertyId) {
        super.firePropertyChange(propertyId);
    }
}

