/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor.assist;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.IFileAssistProcessor;
import com.poscoict.mobileframework.htmleditor.assist.AssistInfo;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;

public class FileAssistProcessor
implements IFileAssistProcessor {
    private IFile file;

    @Override
    public void reload(IFile file) {
        this.file = file;
    }

    @Override
    public AssistInfo[] getAssistInfo(String value) {
        int index;
        IPath path = null;
        String parent = null;
        if (value.startsWith("/")) {
            return new AssistInfo[0];
        }
        if (path == null) {
            path = this.file.getParent().getProjectRelativePath();
        }
        if ((index = value.lastIndexOf(47)) >= 0) {
            path = path.append(value.substring(0, index));
            parent = String.valueOf(value.substring(0, index)) + "/";
        } else {
            parent = "";
        }
        IResource resource = this.file.getProject().findMember(path);
        if (resource != null && resource.exists() && resource instanceof IContainer) {
            try {
                IContainer container = (IContainer)resource;
                IResource[] children = container.members();
                ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
                int i = 0;
                while (i < children.length) {
                    if (!children[i].getName().startsWith(".") && !children[i].getName().equals("WEB-INF") && parent.indexOf("WEB-INF") < 0) {
                        Image image = null;
                        image = children[i] instanceof IContainer ? HTMLPlugin.getDefault().getImageRegistry().get("_icon_folder") : this.getFileImage(children[i].getName().toLowerCase());
                        list.add(new AssistInfo(String.valueOf(parent) + children[i].getName(), children[i].getName(), image));
                    }
                    ++i;
                }
                return list.toArray(new AssistInfo[list.size()]);
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        return new AssistInfo[0];
    }

    private Image getFileImage(String name) {
        if (name.endsWith(".html") || name.endsWith(".htm") || name.endsWith(".shtml")) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_html");
        }
        if (name.endsWith(".xml") || name.endsWith(".xhtml") || name.equals(".tld")) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_xml");
        }
        if (name.endsWith(".jsp")) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_jsp");
        }
        if (name.endsWith(".css")) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_css");
        }
        int i = 0;
        while (i < HTMLPlugin.SUPPORTED_IMAGE_TYPES.length) {
            if (name.endsWith("." + HTMLPlugin.SUPPORTED_IMAGE_TYPES[i])) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_web");
            }
            ++i;
        }
        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_file");
    }
}

