/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class TableViewerSupport<T> {
    private Composite control;
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private final List<T> model;

    public TableViewerSupport(List<T> model, Composite parent) {
        this.model = model;
        this.initComponents(parent);
    }

    public Control getControl() {
        return this.control;
    }

    private void initComponents(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TableViewer(this.control, 68354);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path;
                TableItem[] items = TableViewerSupport.this.viewer.getTable().getSelection();
                boolean enable = false;
                if (items.length > 0 && !(path = items[0].getText(1)).equals("[Default]")) {
                    enable = true;
                }
                TableViewerSupport.this.buttonEdit.setEnabled(enable);
                TableViewerSupport.this.buttonRemove.setEnabled(enable);
            }
        });
        this.initTableViewer(this.viewer);
        Composite buttons = new Composite(this.control, 0);
        buttons.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.buttonAdd = new Button(buttons, 8);
        this.buttonAdd.setText(HTMLPlugin.getResourceString("Button.Add"));
        this.buttonAdd.setLayoutData((Object)TableViewerSupport.createButtonGridData());
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Object obj = TableViewerSupport.this.doAdd();
                if (obj != null) {
                    TableViewerSupport.this.model.add(obj);
                    TableViewerSupport.this.viewer.refresh();
                }
            }
        });
        this.buttonEdit = new Button(buttons, 8);
        this.buttonEdit.setText(HTMLPlugin.getResourceString("Button.Edit"));
        this.buttonEdit.setLayoutData((Object)TableViewerSupport.createButtonGridData());
        this.buttonEdit.setEnabled(false);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)TableViewerSupport.this.viewer.getSelection();
                Object obj = sel.getFirstElement();
                TableViewerSupport.this.doEdit(obj);
                TableViewerSupport.this.viewer.refresh();
            }
        });
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText(HTMLPlugin.getResourceString("Button.Remove"));
        this.buttonRemove.setLayoutData((Object)TableViewerSupport.createButtonGridData());
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)TableViewerSupport.this.viewer.getSelection();
                List list = sel.toList();
                TableViewerSupport.this.doRemove(list);
                TableViewerSupport.this.viewer.refresh();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)TableViewerSupport.this.viewer.getSelection();
                if (sel == null || sel.getFirstElement() == null) {
                    TableViewerSupport.this.buttonEdit.setEnabled(false);
                    TableViewerSupport.this.buttonRemove.setEnabled(false);
                } else {
                    TableViewerSupport.this.buttonEdit.setEnabled(true);
                    TableViewerSupport.this.buttonRemove.setEnabled(true);
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.viewer.setInput(this.model);
    }

    protected abstract void initTableViewer(TableViewer var1);

    protected abstract T doAdd();

    protected abstract void doEdit(T var1);

    protected void doRemove(List<T> objList) {
        this.model.removeAll(objList);
    }

    protected abstract ITableLabelProvider createLabelProvider();

    public List<T> getModel() {
        return this.model;
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    private static GridData createButtonGridData() {
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        return gd;
    }

    public static class ListContentProvider
    implements IStructuredContentProvider {
        List fContents;

        public Object[] getElements(Object input) {
            if (this.fContents != null && this.fContents == input) {
                return this.fContents.toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fContents = newInput instanceof List ? (List)newInput : null;
        }

        public void dispose() {
        }

        public boolean isDeleted(Object o) {
            return this.fContents != null && !this.fContents.contains(o);
        }
    }
}

