/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.HTMLUtil;
import com.poscoict.mobileframework.htmleditor.editors.HTMLSourceEditor;
import com.poscoict.mobileframework.htmleditor.views.IPaletteTarget;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;

public class SearchXPathDialog
extends Window {
    private Text xpath;
    private Button next;
    private Button prev;
    private Label status;

    public SearchXPathDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(HTMLPlugin.getResourceString("XMLEditor.XPathSearch"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("&XPath:");
        this.xpath = new Text(composite, 2048);
        this.xpath.setLayoutData((Object)new GridData(768));
        this.xpath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                boolean enabled = SearchXPathDialog.this.xpath.getText().length() > 0;
                SearchXPathDialog.this.next.setEnabled(enabled);
                SearchXPathDialog.this.prev.setEnabled(enabled);
            }
        });
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        this.next = new Button(buttons, 8);
        this.next.setText(HTMLPlugin.getResourceString("Button.SearchNext"));
        this.next.setEnabled(false);
        this.next.setLayoutData((Object)new GridData(768));
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyXMLNode[] nodes = SearchXPathDialog.this.searchNodes();
                if (nodes != null) {
                    SearchXPathDialog.this.status.setText(String.valueOf(nodes.length) + " nodes matched");
                    HTMLSourceEditor editor = SearchXPathDialog.this.getActiveEditor();
                    ITextSelection sel = (ITextSelection)editor.getSelectionProvider().getSelection();
                    int offset = sel.getOffset() + sel.getLength();
                    int i = 0;
                    while (i < nodes.length) {
                        if (nodes[i].getOffset() >= offset) {
                            editor.getSelectionProvider().setSelection((ISelection)new TextSelection(nodes[i].getOffset(), nodes[i].getLength()));
                            break;
                        }
                        ++i;
                    }
                }
                SearchXPathDialog.this.xpath.setFocus();
            }
        });
        this.getShell().setDefaultButton(this.next);
        this.prev = new Button(buttons, 8);
        this.prev.setText(HTMLPlugin.getResourceString("Button.SearchPrev"));
        this.prev.setEnabled(false);
        this.prev.setLayoutData((Object)new GridData(768));
        this.prev.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyXMLNode[] nodes = SearchXPathDialog.this.searchNodes();
                if (nodes != null) {
                    SearchXPathDialog.this.status.setText(String.valueOf(nodes.length) + " nodes matched");
                    HTMLSourceEditor editor = SearchXPathDialog.this.getActiveEditor();
                    ITextSelection sel = (ITextSelection)editor.getSelectionProvider().getSelection();
                    int offset = sel.getOffset();
                    int i = nodes.length - 1;
                    while (i >= 0) {
                        if (nodes[i].getOffset() < offset) {
                            editor.getSelectionProvider().setSelection((ISelection)new TextSelection(nodes[i].getOffset(), nodes[i].getLength()));
                            break;
                        }
                        --i;
                    }
                }
                SearchXPathDialog.this.xpath.setFocus();
            }
        });
        this.status = new Label(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.status.setLayoutData((Object)gd);
        return composite;
    }

    private HTMLSourceEditor getActiveEditor() {
        IEditorPart part = HTMLUtil.getActiveEditor();
        if (part instanceof HTMLSourceEditor) {
            return (HTMLSourceEditor)part;
        }
        if (part instanceof IPaletteTarget) {
            return ((IPaletteTarget)part).getPaletteTarget();
        }
        return null;
    }

    private FuzzyXMLNode[] searchNodes() {
        HTMLSourceEditor editor = this.getActiveEditor();
        if (editor != null) {
            String query = this.xpath.getText();
            String xml = editor.getHTMLSource();
            FuzzyXMLDocument doc = new FuzzyXMLParser().parse(xml);
            try {
                return XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)query);
            }
            catch (Exception ex) {
                this.status.setText(ex.getMessage());
                return null;
            }
        }
        this.status.setText("Unsupported editor");
        return null;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        point.x = 400;
        return point;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }
}

